/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.AbstractPage;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemotePageHistory {
    private long id;
    private int version;
    private String modifier;
    private Date modified;

    public RemotePageHistory() {
    }

    public RemotePageHistory(AbstractPage abstractPage) {
        this.id = abstractPage.getId();
        this.version = abstractPage.getVersion();
        this.modifier = abstractPage.getLastModifierName();
        this.modified = new Date(abstractPage.getLastModificationDate().getTime());
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String string) {
        this.modifier = string;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RemotePageHistory)) {
            return false;
        }
        RemotePageHistory remotePageHistory = (RemotePageHistory)object;
        if (this.id != remotePageHistory.id) {
            return false;
        }
        if (this.version != remotePageHistory.version) {
            return false;
        }
        if (this.modified != null ? !this.modified.equals(remotePageHistory.modified) : remotePageHistory.modified != null) {
            return false;
        }
        return !(this.modifier != null ? !this.modifier.equals(remotePageHistory.modifier) : remotePageHistory.modifier != null);
    }

    public int hashCode() {
        int n = (int)(this.id ^ this.id >>> 32);
        n = 29 * n + this.version;
        n = 29 * n + (this.modifier != null ? this.modifier.hashCode() : 0);
        n = 29 * n + (this.modified != null ? this.modified.hashCode() : 0);
        return n;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

