/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.setup.BootstrapUtils;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteComment {
    long id;
    long pageId;
    long parentId;
    Date created;
    String title;
    String url;
    String creator;
    String content;

    public RemoteComment() {
    }

    public RemoteComment(Comment comment) {
        this.id = comment.getId();
        this.pageId = comment.getPage().getId();
        this.parentId = comment.getParent() != null && comment.getPage().equals((Object)comment.getParent().getPage()) ? comment.getParent().getId() : 0L;
        this.title = comment.getRealTitle();
        this.url = BootstrapUtils.getBootstrapManager().getBaseUrl() + comment.getUrlPath();
        this.content = comment.getContent();
        if (comment.getCreationDate() != null) {
            this.created = new Date(comment.getCreationDate().getTime());
        }
        if (comment.getCreatorName() != null) {
            this.creator = comment.getCreatorName();
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getPageId() {
        return this.pageId;
    }

    public void setPageId(long l) {
        this.pageId = l;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date date) {
        this.created = date;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long l) {
        this.parentId = l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RemoteComment)) {
            return false;
        }
        RemoteComment remoteComment = (RemoteComment)object;
        if (this.id != remoteComment.id) {
            return false;
        }
        if (this.pageId != remoteComment.pageId) {
            return false;
        }
        if (this.content != null ? !this.content.equals(remoteComment.content) : remoteComment.content != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(remoteComment.created) : remoteComment.created != null) {
            return false;
        }
        if (this.creator != null ? !this.creator.equals(remoteComment.creator) : remoteComment.creator != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(remoteComment.title) : remoteComment.title != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(remoteComment.url) : remoteComment.url != null);
    }

    public int hashCode() {
        int n = (int)(this.id ^ this.id >>> 32);
        n = 29 * n + (int)(this.pageId ^ this.pageId >>> 32);
        n = 29 * n + (this.created != null ? this.created.hashCode() : 0);
        n = 29 * n + (this.title != null ? this.title.hashCode() : 0);
        n = 29 * n + (this.url != null ? this.url.hashCode() : 0);
        n = 29 * n + (this.creator != null ? this.creator.hashCode() : 0);
        n = 29 * n + (this.content != null ? this.content.hashCode() : 0);
        return n;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

