/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap.beans;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.setup.BootstrapUtils;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RemoteAttachment {
    long id;
    long pageId;
    long fileSize;
    String title;
    String fileName;
    String contentType;
    String creator;
    String url;
    String comment;
    Date created;

    public RemoteAttachment() {
    }

    public RemoteAttachment(Attachment attachment) {
        this.id = attachment.getId();
        this.pageId = attachment.getContent().getId();
        this.title = attachment.getRealTitle();
        this.url = BootstrapUtils.getBootstrapManager().getBaseUrl() + attachment.getDownloadPath();
        this.fileName = attachment.getFileName();
        this.fileSize = attachment.getFileSize();
        this.contentType = attachment.getContentType();
        this.comment = attachment.getComment();
        if (attachment.getCreationDate() != null) {
            this.created = new Date(attachment.getCreationDate().getTime());
        }
        if (attachment.getCreatorName() != null) {
            this.creator = attachment.getCreatorName();
        }
    }

    public RemoteAttachment(long l, String string, String string2, String string3) {
        this.pageId = l;
        this.fileName = string;
        this.comment = string3;
        this.contentType = string2;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long l) {
        this.id = l;
    }

    public long getPageId() {
        return this.pageId;
    }

    public void setPageId(long l) {
        this.pageId = l;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long l) {
        this.fileSize = l;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String string) {
        this.creator = string;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public Date getCreated() {
        return this.created;
    }

    public String getComment() {
        return this.comment;
    }

    public void setCreated(Date date) {
        this.created = date;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RemoteAttachment)) {
            return false;
        }
        RemoteAttachment remoteAttachment = (RemoteAttachment)object;
        if (this.fileSize != remoteAttachment.fileSize) {
            return false;
        }
        if (this.id != remoteAttachment.id) {
            return false;
        }
        if (this.pageId != remoteAttachment.pageId) {
            return false;
        }
        if (this.contentType != null ? !this.contentType.equals(remoteAttachment.contentType) : remoteAttachment.contentType != null) {
            return false;
        }
        if (this.created != null ? !this.created.equals(remoteAttachment.created) : remoteAttachment.created != null) {
            return false;
        }
        if (this.creator != null ? !this.creator.equals(remoteAttachment.creator) : remoteAttachment.creator != null) {
            return false;
        }
        if (this.fileName != null ? !this.fileName.equals(remoteAttachment.fileName) : remoteAttachment.fileName != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(remoteAttachment.title) : remoteAttachment.title != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(remoteAttachment.url) : remoteAttachment.url != null);
    }

    public int hashCode() {
        int n = (int)(this.id ^ this.id >>> 32);
        n = 29 * n + (int)(this.pageId ^ this.pageId >>> 32);
        n = 29 * n + (int)(this.fileSize ^ this.fileSize >>> 32);
        n = 29 * n + (this.title != null ? this.title.hashCode() : 0);
        n = 29 * n + (this.fileName != null ? this.fileName.hashCode() : 0);
        n = 29 * n + (this.contentType != null ? this.contentType.hashCode() : 0);
        n = 29 * n + (this.creator != null ? this.creator.hashCode() : 0);
        n = 29 * n + (this.url != null ? this.url.hashCode() : 0);
        n = 29 * n + (this.created != null ? this.created.hashCode() : 0);
        return n;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

