/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.soap.ConfluenceSoapService;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntry;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntrySummary;
import com.atlassian.confluence.rpc.soap.beans.RemoteComment;
import com.atlassian.confluence.rpc.soap.beans.RemoteLabel;
import com.atlassian.confluence.rpc.soap.beans.RemotePage;
import com.atlassian.confluence.rpc.soap.beans.RemotePageHistory;
import com.atlassian.confluence.rpc.soap.beans.RemotePageSummary;
import com.atlassian.confluence.rpc.soap.beans.RemotePermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteSearchResult;
import com.atlassian.confluence.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpace;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceSummary;
import com.atlassian.confluence.rpc.soap.beans.RemoteUser;
import com.atlassian.confluence.rpc.soap.beans.RemoteUserInformation;
import com.atlassian.confluence.rpc.soap.services.AdminSoapService;
import com.atlassian.confluence.rpc.soap.services.AttachmentsSoapService;
import com.atlassian.confluence.rpc.soap.services.BlogsSoapService;
import com.atlassian.confluence.rpc.soap.services.LabelsSoapService;
import com.atlassian.confluence.rpc.soap.services.PagesSoapService;
import com.atlassian.confluence.rpc.soap.services.SpacesSoapService;
import com.atlassian.confluence.rpc.soap.services.UsersSoapService;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ConfluenceSoapServiceDelegator
implements ConfluenceSoapService {
    public static final List VIEW_SPACE_PERMISSION_TYPES = Arrays.asList("VIEWSPACE");
    public static final List MODIFY_SPACE_PERMISSION_TYPES = Arrays.asList("EDITSPACE");
    public static final List ADMINISTRATE_PERMISSION_TYPES = Arrays.asList("ADMINISTRATECONFLUENCE");
    public static final List SPACE_ADMIN_PERMISSION_TYPES = Arrays.asList("SETSPACEPERMISSIONS");
    public static final List REMOVE_PAGE_PERMISSION_TYPES = Arrays.asList("REMOVEPAGE");
    public static final List EXPORT_SPACE_PERMISSION_TYPES = Arrays.asList("EXPORTSPACE");
    SpacesSoapService spacesService;
    PagesSoapService pagesService;
    UsersSoapService usersService;
    BlogsSoapService blogsService;
    AdminSoapService adminSoapService;
    LabelsSoapService labelsSoapService;
    AttachmentsSoapService attachmentsService;

    public void setSpacesSoapService(SpacesSoapService spacesSoapService) {
        this.spacesService = spacesSoapService;
    }

    public void setPagesSoapService(PagesSoapService pagesSoapService) {
        this.pagesService = pagesSoapService;
    }

    public void setUsersSoapService(UsersSoapService usersSoapService) {
        this.usersService = usersSoapService;
    }

    public void setBlogsSoapService(BlogsSoapService blogsSoapService) {
        this.blogsService = blogsSoapService;
    }

    public void setGlobalSoapService(AdminSoapService adminSoapService) {
        this.adminSoapService = adminSoapService;
    }

    public void setAdminSoapService(AdminSoapService adminSoapService) {
        this.adminSoapService = adminSoapService;
    }

    public void setLabelsSoapService(LabelsSoapService labelsSoapService) {
        this.labelsSoapService = labelsSoapService;
    }

    public void setAttachmentsSoapService(AttachmentsSoapService attachmentsSoapService) {
        this.attachmentsService = attachmentsSoapService;
    }

    public String login(String string, String string2) throws RemoteException {
        throw new UnsupportedOperationException("Should be handled in an interceptor.");
    }

    public boolean logout(String string) {
        throw new UnsupportedOperationException("Should be handled in an interceptor.");
    }

    public RemoteSpaceSummary[] getSpaces(String string) throws RemoteException {
        return this.spacesService.getSpaces();
    }

    public RemoteSpace addSpace(String string, RemoteSpace remoteSpace) throws RemoteException {
        return this.spacesService.addSpace(remoteSpace);
    }

    public RemoteSpace addPersonalSpace(String string, RemoteSpace remoteSpace, String string2) throws RemoteException {
        return this.spacesService.addPersonalSpace(remoteSpace, string2);
    }

    public boolean convertToPersonalSpace(String string, String string2, String string3, String string4, boolean bl) throws RemoteException {
        return this.spacesService.convertToPersonalSpace(string2, string3, string4, bl);
    }

    public Boolean removeSpace(String string, String string2) throws RemoteException {
        return this.spacesService.removeSpace(string2);
    }

    public RemoteSpace getSpace(String string, String string2) throws RemoteException {
        return this.spacesService.getSpace(string2);
    }

    public String[] getPermissions(String string, String string2) throws RemoteException {
        return this.spacesService.getPermissions(string2);
    }

    public String[] getPermissionsForUser(String string, String string2, String string3) throws InvalidSessionException, RemoteException {
        return this.spacesService.getPermissions(string2, string3);
    }

    public boolean addPermissionToSpace(String string, String string2, String string3, String string4) throws RemoteException {
        return this.spacesService.addPermissionToSpace(string2, string3, string4);
    }

    public boolean addPermissionsToSpace(String string, String[] stringArray, String string2, String string3) throws RemoteException {
        return this.spacesService.addPermissionsToSpace(stringArray, string2, string3);
    }

    public boolean removePermissionFromSpace(String string, String string2, String string3, String string4) throws NotPermittedException, RemoteException {
        return this.spacesService.removePermissionFromSpace(string2, string3, string4);
    }

    public boolean addAnonymousPermissionToSpace(String string, String string2, String string3) throws RemoteException {
        return this.spacesService.addPermissionToSpace(string2, null, string3);
    }

    public boolean addAnonymousPermissionsToSpace(String string, String[] stringArray, String string2) throws RemoteException {
        return this.spacesService.addPermissionsToSpace(stringArray, null, string2);
    }

    public boolean removeAnonymousPermissionFromSpace(String string, String string2, String string3) throws NotPermittedException, RemoteException {
        return this.spacesService.removePermissionFromSpace(string2, null, string3);
    }

    public String[] getSpaceLevelPermissions(String string) throws RemoteException {
        return this.spacesService.getSpaceLevelPermissions();
    }

    public RemotePageSummary[] getPages(String string, String string2) throws RemoteException {
        return this.pagesService.getPages(string2);
    }

    public RemotePage getPage(String string, String string2, String string3) throws InvalidSessionException, RemoteException {
        return this.pagesService.getPage(string2, string3);
    }

    public RemotePage getPage(String string, long l) throws RemoteException {
        return this.pagesService.getPage(l);
    }

    public RemoteComment[] getComments(String string, long l) throws RemoteException {
        return this.pagesService.getComments(l);
    }

    public RemoteComment getComment(String string, long l) throws InvalidSessionException, RemoteException {
        return this.pagesService.getComment(l);
    }

    public RemoteComment addComment(String string, RemoteComment remoteComment) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.pagesService.addComment(remoteComment);
    }

    public boolean removeComment(String string, long l) throws InvalidSessionException, NotPermittedException, RemoteException {
        return this.pagesService.removeComment(l);
    }

    public RemotePageSummary[] getAncestors(String string, long l) throws InvalidSessionException, RemoteException {
        return this.pagesService.getAncestors(l);
    }

    public RemotePageSummary[] getChildren(String string, long l) throws InvalidSessionException, RemoteException {
        return this.pagesService.getChildren(l);
    }

    public RemotePageSummary[] getDescendents(String string, long l) throws InvalidSessionException, RemoteException {
        return this.pagesService.getDescendents(l);
    }

    public RemoteAttachment[] getAttachments(String string, long l) throws RemoteException {
        return this.pagesService.getAttachments(l);
    }

    public RemotePageHistory[] getPageHistory(String string, long l) throws RemoteException {
        return this.pagesService.getPageHistory(l);
    }

    public RemoteSearchResult[] search(String string, String string2, int n) throws RemoteException {
        return this.pagesService.search(string2, n);
    }

    public RemoteSearchResult[] search(String string, String string2, Map map, int n) throws RemoteException {
        return this.pagesService.search(string2, map, n);
    }

    public RemoteBlogEntry getBlogEntryByDayAndTitle(String string, String string2, int n, String string3) throws RemoteException {
        return this.blogsService.getBlogEntryByDayAndTitle(string2, n, string3);
    }

    public String renderContent(String string, String string2, long l, String string3) throws RemoteException {
        return this.pagesService.renderContent(string2, l, string3);
    }

    public String renderContent(String string, String string2, long l, String string3, Map map) throws RemoteException {
        return this.pagesService.renderContent(string2, l, string3, map);
    }

    public RemoteAttachment addAttachment(String string, RemoteAttachment remoteAttachment, byte[] byArray) throws RemoteException {
        return this.attachmentsService.addAttachment(remoteAttachment.getPageId(), remoteAttachment, byArray);
    }

    public RemoteAttachment addAttachment(String string, long l, RemoteAttachment remoteAttachment, byte[] byArray) throws RemoteException {
        return this.attachmentsService.addAttachment(l, remoteAttachment, byArray);
    }

    public RemoteAttachment getAttachment(String string, long l, String string2, int n) throws RemoteException {
        return this.attachmentsService.getAttachment(l, string2, n);
    }

    public byte[] getAttachmentData(String string, long l, String string2, int n) throws RemoteException {
        return this.attachmentsService.getAttachmentData(l, string2, n);
    }

    public boolean removeAttachment(String string, long l, String string2) throws RemoteException {
        return this.attachmentsService.removeAttachment(l, string2);
    }

    public boolean moveAttachment(String string, long l, String string2, long l2, String string3) throws RemoteException {
        return this.attachmentsService.moveAttachment(l, string2, l2, string3);
    }

    public Boolean removePage(String string, long l) throws RemoteException {
        return this.pagesService.removePage(l);
    }

    public RemotePage storePage(String string, RemotePage remotePage) throws RemoteException {
        return this.pagesService.storePage(remotePage);
    }

    public RemotePermission[] getPagePermissions(String string, long l) throws RemoteException {
        return this.pagesService.getPermissions(l);
    }

    public RemoteBlogEntry getBlogEntry(String string, long l) throws RemoteException {
        return this.blogsService.getBlogEntry(l);
    }

    public RemoteBlogEntrySummary[] getBlogEntries(String string, String string2) throws RemoteException {
        return this.blogsService.getBlogEntries(string2);
    }

    public RemoteBlogEntry storeBlogEntry(String string, RemoteBlogEntry remoteBlogEntry) throws RemoteException {
        return this.blogsService.storeBlogEntry(remoteBlogEntry);
    }

    public String[] getGroups(String string) throws RemoteException {
        return this.usersService.getGroups();
    }

    public boolean hasGroup(String string, String string2) throws InvalidSessionException, RemoteException {
        return this.usersService.hasGroup(string2);
    }

    public boolean addGroup(String string, String string2) throws RemoteException {
        return this.usersService.addGroup(string2);
    }

    public boolean removeGroup(String string, String string2, String string3) throws RemoteException {
        return this.usersService.removeGroup(string2, string3);
    }

    public boolean removeAllPermissionsForGroup(String string, String string2) throws RemoteException {
        return this.usersService.removeAllPermissionsForGroup(string2);
    }

    public String[] getUserGroups(String string, String string2) throws RemoteException {
        return this.usersService.getUserGroups(string2);
    }

    public boolean addUserToGroup(String string, String string2, String string3) throws RemoteException {
        return this.usersService.addUserToGroup(string2, string3);
    }

    public boolean removeUserFromGroup(String string, String string2, String string3) throws RemoteException {
        return this.usersService.removeUserFromGroup(string2, string3);
    }

    public RemoteUser getUser(String string, String string2) throws RemoteException {
        return this.usersService.getUser(string2);
    }

    public boolean hasUser(String string, String string2) throws InvalidSessionException, RemoteException {
        return this.usersService.hasUser(string, string2);
    }

    public void addUser(String string, RemoteUser remoteUser, String string2) throws RemoteException {
        this.usersService.addUser(remoteUser, string2);
    }

    public boolean removeUser(String string, String string2) throws RemoteException {
        return this.usersService.removeUser(string2);
    }

    public boolean editUser(String string, RemoteUser remoteUser) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.editUser(remoteUser);
    }

    public boolean deactivateUser(String string, String string2) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.deactivateUser(string2);
    }

    public boolean reactivateUser(String string, String string2) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.reactivateUser(string2);
    }

    public String[] getActiveUsers(String string, boolean bl) throws InvalidSessionException, RemoteException {
        return this.usersService.getActiveUsers(bl);
    }

    public boolean setUserInformation(String string, RemoteUserInformation remoteUserInformation) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.setUserInformation(remoteUserInformation);
    }

    public RemoteUserInformation getUserInformation(String string, String string2) throws InvalidSessionException, RemoteException {
        return this.usersService.getUserInformation(string2);
    }

    public boolean changeMyPassword(String string, String string2, String string3) throws InvalidSessionException, RemoteException {
        return this.usersService.changeMyPassword(string2, string3);
    }

    public boolean changeUserPassword(String string, String string2, String string3) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.changeUserPassword(string2, string3);
    }

    public boolean addProfilePicture(String string, String string2, String string3, String string4, byte[] byArray) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.usersService.addProfilePicture(string2, string3, string4, byArray);
    }

    public RemoteServerInfo getServerInfo(String string) throws RemoteException {
        return this.adminSoapService.getServerInfo();
    }

    public String exportSpace(String string, String string2, String string3) throws RemoteException {
        return this.spacesService.exportSpace(string2, string3);
    }

    public String exportSite(String string, boolean bl) throws RemoteException {
        return this.adminSoapService.exportSite(bl);
    }

    public boolean flushIndexQueue(String string) throws RemoteException {
        return this.adminSoapService.flushIndexQueue();
    }

    public boolean clearIndexQueue(String string) throws RemoteException {
        return this.adminSoapService.clearIndexQueue();
    }

    public RemoteLabel[] getLabelsById(String string, long l) throws RemoteException {
        return this.labelsSoapService.getLabelsById(l);
    }

    public RemoteLabel[] getMostPopularLabels(String string, int n) throws RemoteException {
        return this.labelsSoapService.getMostPopularLabels(n);
    }

    public RemoteLabel[] getMostPopularLabelsInSpace(String string, String string2, int n) throws RemoteException {
        return this.labelsSoapService.getMostPopularLabelsInSpace(string2, n);
    }

    public RemoteLabel[] getRecentlyUsedLabels(String string, int n) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRecentlyUsedLabels(n);
    }

    public RemoteLabel[] getRecentlyUsedLabelsInSpace(String string, String string2, int n) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRecentlyUsedLabelsInSpace(string2, n);
    }

    public RemoteSpace[] getSpacesWithLabel(String string, String string2) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getSpacesWithLabel(string2);
    }

    public RemoteLabel[] getRelatedLabels(String string, String string2, int n) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRelatedLabels(string2, n);
    }

    public RemoteLabel[] getRelatedLabelsInSpace(String string, String string2, String string3, int n) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getRelatedLabelsInSpace(string2, string3, n);
    }

    public RemoteLabel[] getLabelsByDetail(String string, String string2, String string3, String string4, String string5) throws InvalidSessionException, RemoteException, NotPermittedException {
        return this.labelsSoapService.getLabelsByDetail(string2, string3, string4, string5);
    }

    public RemoteSearchResult[] getLabelContentById(String string, long l) throws RemoteException {
        return this.labelsSoapService.getLabelContentById(l);
    }

    public RemoteSearchResult[] getLabelContentByName(String string, String string2) throws RemoteException {
        return this.labelsSoapService.getLabelContentByName(string2);
    }

    public RemoteSearchResult[] getLabelContentByObject(String string, RemoteLabel remoteLabel) throws RemoteException {
        return this.labelsSoapService.getLabelContentByObject(remoteLabel);
    }

    public RemoteSpace[] getSpacesContainingContentWithLabel(String string, String string2) throws InvalidSessionException, RemoteException {
        return this.labelsSoapService.getSpacesContainingContentWithLabel(string2);
    }

    public boolean addLabelByName(String string, String string2, long l) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.addLabelByName(string2, l);
    }

    public boolean addLabelById(String string, long l, long l2) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.addLabelById(l, l2);
    }

    public boolean addLabelByObject(String string, RemoteLabel remoteLabel, long l) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.addLabelByObject(remoteLabel, l);
    }

    public boolean addLabelByNameToSpace(String string, String string2, String string3) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.labelsSoapService.addLabelByNameToSpace(string2, string3);
    }

    public boolean removeLabelByName(String string, String string2, long l) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.removeLabelByName(string2, l);
    }

    public boolean removeLabelById(String string, long l, long l2) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.removeLabelById(l, l2);
    }

    public boolean removeLabelByObject(String string, RemoteLabel remoteLabel, long l) throws NotPermittedException, RemoteException {
        return this.labelsSoapService.removeLabelByObject(remoteLabel, l);
    }

    public boolean removeLabelByNameFromSpace(String string, String string2, String string3) throws NotPermittedException, InvalidSessionException, RemoteException {
        return this.labelsSoapService.removeLabelByNameFromSpace(string2, string3);
    }
}

