/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.rpc.soap;

import com.atlassian.confluence.rpc.AlreadyExistsException;
import com.atlassian.confluence.rpc.AuthenticationFailedException;
import com.atlassian.confluence.rpc.InvalidSessionException;
import com.atlassian.confluence.rpc.NotPermittedException;
import com.atlassian.confluence.rpc.RemoteException;
import com.atlassian.confluence.rpc.SecureRpc;
import com.atlassian.confluence.rpc.VersionMismatchException;
import com.atlassian.confluence.rpc.soap.beans.RemoteAttachment;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntry;
import com.atlassian.confluence.rpc.soap.beans.RemoteBlogEntrySummary;
import com.atlassian.confluence.rpc.soap.beans.RemoteComment;
import com.atlassian.confluence.rpc.soap.beans.RemoteLabel;
import com.atlassian.confluence.rpc.soap.beans.RemotePage;
import com.atlassian.confluence.rpc.soap.beans.RemotePageHistory;
import com.atlassian.confluence.rpc.soap.beans.RemotePageSummary;
import com.atlassian.confluence.rpc.soap.beans.RemotePermission;
import com.atlassian.confluence.rpc.soap.beans.RemoteSearchResult;
import com.atlassian.confluence.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpace;
import com.atlassian.confluence.rpc.soap.beans.RemoteSpaceSummary;
import com.atlassian.confluence.rpc.soap.beans.RemoteUser;
import com.atlassian.confluence.rpc.soap.beans.RemoteUserInformation;
import java.util.Map;

public interface ConfluenceSoapService
extends SecureRpc {
    public static final String VIEW_PERMISSION = "view";
    public static final String MODIFY_PERMISSION = "modify";
    public static final String COMMENT_PERMISSION = "comment";
    public static final String ADMIN_SPACE_PERMISSION = "admin";

    public String login(String var1, String var2) throws AuthenticationFailedException, RemoteException;

    public boolean logout(String var1) throws RemoteException;

    public RemoteSpaceSummary[] getSpaces(String var1) throws InvalidSessionException, RemoteException;

    public RemoteSpace addSpace(String var1, RemoteSpace var2) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException;

    public RemoteSpace addPersonalSpace(String var1, RemoteSpace var2, String var3) throws NotPermittedException, InvalidSessionException, AlreadyExistsException, RemoteException;

    public Boolean removeSpace(String var1, String var2) throws NotPermittedException, InvalidSessionException, RemoteException;

    public RemoteSpace getSpace(String var1, String var2) throws InvalidSessionException, RemoteException;

    public boolean convertToPersonalSpace(String var1, String var2, String var3, String var4, boolean var5) throws RemoteException;

    public String[] getPermissions(String var1, String var2) throws InvalidSessionException, RemoteException;

    public String[] getPermissionsForUser(String var1, String var2, String var3) throws InvalidSessionException, NotPermittedException, RemoteException;

    public boolean addPermissionToSpace(String var1, String var2, String var3, String var4) throws RemoteException;

    public boolean addPermissionsToSpace(String var1, String[] var2, String var3, String var4) throws RemoteException;

    public boolean removePermissionFromSpace(String var1, String var2, String var3, String var4) throws NotPermittedException, RemoteException;

    public boolean addAnonymousPermissionToSpace(String var1, String var2, String var3) throws RemoteException;

    public boolean addAnonymousPermissionsToSpace(String var1, String[] var2, String var3) throws RemoteException;

    public boolean removeAnonymousPermissionFromSpace(String var1, String var2, String var3) throws NotPermittedException, RemoteException;

    public RemotePermission[] getPagePermissions(String var1, long var2) throws InvalidSessionException, RemoteException;

    public String[] getSpaceLevelPermissions(String var1) throws RemoteException;

    public RemotePageSummary[] getPages(String var1, String var2) throws InvalidSessionException, RemoteException;

    public RemotePage getPage(String var1, String var2, String var3) throws InvalidSessionException, RemoteException;

    public RemotePage getPage(String var1, long var2) throws InvalidSessionException, RemoteException;

    public RemotePage storePage(String var1, RemotePage var2) throws VersionMismatchException, NotPermittedException, InvalidSessionException, RemoteException;

    public Boolean removePage(String var1, long var2) throws NotPermittedException, InvalidSessionException, RemoteException;

    public RemotePageSummary[] getAncestors(String var1, long var2) throws InvalidSessionException, RemoteException;

    public RemotePageSummary[] getChildren(String var1, long var2) throws InvalidSessionException, RemoteException;

    public RemotePageSummary[] getDescendents(String var1, long var2) throws InvalidSessionException, RemoteException;

    public RemoteAttachment[] getAttachments(String var1, long var2) throws InvalidSessionException, RemoteException;

    public RemotePageHistory[] getPageHistory(String var1, long var2) throws InvalidSessionException, RemoteException;

    public String renderContent(String var1, String var2, long var3, String var5) throws InvalidSessionException, RemoteException;

    public String renderContent(String var1, String var2, long var3, String var5, Map var6) throws RemoteException;

    public RemoteAttachment addAttachment(String var1, long var2, RemoteAttachment var4, byte[] var5) throws RemoteException;

    public RemoteAttachment addAttachment(String var1, RemoteAttachment var2, byte[] var3) throws RemoteException;

    public RemoteAttachment getAttachment(String var1, long var2, String var4, int var5) throws RemoteException;

    public byte[] getAttachmentData(String var1, long var2, String var4, int var5) throws RemoteException;

    public boolean removeAttachment(String var1, long var2, String var4) throws RemoteException;

    public boolean moveAttachment(String var1, long var2, String var4, long var5, String var7) throws RemoteException;

    public RemoteComment[] getComments(String var1, long var2) throws InvalidSessionException, RemoteException;

    public RemoteComment getComment(String var1, long var2) throws InvalidSessionException, RemoteException;

    public RemoteComment addComment(String var1, RemoteComment var2) throws InvalidSessionException, NotPermittedException, RemoteException;

    public boolean removeComment(String var1, long var2) throws InvalidSessionException, NotPermittedException, RemoteException;

    public RemoteSearchResult[] search(String var1, String var2, int var3) throws InvalidSessionException, RemoteException;

    public RemoteSearchResult[] search(String var1, String var2, Map var3, int var4) throws RemoteException;

    public RemoteBlogEntry getBlogEntryByDayAndTitle(String var1, String var2, int var3, String var4) throws RemoteException;

    public RemoteBlogEntry getBlogEntry(String var1, long var2) throws RemoteException;

    public RemoteBlogEntrySummary[] getBlogEntries(String var1, String var2) throws InvalidSessionException, RemoteException;

    public RemoteBlogEntry storeBlogEntry(String var1, RemoteBlogEntry var2) throws VersionMismatchException, NotPermittedException, InvalidSessionException, RemoteException;

    public RemoteServerInfo getServerInfo(String var1) throws InvalidSessionException, RemoteException;

    public String exportSpace(String var1, String var2, String var3) throws RemoteException;

    public String exportSite(String var1, boolean var2) throws RemoteException;

    public boolean flushIndexQueue(String var1) throws RemoteException;

    public boolean clearIndexQueue(String var1) throws RemoteException;

    public String[] getGroups(String var1) throws NotPermittedException, RemoteException;

    public boolean hasGroup(String var1, String var2) throws InvalidSessionException, RemoteException;

    public boolean addGroup(String var1, String var2) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean removeGroup(String var1, String var2, String var3) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean removeAllPermissionsForGroup(String var1, String var2) throws RemoteException;

    public String[] getUserGroups(String var1, String var2) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean addUserToGroup(String var1, String var2, String var3) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean removeUserFromGroup(String var1, String var2, String var3) throws NotPermittedException, InvalidSessionException, RemoteException;

    public RemoteUser getUser(String var1, String var2) throws InvalidSessionException, RemoteException;

    public boolean hasUser(String var1, String var2) throws InvalidSessionException, RemoteException;

    public void addUser(String var1, RemoteUser var2, String var3) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean removeUser(String var1, String var2) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean editUser(String var1, RemoteUser var2) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean deactivateUser(String var1, String var2) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean reactivateUser(String var1, String var2) throws NotPermittedException, InvalidSessionException, RemoteException;

    public String[] getActiveUsers(String var1, boolean var2) throws InvalidSessionException, RemoteException;

    public boolean setUserInformation(String var1, RemoteUserInformation var2) throws NotPermittedException, InvalidSessionException, RemoteException;

    public RemoteUserInformation getUserInformation(String var1, String var2) throws InvalidSessionException, RemoteException;

    public boolean changeMyPassword(String var1, String var2, String var3) throws InvalidSessionException, RemoteException;

    public boolean changeUserPassword(String var1, String var2, String var3) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean addProfilePicture(String var1, String var2, String var3, String var4, byte[] var5) throws NotPermittedException, InvalidSessionException, RemoteException;

    public RemoteLabel[] getLabelsById(String var1, long var2) throws InvalidSessionException, RemoteException;

    public RemoteLabel[] getMostPopularLabels(String var1, int var2) throws InvalidSessionException, RemoteException;

    public RemoteLabel[] getMostPopularLabelsInSpace(String var1, String var2, int var3) throws InvalidSessionException, RemoteException;

    public RemoteLabel[] getRecentlyUsedLabels(String var1, int var2) throws InvalidSessionException, RemoteException;

    public RemoteLabel[] getRecentlyUsedLabelsInSpace(String var1, String var2, int var3) throws InvalidSessionException, RemoteException;

    public RemoteSpace[] getSpacesWithLabel(String var1, String var2) throws InvalidSessionException, RemoteException;

    public RemoteLabel[] getRelatedLabels(String var1, String var2, int var3) throws InvalidSessionException, RemoteException;

    public RemoteLabel[] getRelatedLabelsInSpace(String var1, String var2, String var3, int var4) throws InvalidSessionException, RemoteException;

    public RemoteLabel[] getLabelsByDetail(String var1, String var2, String var3, String var4, String var5) throws InvalidSessionException, RemoteException;

    public RemoteSearchResult[] getLabelContentById(String var1, long var2) throws InvalidSessionException, RemoteException;

    public RemoteSearchResult[] getLabelContentByName(String var1, String var2) throws InvalidSessionException, RemoteException;

    public RemoteSearchResult[] getLabelContentByObject(String var1, RemoteLabel var2) throws InvalidSessionException, RemoteException;

    public RemoteSpace[] getSpacesContainingContentWithLabel(String var1, String var2) throws InvalidSessionException, RemoteException;

    public boolean addLabelByName(String var1, String var2, long var3) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean addLabelById(String var1, long var2, long var4) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean addLabelByObject(String var1, RemoteLabel var2, long var3) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean addLabelByNameToSpace(String var1, String var2, String var3) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean removeLabelByName(String var1, String var2, long var3) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean removeLabelById(String var1, long var2, long var4) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean removeLabelByObject(String var1, RemoteLabel var2, long var3) throws NotPermittedException, InvalidSessionException, RemoteException;

    public boolean removeLabelByNameFromSpace(String var1, String var2, String var3) throws NotPermittedException, InvalidSessionException, RemoteException;
}

