/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.wordgenerator;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.wordgenerator.DictionaryReader;
import com.octo.captcha.component.wordgenerator.WordGenerator;
import com.octo.captcha.component.wordgenerator.WordList;
import java.util.HashMap;
import java.util.Locale;

public class DictionaryWordGenerator
implements WordGenerator {
    private Locale defaultLocale;
    private DictionaryReader factory;
    private HashMap localizedwords = new HashMap();

    public DictionaryWordGenerator(DictionaryReader reader) {
        this.factory = reader;
        this.defaultLocale = this.factory.getWordList().getLocale();
        this.localizedwords.put(this.defaultLocale, this.factory.getWordList());
    }

    public final String getWord(Integer lenght) {
        return this.getWord(lenght, this.defaultLocale);
    }

    public String getWord(Integer lenght, Locale locale) {
        WordList words = this.getWordList(locale);
        String word = words.getNextWord(lenght);
        if (word == null) {
            throw new CaptchaException("No word of lenght : " + lenght + " exists in dictionnary! please " + "update your dictionary or your range!");
        }
        return word;
    }

    final WordList getWordList(Locale locale) {
        WordList words;
        if (this.localizedwords.containsKey(locale)) {
            words = (WordList)this.localizedwords.get(locale);
        } else {
            words = this.factory.getWordList(locale);
            this.localizedwords.put(locale, words);
        }
        return words;
    }
}

