/*
 * Decompiled with CFR 0.152.
 */
package com.octo.captcha.component.image.textpaster;

import com.octo.captcha.CaptchaException;
import com.octo.captcha.component.image.textpaster.TextPaster;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.Random;

public abstract class AbstractTextPaster
implements TextPaster {
    public Random myRandom = new Random();
    private int max = 20;
    private int min = 6;
    private Color textColor = Color.blue;

    AbstractTextPaster(Integer minAcceptedWordLenght, Integer maxAcceptedWordLenght, Color textColor) {
        this.max = maxAcceptedWordLenght != null ? maxAcceptedWordLenght : this.max;
        int n = this.min = minAcceptedWordLenght != null && minAcceptedWordLenght <= this.max ? minAcceptedWordLenght : Math.min(this.min, this.max - 1);
        if (textColor != null) {
            this.textColor = textColor;
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public int getMaxAcceptedWordLenght() {
        return this.max;
    }

    public int getMinAcceptedWordLenght() {
        return this.min;
    }

    BufferedImage copyBackground(BufferedImage background) {
        BufferedImage out = new BufferedImage(background.getWidth(), background.getHeight(), background.getType());
        return out;
    }

    Graphics2D pasteBackgroundAndSetTextColor(BufferedImage out, BufferedImage background) {
        Graphics2D pie = (Graphics2D)out.getGraphics();
        pie.drawImage(background, 0, 0, out.getWidth(), out.getHeight(), null);
        pie.setColor(this.getTextColor());
        return pie;
    }

    public abstract BufferedImage pasteText(BufferedImage var1, AttributedString var2) throws CaptchaException;
}

