/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.chart;

import com.atlassian.confluence.extra.chart.BaseChartMacro;
import com.atlassian.confluence.servlet.download.ExportDownload;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.opensymphony.util.TextUtils;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ChartMacro
extends BaseChartMacro {
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final RenderMode RENDER_MODE = RenderMode.suppress((long)256L);
    private static final String TABLE = "TABLE";
    private static final String THEAD = "THEAD";
    private static final String TBODY = "TBODY";
    private static final String TFOOT = "TFOOT";
    private static final String TR = "TR";
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 300;
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String HORIZONTAL = "horizontal";
    private static final String VERTICAL = "vertical";
    private static final String PIE_TYPE = "pie";
    private static final String BAR_TYPE = "bar";
    private static final String LINE_TYPE = "line";
    private static final String AREA_TYPE = "area";
    private static final String XYLINE_TYPE = "xyline";
    private static final String XYAREA_TYPE = "xyarea";
    private static final String XYBAR_TYPE = "xybar";
    private static final String XYSTEP_TYPE = "xystep";
    private static final String XYSTEPAREA_TYPE = "xysteparea";
    private static final String SCATTER_TYPE = "scatter";
    private static final String TIMESERIES_TYPE = "timeseries";

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            parameters = this.toLowerCase(parameters);
            int width = this.getIntegerParameter(parameters, "width", 300);
            int height = this.getIntegerParameter(parameters, "height", 300);
            String rendered = this.subRenderer.render(body, renderContext, RENDER_MODE);
            Document data = this.parseBody(rendered);
            BufferedImage image = this.getChart(parameters, data).createBufferedImage(width, height);
            File outputFile = ExportDownload.createTempFile((String)"chart", (String)".png");
            ImageIO.write((RenderedImage)image, "PNG", outputFile);
            StringBuffer out = new StringBuffer();
            out.append("<img src=\"").append(ExportDownload.getUrl((File)outputFile, (String)"image/png")).append("\" width=\"").append(width).append("\" height=\"").append(height).append("\"/>");
            if (TRUE.equalsIgnoreCase((String)parameters.get("displaydata")) || TRUE.equalsIgnoreCase((String)parameters.get("datadisplay"))) {
                out.append(rendered);
            }
            return out.toString();
        }
        catch (NumberFormatException exception) {
            this.log.debug((Object)"", (Throwable)exception);
            throw new MacroException((Throwable)exception);
        }
        catch (IOException exception) {
            this.log.debug((Object)"", (Throwable)exception);
            throw new MacroException((Throwable)exception);
        }
        catch (DocumentException exception) {
            this.log.debug((Object)"", (Throwable)exception);
            throw new MacroException((Throwable)exception);
        }
        catch (Exception exception) {
            this.log.debug((Object)"", (Throwable)exception);
            throw new MacroException((Throwable)exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    private JFreeChart getChart(Map parameters, Document data) throws MacroException {
        void var21_22;
        JFreeChart chart;
        Object dataset;
        Class<?> timePeriodClass;
        DateFormat dateFormat;
        String title = (String)parameters.get("title");
        String xLabel = (String)parameters.get("xlabel");
        String yLabel = (String)parameters.get("ylabel");
        String opacity = (String)parameters.get("opacity");
        String bgColor = (String)parameters.get("bgcolor");
        String borderColor = (String)parameters.get("bordercolor");
        boolean tooltips = true;
        boolean urls = false;
        String type = PIE_TYPE;
        if (TextUtils.stringSet((String)((String)parameters.get("type")))) {
            type = (String)parameters.get("type");
        }
        boolean legend = true;
        if (TextUtils.stringSet((String)((String)parameters.get("legend")))) {
            legend = !FALSE.equalsIgnoreCase((String)parameters.get("legend"));
        }
        PlotOrientation plotOrientation = PlotOrientation.VERTICAL;
        if (TextUtils.stringSet((String)((String)parameters.get("orientation"))) && ((String)parameters.get("orientation")).equalsIgnoreCase(HORIZONTAL)) {
            plotOrientation = PlotOrientation.HORIZONTAL;
        }
        boolean is3d = false;
        if (TextUtils.stringSet((String)((String)parameters.get("3d")))) {
            is3d = TRUE.equalsIgnoreCase((String)parameters.get("3d"));
        }
        boolean stacked = false;
        if (TextUtils.stringSet((String)((String)parameters.get("stacked")))) {
            stacked = TRUE.equalsIgnoreCase((String)parameters.get("stacked"));
        }
        boolean verticalDataOrientation = false;
        if (TextUtils.stringSet((String)((String)parameters.get("dataorientation")))) {
            verticalDataOrientation = VERTICAL.equalsIgnoreCase((String)parameters.get("dataorientation"));
        }
        boolean timeSeries = false;
        if (TextUtils.stringSet((String)((String)parameters.get(TIMESERIES_TYPE)))) {
            timeSeries = TRUE.equalsIgnoreCase((String)parameters.get(TIMESERIES_TYPE));
        }
        if (TextUtils.stringSet((String)((String)parameters.get("dateformat")))) {
            dateFormat = new SimpleDateFormat((String)parameters.get("dateformat"));
            dateFormat.toString();
        } else {
            dateFormat = DateFormat.getDateInstance();
        }
        String timePeriod = "Day";
        if (TextUtils.stringSet((String)((String)parameters.get("timeperiod")))) {
            timePeriod = (String)parameters.get("timeperiod");
        }
        try {
            timePeriodClass = Class.forName("org.jfree.data.time." + StringUtils.capitalise((String)timePeriod));
        }
        catch (ClassNotFoundException exception) {
            throw new MacroException("Invalid time period parameter: " + timePeriod);
        }
        if (PIE_TYPE.equalsIgnoreCase(type)) {
            dataset = new DefaultPieDataset();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, null, null);
            chart = is3d ? ChartFactory.createPieChart3D((String)title, (PieDataset)dataset, (boolean)legend, (boolean)tooltips, (boolean)urls) : ChartFactory.createPieChart((String)title, (PieDataset)dataset, (boolean)legend, (boolean)tooltips, (boolean)urls);
        } else if (BAR_TYPE.equalsIgnoreCase(type)) {
            dataset = new DefaultCategoryDataset();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, null, null);
            chart = is3d ? ChartFactory.createBarChart3D((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls) : ChartFactory.createBarChart((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
            if (stacked) {
                CategoryPlot plot = chart.getCategoryPlot();
                if (is3d) {
                    plot.setRenderer((CategoryItemRenderer)new StackedBarRenderer3D());
                } else {
                    plot.setRenderer((CategoryItemRenderer)new StackedBarRenderer());
                }
            }
        } else if (AREA_TYPE.equalsIgnoreCase(type)) {
            dataset = new DefaultCategoryDataset();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, null, null);
            chart = ChartFactory.createAreaChart((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
            if (stacked) {
                CategoryPlot plot = chart.getCategoryPlot();
                plot.setRenderer((CategoryItemRenderer)new StackedAreaRenderer());
            } else if (opacity == null) {
                opacity = "50";
            }
        } else if (LINE_TYPE.equalsIgnoreCase(type)) {
            dataset = new DefaultCategoryDataset();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, null, null);
            chart = is3d ? ChartFactory.createLineChart3D((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls) : ChartFactory.createLineChart((String)title, (String)xLabel, (String)yLabel, (CategoryDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
            CategoryPlot plot = chart.getCategoryPlot();
            LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
            renderer.setShapesVisible(true);
        } else if (XYLINE_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, dateFormat, timePeriodClass);
            chart = ChartFactory.createXYLineChart((String)title, (String)xLabel, (String)yLabel, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
        } else if (XYAREA_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, dateFormat, timePeriodClass);
            chart = ChartFactory.createXYAreaChart((String)title, (String)xLabel, (String)yLabel, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
        } else if (XYBAR_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, dateFormat, timePeriodClass);
            chart = ChartFactory.createXYBarChart((String)title, (String)xLabel, (boolean)timeSeries, (String)yLabel, (IntervalXYDataset)((IntervalXYDataset)dataset), (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
        } else if (XYSTEP_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, dateFormat, timePeriodClass);
            chart = ChartFactory.createXYStepChart((String)title, (String)xLabel, (String)yLabel, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
        } else if (XYSTEPAREA_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, dateFormat, timePeriodClass);
            chart = ChartFactory.createXYStepAreaChart((String)title, (String)xLabel, (String)yLabel, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
        } else if (SCATTER_TYPE.equalsIgnoreCase(type)) {
            dataset = timeSeries ? new TimeSeriesCollection() : new XYSeriesCollection();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, dateFormat, timePeriodClass);
            chart = ChartFactory.createScatterPlot((String)title, (String)xLabel, (String)yLabel, (XYDataset)dataset, (PlotOrientation)plotOrientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
        } else if (TIMESERIES_TYPE.equalsIgnoreCase(type)) {
            dataset = new TimeSeriesCollection();
            this.processData(data, (Dataset)dataset, verticalDataOrientation, dateFormat, timePeriodClass);
            chart = ChartFactory.createTimeSeriesChart((String)title, (String)xLabel, (String)yLabel, (XYDataset)dataset, (boolean)legend, (boolean)tooltips, (boolean)urls);
        } else {
            throw new MacroException("Unsupported chart type: " + type);
        }
        if (bgColor == null) {
            bgColor = "white";
        }
        var21_22.setBackgroundPaint((Paint)this.stringToColor(bgColor));
        if (borderColor != null) {
            var21_22.setBorderPaint((Paint)this.stringToColor(borderColor));
            var21_22.setBorderVisible(true);
        }
        Plot plot = var21_22.getPlot();
        if (timeSeries && plot instanceof XYPlot) {
            ((XYPlot)plot).setDomainAxis((ValueAxis)new DateAxis(xLabel));
        }
        this.handleAxisCustomization(parameters, plot, dateFormat);
        this.handleOpacityCustomization(parameters, plot);
        this.handleColorCustomization(parameters, plot);
        return var21_22;
    }

    private void handleAxisCustomization(Map parameters, Plot plot, DateFormat dateFormat) throws MacroException {
        Double rangeAxisLowerBound = this.getDoubleParameter(parameters, "rangeaxislowerbound", null);
        Double rangeAxisUpperBound = this.getDoubleParameter(parameters, "rangeaxisupperbound", null);
        Double rangeAxisTickUnit = this.getDoubleParameter(parameters, "rangeaxistickunit", null);
        Double domainAxisLowerBound = this.getDoubleParameter(parameters, "domainaxislowerbound", null);
        Double domainAxisUpperBound = this.getDoubleParameter(parameters, "domainaxisupperbound", null);
        Double domainAxisTickUnit = this.getDoubleParameter(parameters, "domainaxistickunit", null);
        ValueAxis rangeAxis = null;
        ValueAxis domainAxis = null;
        if (plot instanceof CategoryPlot) {
            rangeAxis = ((CategoryPlot)plot).getRangeAxis();
        } else if (plot instanceof XYPlot) {
            rangeAxis = ((XYPlot)plot).getRangeAxis();
            domainAxis = ((XYPlot)plot).getDomainAxis();
        }
        if (rangeAxis != null) {
            if (rangeAxisLowerBound != null) {
                rangeAxis.setLowerBound(rangeAxisLowerBound.doubleValue());
            }
            if (rangeAxisUpperBound != null) {
                rangeAxis.setUpperBound(rangeAxisUpperBound.doubleValue());
            }
            if (rangeAxisTickUnit != null && rangeAxis instanceof NumberAxis) {
                ((NumberAxis)rangeAxis).setTickUnit(new NumberTickUnit(rangeAxisTickUnit.doubleValue()));
            }
        }
        if (domainAxis != null) {
            if (domainAxisLowerBound != null) {
                domainAxis.setLowerBound(domainAxisLowerBound.doubleValue());
            }
            if (domainAxisUpperBound != null) {
                domainAxis.setUpperBound(domainAxisUpperBound.doubleValue());
            }
            if (domainAxisTickUnit != null && domainAxis instanceof NumberAxis) {
                ((NumberAxis)domainAxis).setTickUnit(new NumberTickUnit(domainAxisTickUnit.doubleValue()));
            }
            if (domainAxis instanceof DateAxis) {
                ((DateAxis)domainAxis).setDateFormatOverride(dateFormat);
            }
        }
    }

    private void handleOpacityCustomization(Map parameters, Plot plot) throws MacroException {
        String opacity = (String)parameters.get("opacity");
        if (opacity != null) {
            try {
                Integer iOpacity = new Integer(opacity);
                if (iOpacity < 0 || iOpacity > 100) {
                    throw new MacroException("opacity parameter value '" + opacity + "' not between 0 and 100");
                }
                plot.setForegroundAlpha(iOpacity.floatValue() / 100.0f);
            }
            catch (NumberFormatException exception) {
                throw new MacroException("opacity parameter value '" + opacity + "' not a number between 0 and 100");
            }
        }
    }

    private void handleColorCustomization(Map parameters, Plot plot) throws MacroException {
        String colors = (String)parameters.get("colors");
        if (colors != null) {
            String[] color = colors.split(",");
            for (int i = 0; i < color.length; ++i) {
                if (plot instanceof CategoryPlot) {
                    ((CategoryPlot)plot).getRenderer().setSeriesPaint(i, (Paint)this.stringToColor(color[i]));
                    continue;
                }
                if (plot instanceof XYPlot) {
                    ((XYPlot)plot).getRenderer().setSeriesPaint(i, (Paint)this.stringToColor(color[i]));
                    continue;
                }
                if (!(plot instanceof PiePlot)) continue;
                ((PiePlot)plot).setSectionPaint(i, (Paint)this.stringToColor(color[i]));
            }
        }
    }

    private Document parseBody(String rendered) throws DocumentException {
        rendered = this.cleanHTML(rendered);
        SAXReader saxReader = new SAXReader();
        return saxReader.read((Reader)new StringReader("<data>" + rendered + "</data>"));
    }

    private String cleanHTML(String rendered) {
        rendered = rendered.replaceAll("\\&nbsp;", "&#160;");
        return rendered;
    }

    private void processData(Document doc, Dataset dataset, boolean verticalDataOrientation, DateFormat dateFormat, Class timePeriodClass) throws MacroException {
        Element data = doc.getRootElement();
        Iterator i = data.elements().iterator();
        int tableNumber = 0;
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (TABLE.equalsIgnoreCase(e.getName())) {
                this.processTableContent(e, dataset, null, verticalDataOrientation, tableNumber, dateFormat, timePeriodClass);
            }
            ++tableNumber;
        }
    }

    private Element processTableContent(Element element, Dataset dataset, Element headerRow, boolean verticalDataOrientation, int tableNumber, DateFormat dateFormat, Class timePeriodClass) throws MacroException {
        Iterator i = element.elements().iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            if (THEAD.equalsIgnoreCase(e.getName()) || TBODY.equalsIgnoreCase(e.getName()) || TFOOT.equalsIgnoreCase(e.getName())) {
                headerRow = this.processTableContent(e, dataset, headerRow, verticalDataOrientation, tableNumber, dateFormat, timePeriodClass);
                continue;
            }
            if (!TR.equalsIgnoreCase(e.getName())) continue;
            if (headerRow == null) {
                headerRow = e;
                continue;
            }
            if (verticalDataOrientation) {
                this.processVerticalDataRow(e, dataset, headerRow, tableNumber, dateFormat, timePeriodClass);
                continue;
            }
            this.processHorizontalDataRow(e, dataset, headerRow, tableNumber, dateFormat, timePeriodClass);
        }
        return headerRow;
    }

    private void processHorizontalDataRow(Element row, Dataset dataset, Element headerRow, int tableNumber, DateFormat dateFormat, Class timePeriodClass) throws MacroException {
        block6: {
            String key;
            String range;
            Iterator iHeaders;
            Iterator iCells;
            block9: {
                block8: {
                    block7: {
                        List cells = row.elements();
                        List headers = headerRow.elements();
                        if (cells.size() <= 1 || headers.size() <= 1) break block6;
                        iCells = cells.iterator();
                        iHeaders = headers.iterator();
                        String domain = ((Element)iHeaders.next()).getTextTrim();
                        range = ((Element)iCells.next()).getTextTrim();
                        key = null;
                        if (!(dataset instanceof DefaultPieDataset)) break block7;
                        DefaultPieDataset pieDataset = (DefaultPieDataset)dataset;
                        while (iCells.hasNext() && iHeaders.hasNext()) {
                            key = ((Element)iHeaders.next()).getTextTrim();
                            String value = ((Element)iCells.next()).getTextTrim();
                            pieDataset.setValue((Comparable)((Object)key), (Number)this.toDouble(value));
                        }
                        break block6;
                    }
                    if (!(dataset instanceof DefaultCategoryDataset)) break block8;
                    DefaultCategoryDataset catDataset = (DefaultCategoryDataset)dataset;
                    while (iCells.hasNext() && iHeaders.hasNext()) {
                        key = ((Element)iHeaders.next()).getTextTrim();
                        String value = ((Element)iCells.next()).getTextTrim();
                        catDataset.setValue((Number)this.toDouble(value), (Comparable)((Object)range), (Comparable)((Object)key));
                    }
                    break block6;
                }
                if (!(dataset instanceof XYSeriesCollection)) break block9;
                XYSeries xySeries = new XYSeries((Comparable)((Object)range));
                ((XYSeriesCollection)dataset).addSeries(xySeries);
                while (iCells.hasNext() && iHeaders.hasNext()) {
                    key = ((Element)iHeaders.next()).getTextTrim();
                    String value = ((Element)iCells.next()).getTextTrim();
                    xySeries.add((Number)this.toDouble(key), (Number)this.toDouble(value));
                }
                break block6;
            }
            if (!(dataset instanceof TimeSeriesCollection)) break block6;
            TimeSeries timeSeries = new TimeSeries(range, timePeriodClass);
            ((TimeSeriesCollection)dataset).addSeries(timeSeries);
            while (iCells.hasNext() && iHeaders.hasNext()) {
                key = ((Element)iHeaders.next()).getTextTrim();
                String value = ((Element)iCells.next()).getTextTrim();
                try {
                    timeSeries.add(RegularTimePeriod.createInstance((Class)timePeriodClass, (Date)dateFormat.parse(key), (TimeZone)TimeZone.getDefault()), (Number)this.toDouble(value));
                }
                catch (ParseException exception) {
                    throw new MacroException("Data could not be converted to a date: " + key);
                }
            }
        }
    }

    private void processVerticalDataRow(Element row, Dataset dataset, Element headerRow, int tableNumber, DateFormat dateFormat, Class timePeriodClass) throws MacroException {
        List cells = row.elements();
        List headers = headerRow.elements();
        if (cells.size() > 1 && headers.size() > 1) {
            if (dataset instanceof DefaultPieDataset) {
                DefaultPieDataset pieDataset = (DefaultPieDataset)dataset;
                String key = ((Element)cells.get(0)).getTextTrim();
                String value = ((Element)cells.get(1)).getTextTrim();
                pieDataset.setValue((Comparable)((Object)key), (Number)this.toDouble(value));
            } else if (dataset instanceof DefaultCategoryDataset) {
                DefaultCategoryDataset catDataset = (DefaultCategoryDataset)dataset;
                Iterator iCells = cells.iterator();
                Iterator iHeaders = headers.iterator();
                String domain = ((Element)iHeaders.next()).getTextTrim();
                String range = ((Element)iCells.next()).getTextTrim();
                while (iCells.hasNext() && iHeaders.hasNext()) {
                    String key = ((Element)iHeaders.next()).getTextTrim();
                    String value = ((Element)iCells.next()).getTextTrim();
                    catDataset.setValue((Number)this.toDouble(value), (Comparable)((Object)key), (Comparable)((Object)range));
                }
            } else if (dataset instanceof XYSeriesCollection) {
                XYSeries xySeries;
                if (tableNumber < ((XYSeriesCollection)dataset).getSeriesCount()) {
                    xySeries = ((XYSeriesCollection)dataset).getSeries(tableNumber);
                } else {
                    xySeries = new XYSeries((Comparable)((Object)((Element)headers.get(1)).getTextTrim()));
                    ((XYSeriesCollection)dataset).addSeries(xySeries);
                }
                String key = ((Element)cells.get(0)).getTextTrim();
                String value = ((Element)cells.get(1)).getTextTrim();
                xySeries.add((Number)this.toDouble(key), (Number)this.toDouble(value));
            } else if (dataset instanceof TimeSeriesCollection) {
                TimeSeries timeSeries;
                if (tableNumber < ((TimeSeriesCollection)dataset).getSeriesCount()) {
                    timeSeries = ((TimeSeriesCollection)dataset).getSeries(tableNumber);
                } else {
                    timeSeries = new TimeSeries(((Element)headers.get(1)).getTextTrim(), timePeriodClass);
                    ((TimeSeriesCollection)dataset).addSeries(timeSeries);
                }
                String key = ((Element)cells.get(0)).getTextTrim();
                String value = ((Element)cells.get(1)).getTextTrim();
                try {
                    timeSeries.add(RegularTimePeriod.createInstance((Class)timePeriodClass, (Date)dateFormat.parse(key), (TimeZone)TimeZone.getDefault()), (Number)this.toDouble(value));
                }
                catch (ParseException exception) {
                    throw new MacroException("Data could not be converted to a date: " + key);
                }
            }
        }
    }

    private Double toDouble(String value) throws NumberFormatException {
        if (value == null) {
            return new Double(0.0);
        }
        if ((value = value.replaceAll("[^0-9\\.-]", "")).length() == 0) {
            return new Double(0.0);
        }
        return new Double(value);
    }

    private Map toLowerCase(Map params) {
        HashMap lcParams = new HashMap();
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            lcParams.put(((String)e.getKey()).toLowerCase(), e.getValue());
        }
        return lcParams;
    }

    private Color stringToColor(String string) throws MacroException {
        String hexColor;
        if (string == null) {
            return null;
        }
        if ("aqua".equalsIgnoreCase(string = string.trim())) {
            hexColor = "#00FFFF";
        } else if ("black".equalsIgnoreCase(string)) {
            hexColor = "#000000";
        } else if ("blue".equalsIgnoreCase(string)) {
            hexColor = "#0000FF";
        } else if ("cyan".equalsIgnoreCase(string)) {
            hexColor = "#00FFFF";
        } else if ("fuchsia".equalsIgnoreCase(string)) {
            hexColor = "#FF00FF";
        } else if ("gray".equalsIgnoreCase(string)) {
            hexColor = "#808080";
        } else if ("green".equalsIgnoreCase(string)) {
            hexColor = "#00FF00";
        } else if ("lime".equalsIgnoreCase(string)) {
            hexColor = "#00FF00";
        } else if ("maroon".equalsIgnoreCase(string)) {
            hexColor = "#800000";
        } else if ("navy".equalsIgnoreCase(string)) {
            hexColor = "#000080";
        } else if ("olive".equalsIgnoreCase(string)) {
            hexColor = "#808000";
        } else if ("purple".equalsIgnoreCase(string)) {
            hexColor = "#FFC0FF";
        } else if ("red".equalsIgnoreCase(string)) {
            hexColor = "#FF0000";
        } else if ("silver".equalsIgnoreCase(string)) {
            hexColor = "#C0C0C0";
        } else if ("teal".equalsIgnoreCase(string)) {
            hexColor = "#808000";
        } else if ("violet".equalsIgnoreCase(string)) {
            hexColor = "#ee82ee";
        } else if ("white".equalsIgnoreCase(string)) {
            hexColor = "#FFFFFF";
        } else if ("yellow".equalsIgnoreCase(string)) {
            hexColor = "#FFFF00";
        } else {
            if (string.charAt(0) != '#') {
                throw new MacroException("Invalid color '" + string + "'");
            }
            hexColor = string;
        }
        try {
            return new Color(Integer.valueOf(hexColor.substring(1), 16));
        }
        catch (NumberFormatException exception) {
            throw new MacroException("Invalid color '" + string + "'");
        }
    }

    private int getIntegerParameter(Map parameters, String param, int def) throws MacroException {
        return this.getIntegerParameter(parameters, param, new Integer(def));
    }

    private Integer getIntegerParameter(Map parameters, String param, Integer def) throws MacroException {
        Integer result = def;
        if (TextUtils.stringSet((String)((String)parameters.get(param)))) {
            try {
                result = new Integer((String)parameters.get(param));
            }
            catch (NumberFormatException exception) {
                throw new MacroException("Invalid " + param + " parameter.  It must be an integer.");
            }
        }
        return result;
    }

    private Double getDoubleParameter(Map parameters, String param, Double def) throws MacroException {
        Double result = def;
        if (TextUtils.stringSet((String)((String)parameters.get(param)))) {
            try {
                result = new Double((String)parameters.get(param));
            }
            catch (NumberFormatException exception) {
                throw new MacroException("Invalid " + param + " parameter.  It must be an double value.");
            }
        }
        return result;
    }
}

