/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DurationFieldType;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.BasePeriodFormatter;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

public class PeriodFormatterBuilder {
    private static final int PRINT_ZERO_RARELY_FIRST = 1;
    private static final int PRINT_ZERO_RARELY_LAST = 2;
    private static final int PRINT_ZERO_IF_SUPPORTED = 3;
    private static final int PRINT_ZERO_ALWAYS = 4;
    private static final int PRINT_ZERO_NEVER = 5;
    private static final int YEARS = 0;
    private static final int MONTHS = 1;
    private static final int WEEKS = 2;
    private static final int DAYS = 3;
    private static final int HOURS = 4;
    private static final int MINUTES = 5;
    private static final int SECONDS = 6;
    private static final int MILLIS = 7;
    private static final int SECONDS_MILLIS = 8;
    private static final int SECONDS_OPTIONAL_MILLIS = 9;
    private int iMinPrintedDigits;
    private int iPrintZeroSetting;
    private int iMaxParsedDigits;
    private boolean iRejectSignedValues;
    private PeriodFieldAffix iPrefix;
    private List iFormatters;
    private FieldFormatter[] iFieldFormatters;

    public PeriodFormatterBuilder() {
        this.clear();
    }

    public PeriodPrinter toPrinter() {
        return this.toFormatter();
    }

    public PeriodParser toParser() {
        return this.toFormatter();
    }

    public PeriodFormatter toFormatter() {
        PeriodFormatter formatter = PeriodFormatterBuilder.toFormatter(this.iFormatters);
        this.iFieldFormatters = (FieldFormatter[])this.iFieldFormatters.clone();
        return formatter;
    }

    private static PeriodFormatter toFormatter(List formatters) {
        int size = formatters.size();
        if (size >= 1 && formatters.get(0) instanceof Separator) {
            Separator sep = (Separator)formatters.get(0);
            return sep.finish((BasePeriodFormatter)((Object)PeriodFormatterBuilder.toFormatter(formatters.subList(1, size))));
        }
        return (PeriodFormatter)((Object)PeriodFormatterBuilder.createComposite(formatters));
    }

    public void clear() {
        this.iMinPrintedDigits = 1;
        this.iPrintZeroSetting = 2;
        this.iMaxParsedDigits = 10;
        this.iRejectSignedValues = false;
        this.iPrefix = null;
        if (this.iFormatters == null) {
            this.iFormatters = new ArrayList();
        } else {
            this.iFormatters.clear();
        }
        this.iFieldFormatters = new FieldFormatter[10];
    }

    public PeriodFormatterBuilder append(PeriodFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        if (!(formatter instanceof BasePeriodFormatter)) {
            throw new IllegalArgumentException("Formatter must extend BasePeriodFormatter");
        }
        this.clearPrefix();
        this.iFormatters.add(formatter);
        return this;
    }

    public PeriodFormatterBuilder appendLiteral(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        this.clearPrefix();
        Literal literal = new Literal(text);
        this.iFormatters.add(literal);
        return this;
    }

    public PeriodFormatterBuilder minimumPrintedDigits(int minDigits) {
        this.iMinPrintedDigits = minDigits;
        return this;
    }

    public PeriodFormatterBuilder maximumParsedDigits(int maxDigits) {
        this.iMaxParsedDigits = maxDigits;
        return this;
    }

    public PeriodFormatterBuilder rejectSignedValues(boolean v) {
        this.iRejectSignedValues = v;
        return this;
    }

    public PeriodFormatterBuilder printZeroRarelyLast() {
        this.iPrintZeroSetting = 2;
        return this;
    }

    public PeriodFormatterBuilder printZeroRarelyFirst() {
        this.iPrintZeroSetting = 1;
        return this;
    }

    public PeriodFormatterBuilder printZeroIfSupported() {
        this.iPrintZeroSetting = 3;
        return this;
    }

    public PeriodFormatterBuilder printZeroAlways() {
        this.iPrintZeroSetting = 4;
        return this;
    }

    public PeriodFormatterBuilder printZeroNever() {
        this.iPrintZeroSetting = 5;
        return this;
    }

    public PeriodFormatterBuilder appendPrefix(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new SimpleAffix(text));
    }

    public PeriodFormatterBuilder appendPrefix(String singularText, String pluralText) {
        if (singularText == null || pluralText == null) {
            throw new IllegalArgumentException();
        }
        return this.appendPrefix(new PluralAffix(singularText, pluralText));
    }

    private PeriodFormatterBuilder appendPrefix(PeriodFieldAffix prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (this.iPrefix != null) {
            prefix = new CompositeAffix(this.iPrefix, prefix);
        }
        this.iPrefix = prefix;
        return this;
    }

    public PeriodFormatterBuilder appendYears() {
        this.appendField(0);
        return this;
    }

    public PeriodFormatterBuilder appendMonths() {
        this.appendField(1);
        return this;
    }

    public PeriodFormatterBuilder appendWeeks() {
        this.appendField(2);
        return this;
    }

    public PeriodFormatterBuilder appendDays() {
        this.appendField(3);
        return this;
    }

    public PeriodFormatterBuilder appendHours() {
        this.appendField(4);
        return this;
    }

    public PeriodFormatterBuilder appendMinutes() {
        this.appendField(5);
        return this;
    }

    public PeriodFormatterBuilder appendSeconds() {
        this.appendField(6);
        return this;
    }

    public PeriodFormatterBuilder appendSecondsWithMillis() {
        this.appendField(8);
        return this;
    }

    public PeriodFormatterBuilder appendSecondsWithOptionalMillis() {
        this.appendField(9);
        return this;
    }

    public PeriodFormatterBuilder appendMillis() {
        this.appendField(7);
        return this;
    }

    public PeriodFormatterBuilder appendMillis3Digit() {
        this.appendField(7, 3);
        return this;
    }

    private void appendField(int type) {
        this.appendField(type, this.iMinPrintedDigits);
    }

    private void appendField(int type, int minPrinted) {
        FieldFormatter field = new FieldFormatter(minPrinted, this.iPrintZeroSetting, this.iMaxParsedDigits, this.iRejectSignedValues, type, this.iFieldFormatters, this.iPrefix, null);
        this.iFormatters.add(field);
        this.iFieldFormatters[type] = field;
        this.iPrefix = null;
    }

    public PeriodFormatterBuilder appendSuffix(String text) {
        if (text == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new SimpleAffix(text));
    }

    public PeriodFormatterBuilder appendSuffix(String singularText, String pluralText) {
        if (singularText == null || pluralText == null) {
            throw new IllegalArgumentException();
        }
        return this.appendSuffix(new PluralAffix(singularText, pluralText));
    }

    private PeriodFormatterBuilder appendSuffix(PeriodFieldAffix suffix) {
        Object originalField = this.iFormatters.size() > 0 ? this.iFormatters.get(this.iFormatters.size() - 1) : null;
        if (originalField == null || !(originalField instanceof FieldFormatter)) {
            throw new IllegalStateException("No field to apply suffix to");
        }
        this.clearPrefix();
        FieldFormatter newField = new FieldFormatter(originalField, suffix);
        this.iFormatters.set(this.iFormatters.size() - 1, newField);
        this.iFieldFormatters[newField.getFieldType()] = newField;
        return this;
    }

    public PeriodFormatterBuilder appendSeparator(String text) {
        return this.appendSeparator(text, text, true, true);
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsAfter(String text) {
        return this.appendSeparator(text, text, false, true);
    }

    public PeriodFormatterBuilder appendSeparatorIfFieldsBefore(String text) {
        return this.appendSeparator(text, text, true, false);
    }

    public PeriodFormatterBuilder appendSeparator(String text, String finalText) {
        return this.appendSeparator(text, finalText, true, true);
    }

    private PeriodFormatterBuilder appendSeparator(String text, String finalText, boolean useBefore, boolean useAfter) {
        if (text == null || finalText == null) {
            throw new IllegalArgumentException();
        }
        this.clearPrefix();
        List<Separator> formatters = this.iFormatters;
        if (formatters.size() == 0) {
            if (useAfter && !useBefore) {
                formatters.add(new Separator(text, finalText, Literal.EMPTY, useBefore, useAfter));
            }
            return this;
        }
        Separator lastSeparator = null;
        int i = formatters.size();
        while (--i >= 0) {
            if (!(formatters.get(i) instanceof Separator)) continue;
            lastSeparator = (Separator)formatters.get(i);
            formatters = formatters.subList(i + 1, formatters.size());
            break;
        }
        if (lastSeparator != null && formatters.size() == 0) {
            throw new IllegalStateException("Cannot have two adjacent separators");
        }
        BasePeriodFormatter composite = PeriodFormatterBuilder.createComposite(formatters);
        formatters.clear();
        formatters.add(new Separator(text, finalText, composite, useBefore, useAfter));
        return this;
    }

    private void clearPrefix() throws IllegalStateException {
        if (this.iPrefix != null) {
            throw new IllegalStateException("Prefix not followed by field");
        }
        this.iPrefix = null;
    }

    private static BasePeriodFormatter createComposite(List formatters) {
        switch (formatters.size()) {
            case 0: {
                return Literal.EMPTY;
            }
            case 1: {
                return (BasePeriodFormatter)formatters.get(0);
            }
        }
        return new Composite(formatters);
    }

    static class Composite
    extends BasePeriodFormatter
    implements PeriodFormatter {
        private final BasePeriodFormatter[] iFormatters;

        Composite(List formatters) {
            this.iFormatters = formatters.toArray(new BasePeriodFormatter[formatters.size()]);
        }

        public int countFieldsToPrint(ReadablePeriod period, int stopAt) {
            int sum = 0;
            BasePeriodFormatter[] printers = this.iFormatters;
            int i = printers.length;
            while (sum < stopAt && --i >= 0) {
                sum += printers[i].countFieldsToPrint(period);
            }
            return sum;
        }

        public int calculatePrintedLength(ReadablePeriod period) {
            int sum = 0;
            BasePeriodFormatter[] printers = this.iFormatters;
            int i = printers.length;
            while (--i >= 0) {
                sum += printers[i].calculatePrintedLength(period);
            }
            return sum;
        }

        public void printTo(StringBuffer buf, ReadablePeriod period) {
            BasePeriodFormatter[] printers = this.iFormatters;
            int len = printers.length;
            int i = 0;
            while (i < len) {
                printers[i].printTo(buf, period);
                ++i;
            }
        }

        public void printTo(Writer out, ReadablePeriod period) throws IOException {
            BasePeriodFormatter[] printers = this.iFormatters;
            int len = printers.length;
            int i = 0;
            while (i < len) {
                printers[i].printTo(out, period);
                ++i;
            }
        }

        public int parseInto(ReadWritablePeriod period, String periodStr, int position) {
            BasePeriodFormatter[] parsers = this.iFormatters;
            if (parsers == null) {
                throw new UnsupportedOperationException();
            }
            int len = parsers.length;
            int i = 0;
            while (i < len && position >= 0) {
                position = parsers[i].parseInto(period, periodStr, position);
                ++i;
            }
            return position;
        }
    }

    static class Separator
    extends BasePeriodFormatter
    implements PeriodFormatter {
        private final String iText;
        private final String iFinalText;
        private final boolean iUseBefore;
        private final boolean iUseAfter;
        private BasePeriodFormatter iBefore;
        private BasePeriodFormatter iAfter;

        Separator(String text, String finalText, BasePeriodFormatter before, boolean useBefore, boolean useAfter) {
            this.iText = text;
            this.iFinalText = finalText;
            this.iBefore = before;
            this.iUseBefore = useBefore;
            this.iUseAfter = useAfter;
        }

        public int countFieldsToPrint(ReadablePeriod period, int stopAt) {
            int sum = this.iBefore.countFieldsToPrint(period, stopAt);
            if (sum < stopAt) {
                sum += this.iAfter.countFieldsToPrint(period, stopAt);
            }
            return sum;
        }

        public int calculatePrintedLength(ReadablePeriod period) {
            BasePeriodFormatter before = this.iBefore;
            BasePeriodFormatter after = this.iAfter;
            int sum = before.calculatePrintedLength(period) + after.calculatePrintedLength(period);
            if (this.iUseBefore) {
                if (before.countFieldsToPrint(period, 1) > 0) {
                    if (this.iUseAfter) {
                        int afterCount = after.countFieldsToPrint(period, 2);
                        if (afterCount > 0) {
                            sum += (afterCount > 1 ? this.iText : this.iFinalText).length();
                        }
                    } else {
                        sum += this.iText.length();
                    }
                }
            } else if (this.iUseAfter && after.countFieldsToPrint(period, 1) > 0) {
                sum += this.iText.length();
            }
            return sum;
        }

        public void printTo(StringBuffer buf, ReadablePeriod period) {
            BasePeriodFormatter before = this.iBefore;
            BasePeriodFormatter after = this.iAfter;
            before.printTo(buf, period);
            if (this.iUseBefore) {
                if (before.countFieldsToPrint(period, 1) > 0) {
                    if (this.iUseAfter) {
                        int afterCount = after.countFieldsToPrint(period, 2);
                        if (afterCount > 0) {
                            buf.append(afterCount > 1 ? this.iText : this.iFinalText);
                        }
                    } else {
                        buf.append(this.iText);
                    }
                }
            } else if (this.iUseAfter && after.countFieldsToPrint(period, 1) > 0) {
                buf.append(this.iText);
            }
            after.printTo(buf, period);
        }

        public void printTo(Writer out, ReadablePeriod period) throws IOException {
            BasePeriodFormatter before = this.iBefore;
            BasePeriodFormatter after = this.iAfter;
            before.printTo(out, period);
            if (this.iUseBefore) {
                if (before.countFieldsToPrint(period, 1) > 0) {
                    if (this.iUseAfter) {
                        int afterCount = after.countFieldsToPrint(period, 2);
                        if (afterCount > 0) {
                            out.write(afterCount > 1 ? this.iText : this.iFinalText);
                        }
                    } else {
                        out.write(this.iText);
                    }
                }
            } else if (this.iUseAfter && after.countFieldsToPrint(period, 1) > 0) {
                out.write(this.iText);
            }
            after.printTo(out, period);
        }

        public int parseInto(ReadWritablePeriod period, String periodStr, int position) {
            int oldPos = position;
            if ((position = this.iBefore.parseInto(period, periodStr, position)) < 0) {
                return position;
            }
            if (position > oldPos) {
                if (periodStr.regionMatches(true, position, this.iText, 0, this.iText.length())) {
                    position += this.iText.length();
                } else if (this.iText != this.iFinalText && periodStr.regionMatches(true, position, this.iFinalText, 0, this.iFinalText.length())) {
                    position += this.iFinalText.length();
                }
            }
            position = this.iAfter.parseInto(period, periodStr, position);
            return position;
        }

        Separator finish(BasePeriodFormatter after) {
            this.iAfter = after;
            return this;
        }
    }

    static class Literal
    extends BasePeriodFormatter
    implements PeriodFormatter {
        static final Literal EMPTY = new Literal("");
        private final String iText;

        Literal(String text) {
            this.iText = text;
        }

        public int countFieldsToPrint(ReadablePeriod period, int stopAt) {
            return 0;
        }

        public int calculatePrintedLength(ReadablePeriod period) {
            return this.iText.length();
        }

        public void printTo(StringBuffer buf, ReadablePeriod period) {
            buf.append(this.iText);
        }

        public void printTo(Writer out, ReadablePeriod period) throws IOException {
            out.write(this.iText);
        }

        public int parseInto(ReadWritablePeriod period, String periodStr, int position) {
            if (periodStr.regionMatches(true, position, this.iText, 0, this.iText.length())) {
                return position + this.iText.length();
            }
            return ~position;
        }
    }

    static class FieldFormatter
    extends BasePeriodFormatter
    implements PeriodFormatter {
        private final int iMinPrintedDigits;
        private final int iPrintZeroSetting;
        private final int iMaxParsedDigits;
        private final boolean iRejectSignedValues;
        private final int iFieldType;
        private final FieldFormatter[] iFieldFormatters;
        private final PeriodFieldAffix iPrefix;
        private final PeriodFieldAffix iSuffix;

        FieldFormatter(int minPrintedDigits, int printZeroSetting, int maxParsedDigits, boolean rejectSignedValues, int fieldType, FieldFormatter[] fieldFormatters, PeriodFieldAffix prefix, PeriodFieldAffix suffix) {
            this.iMinPrintedDigits = minPrintedDigits;
            this.iPrintZeroSetting = printZeroSetting;
            this.iMaxParsedDigits = maxParsedDigits;
            this.iRejectSignedValues = rejectSignedValues;
            this.iFieldType = fieldType;
            this.iFieldFormatters = fieldFormatters;
            this.iPrefix = prefix;
            this.iSuffix = suffix;
        }

        FieldFormatter(FieldFormatter field, PeriodFieldAffix suffix) {
            this.iMinPrintedDigits = field.iMinPrintedDigits;
            this.iPrintZeroSetting = field.iPrintZeroSetting;
            this.iMaxParsedDigits = field.iMaxParsedDigits;
            this.iRejectSignedValues = field.iRejectSignedValues;
            this.iFieldType = field.iFieldType;
            this.iFieldFormatters = field.iFieldFormatters;
            this.iPrefix = field.iPrefix;
            if (field.iSuffix != null) {
                suffix = new CompositeAffix(field.iSuffix, suffix);
            }
            this.iSuffix = suffix;
        }

        public int countFieldsToPrint(ReadablePeriod period) {
            if (this.iPrintZeroSetting == 4 || this.getFieldValue(period) != Long.MAX_VALUE) {
                return 1;
            }
            return 0;
        }

        public int countFieldsToPrint(ReadablePeriod period, int stopAt) {
            return stopAt <= 0 ? 0 : this.countFieldsToPrint(period);
        }

        public int calculatePrintedLength(ReadablePeriod period) {
            long valueLong = this.getFieldValue(period);
            if (valueLong == Long.MAX_VALUE) {
                return 0;
            }
            int sum = Math.max(FormatUtils.calculateDigitCount(valueLong), this.iMinPrintedDigits);
            if (this.iFieldType >= 8) {
                ++sum;
                if (this.iFieldType == 9 && Math.abs(valueLong) % 1000L == 0L) {
                    sum -= 4;
                }
                valueLong /= 1000L;
            }
            int value = (int)valueLong;
            if (this.iPrefix != null) {
                sum += this.iPrefix.calculatePrintedLength(value);
            }
            if (this.iSuffix != null) {
                sum += this.iSuffix.calculatePrintedLength(value);
            }
            return sum;
        }

        public void printTo(StringBuffer buf, ReadablePeriod period) {
            int minDigits;
            long valueLong = this.getFieldValue(period);
            if (valueLong == Long.MAX_VALUE) {
                return;
            }
            int value = (int)valueLong;
            if (this.iFieldType >= 8) {
                value = (int)(valueLong / 1000L);
            }
            if (this.iPrefix != null) {
                this.iPrefix.printTo(buf, value);
            }
            if ((minDigits = this.iMinPrintedDigits) <= 1) {
                FormatUtils.appendUnpaddedInteger(buf, value);
            } else {
                FormatUtils.appendPaddedInteger(buf, value, minDigits);
            }
            if (this.iFieldType >= 8) {
                int dp = (int)(Math.abs(valueLong) % 1000L);
                if (this.iFieldType == 8 || dp > 0) {
                    buf.append('.');
                    FormatUtils.appendPaddedInteger(buf, dp, 3);
                }
            }
            if (this.iSuffix != null) {
                this.iSuffix.printTo(buf, value);
            }
        }

        public void printTo(Writer out, ReadablePeriod period) throws IOException {
            int minDigits;
            long valueLong = this.getFieldValue(period);
            if (valueLong == Long.MAX_VALUE) {
                return;
            }
            int value = (int)valueLong;
            if (this.iFieldType >= 8) {
                value = (int)(valueLong / 1000L);
            }
            if (this.iPrefix != null) {
                this.iPrefix.printTo(out, value);
            }
            if ((minDigits = this.iMinPrintedDigits) <= 1) {
                FormatUtils.writeUnpaddedInteger(out, value);
            } else {
                FormatUtils.writePaddedInteger(out, value, minDigits);
            }
            if (this.iFieldType >= 8) {
                int dp = (int)(Math.abs(valueLong) % 1000L);
                if (this.iFieldType == 8 || dp > 0) {
                    out.write(46);
                    FormatUtils.writePaddedInteger(out, dp, 3);
                }
            }
            if (this.iSuffix != null) {
                this.iSuffix.printTo(out, value);
            }
        }

        public int parseInto(ReadWritablePeriod period, String text, int position) {
            boolean mustParse;
            boolean bl = mustParse = this.iPrintZeroSetting == 4;
            if (position >= text.length()) {
                return mustParse ? ~position : position;
            }
            if (this.iPrefix != null) {
                if ((position = this.iPrefix.parse(text, position)) >= 0) {
                    mustParse = true;
                } else {
                    if (!mustParse) {
                        return ~position;
                    }
                    return position;
                }
            }
            int suffixPos = -1;
            if (this.iSuffix != null && !mustParse) {
                suffixPos = this.iSuffix.scan(text, position);
                if (suffixPos >= 0) {
                    mustParse = true;
                } else {
                    if (!mustParse) {
                        return ~suffixPos;
                    }
                    return suffixPos;
                }
            }
            if (!mustParse && !this.isSupported(period.getPeriodType(), this.iFieldType)) {
                return position;
            }
            int limit = suffixPos > 0 ? Math.min(this.iMaxParsedDigits, suffixPos - position) : Math.min(this.iMaxParsedDigits, text.length() - position);
            boolean negative = false;
            int length = 0;
            int dp = -1;
            while (length < limit) {
                char c = text.charAt(position + length);
                if (!(length != 0 || c != '-' && c != '+' || this.iRejectSignedValues)) {
                    boolean bl2 = negative = c == '-';
                    if (negative) {
                        ++length;
                    } else {
                        ++position;
                    }
                    limit = Math.min(limit + 1, text.length() - position);
                    continue;
                }
                if (c < '0' || c > '9') {
                    if (c != '.' || this.iFieldType != 8 && this.iFieldType != 9) break;
                    if (dp >= 0) {
                        return position + length;
                    }
                    dp = length;
                }
                ++length;
            }
            if (length == 0 || length == 1 && dp == 0 || dp == -1 && this.iFieldType == 8) {
                return ~position;
            }
            if (position + length != suffixPos) {
                return position;
            }
            if (this.iFieldType == 8 || this.iFieldType == 9) {
                if (dp == -1) {
                    position = this.parseField(period, text, position, negative, length, 6);
                    this.setFieldValue(period, 7, 0);
                } else {
                    if (dp > 0) {
                        position = this.parseField(period, text, position, negative, dp, 6);
                    } else {
                        this.setFieldValue(period, 6, 0);
                    }
                    ++position;
                    int millisLength = length - 1 - dp;
                    if (millisLength > 3) {
                        position = this.parseField(period, text, position, false, 3, 7);
                        position += millisLength - 3;
                    } else if (millisLength == 0) {
                        this.setFieldValue(period, 7, 0);
                    } else {
                        position = this.parseField(period, text, position, false, millisLength, 7);
                    }
                }
            } else {
                position = this.parseField(period, text, position, negative, length, this.iFieldType);
            }
            if (position >= 0 && this.iSuffix != null) {
                position = this.iSuffix.parse(text, position);
            }
            return position;
        }

        private int parseField(ReadWritablePeriod period, String text, int position, boolean negative, int length, int type) {
            int value;
            if (length >= 9) {
                value = Integer.parseInt(text.substring(position, position += length));
            } else {
                int i = position;
                if (negative) {
                    // empty if block
                }
                int n = ++i;
                ++i;
                value = text.charAt(n) - 48;
                position += length;
                while (i < position) {
                    value = (value << 3) + (value << 1) + text.charAt(i++) - 48;
                }
                if (negative) {
                    value = -value;
                }
            }
            this.setFieldValue(period, type, value);
            return position;
        }

        long getFieldValue(ReadablePeriod period) {
            int value;
            PeriodType type = this.iPrintZeroSetting == 4 ? null : period.getPeriodType();
            if (type != null && !this.isSupported(type, this.iFieldType)) {
                return Long.MAX_VALUE;
            }
            switch (this.iFieldType) {
                default: {
                    return Long.MAX_VALUE;
                }
                case 0: {
                    value = period.get(DurationFieldType.years());
                    break;
                }
                case 1: {
                    value = period.get(DurationFieldType.months());
                    break;
                }
                case 2: {
                    value = period.get(DurationFieldType.weeks());
                    break;
                }
                case 3: {
                    value = period.get(DurationFieldType.days());
                    break;
                }
                case 4: {
                    value = period.get(DurationFieldType.hours());
                    break;
                }
                case 5: {
                    value = period.get(DurationFieldType.minutes());
                    break;
                }
                case 6: {
                    value = period.get(DurationFieldType.seconds());
                    break;
                }
                case 7: {
                    value = period.get(DurationFieldType.millis());
                    break;
                }
                case 8: 
                case 9: {
                    int seconds = period.get(DurationFieldType.seconds());
                    int millis = period.get(DurationFieldType.millis());
                    value = seconds * 1000 + millis;
                }
            }
            if (value == 0) {
                switch (this.iPrintZeroSetting) {
                    case 5: {
                        return Long.MAX_VALUE;
                    }
                    case 2: {
                        if (this.isZero(period) && this.iFieldFormatters[this.iFieldType] == this) {
                            int i = this.iFieldType + 1;
                            while (i < 10) {
                                if (this.isSupported(type, i) && this.iFieldFormatters[i] != null) {
                                    return Long.MAX_VALUE;
                                }
                                ++i;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                    case 1: {
                        if (this.isZero(period) && this.iFieldFormatters[this.iFieldType] == this) {
                            int i = Math.min(this.iFieldType, 8) - 1;
                            while (i >= 0) {
                                if (this.isSupported(type, i) && this.iFieldFormatters[i] != null) {
                                    return Long.MAX_VALUE;
                                }
                                ++i;
                            }
                            break;
                        }
                        return Long.MAX_VALUE;
                    }
                }
            }
            return value;
        }

        boolean isZero(ReadablePeriod period) {
            int i = 0;
            int isize = period.size();
            while (i < isize) {
                if (period.getValue(i) != 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        boolean isSupported(PeriodType type, int field) {
            switch (field) {
                default: {
                    return false;
                }
                case 0: {
                    return type.isSupported(DurationFieldType.years());
                }
                case 1: {
                    return type.isSupported(DurationFieldType.months());
                }
                case 2: {
                    return type.isSupported(DurationFieldType.weeks());
                }
                case 3: {
                    return type.isSupported(DurationFieldType.days());
                }
                case 4: {
                    return type.isSupported(DurationFieldType.hours());
                }
                case 5: {
                    return type.isSupported(DurationFieldType.minutes());
                }
                case 6: {
                    return type.isSupported(DurationFieldType.seconds());
                }
                case 7: {
                    return type.isSupported(DurationFieldType.millis());
                }
                case 8: 
                case 9: 
            }
            return type.isSupported(DurationFieldType.seconds()) || type.isSupported(DurationFieldType.millis());
        }

        void setFieldValue(ReadWritablePeriod period, int field, int value) {
            switch (field) {
                default: {
                    break;
                }
                case 0: {
                    period.setYears(value);
                    break;
                }
                case 1: {
                    period.setMonths(value);
                    break;
                }
                case 2: {
                    period.setWeeks(value);
                    break;
                }
                case 3: {
                    period.setDays(value);
                    break;
                }
                case 4: {
                    period.setHours(value);
                    break;
                }
                case 5: {
                    period.setMinutes(value);
                    break;
                }
                case 6: {
                    period.setSeconds(value);
                    break;
                }
                case 7: {
                    period.setMillis(value);
                }
            }
        }

        int getFieldType() {
            return this.iFieldType;
        }
    }

    static class CompositeAffix
    implements PeriodFieldAffix {
        private final PeriodFieldAffix iLeft;
        private final PeriodFieldAffix iRight;

        CompositeAffix(PeriodFieldAffix left, PeriodFieldAffix right) {
            this.iLeft = left;
            this.iRight = right;
        }

        public int calculatePrintedLength(int value) {
            return this.iLeft.calculatePrintedLength(value) + this.iRight.calculatePrintedLength(value);
        }

        public void printTo(StringBuffer buf, int value) {
            this.iLeft.printTo(buf, value);
            this.iRight.printTo(buf, value);
        }

        public void printTo(Writer out, int value) throws IOException {
            this.iLeft.printTo(out, value);
            this.iRight.printTo(out, value);
        }

        public int parse(String periodStr, int position) {
            if ((position = this.iLeft.parse(periodStr, position)) >= 0) {
                position = this.iRight.parse(periodStr, position);
            }
            return position;
        }

        public int scan(String periodStr, int position) {
            int pos = this.iLeft.scan(periodStr, position);
            if (pos >= 0) {
                return this.iRight.scan(periodStr, pos);
            }
            return ~position;
        }
    }

    static class PluralAffix
    implements PeriodFieldAffix {
        private final String iSingularText;
        private final String iPluralText;

        PluralAffix(String singularText, String pluralText) {
            this.iSingularText = singularText;
            this.iPluralText = pluralText;
        }

        public int calculatePrintedLength(int value) {
            return (value == 1 ? this.iSingularText : this.iPluralText).length();
        }

        public void printTo(StringBuffer buf, int value) {
            buf.append(value == 1 ? this.iSingularText : this.iPluralText);
        }

        public void printTo(Writer out, int value) throws IOException {
            out.write(value == 1 ? this.iSingularText : this.iPluralText);
        }

        public int parse(String periodStr, int position) {
            String text1 = this.iPluralText;
            String text2 = this.iSingularText;
            if (text1.length() < text2.length()) {
                String temp = text1;
                text1 = text2;
                text2 = temp;
            }
            if (periodStr.regionMatches(true, position, text1, 0, text1.length())) {
                return position + text1.length();
            }
            if (periodStr.regionMatches(true, position, text2, 0, text2.length())) {
                return position + text2.length();
            }
            return ~position;
        }

        public int scan(String periodStr, int position) {
            String text1 = this.iPluralText;
            String text2 = this.iSingularText;
            if (text1.length() < text2.length()) {
                String temp = text1;
                text1 = text2;
                text2 = temp;
            }
            int textLength1 = text1.length();
            int textLength2 = text2.length();
            int sourceLength = periodStr.length();
            int pos = position;
            while (pos < sourceLength) {
                if (periodStr.regionMatches(true, pos, text1, 0, textLength1)) {
                    return pos;
                }
                if (periodStr.regionMatches(true, pos, text2, 0, textLength2)) {
                    return pos;
                }
                ++pos;
            }
            return ~position;
        }
    }

    static class SimpleAffix
    implements PeriodFieldAffix {
        private final String iText;

        SimpleAffix(String text) {
            this.iText = text;
        }

        public int calculatePrintedLength(int value) {
            return this.iText.length();
        }

        public void printTo(StringBuffer buf, int value) {
            buf.append(this.iText);
        }

        public void printTo(Writer out, int value) throws IOException {
            out.write(this.iText);
        }

        public int parse(String periodStr, int position) {
            String text = this.iText;
            int textLength = text.length();
            if (periodStr.regionMatches(true, position, text, 0, textLength)) {
                return position + textLength;
            }
            return ~position;
        }

        public int scan(String periodStr, int position) {
            String text = this.iText;
            int textLength = text.length();
            int sourceLength = periodStr.length();
            int pos = position;
            while (pos < sourceLength) {
                if (periodStr.regionMatches(true, pos, text, 0, textLength)) {
                    return pos;
                }
                ++pos;
            }
            return ~position;
        }
    }

    static interface PeriodFieldAffix {
        public int calculatePrintedLength(int var1);

        public void printTo(StringBuffer var1, int var2);

        public void printTo(Writer var1, int var2) throws IOException;

        public int parse(String var1, int var2);

        public int scan(String var1, int var2);
    }
}

