/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.format.BaseDateTimeFormatter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.FormatUtils;

public class DateTimeFormatterBuilder {
    private final Locale iLocale;
    private ArrayList iElementPairs;
    private Object iFormatter;

    public DateTimeFormatterBuilder() {
        this(Locale.getDefault());
    }

    public DateTimeFormatterBuilder(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.iLocale = locale;
        this.iElementPairs = new ArrayList();
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public DateTimePrinter toPrinter() throws UnsupportedOperationException {
        Object f = this.getFormatter();
        if (this.isPrinter(f)) {
            return (DateTimePrinter)f;
        }
        throw new UnsupportedOperationException("Printing not supported");
    }

    public DateTimeParser toParser() throws UnsupportedOperationException {
        Object f = this.getFormatter();
        if (this.isParser(f)) {
            return (DateTimeParser)f;
        }
        throw new UnsupportedOperationException("Parsing not supported");
    }

    public DateTimeFormatter toFormatter() throws UnsupportedOperationException {
        Object f = this.getFormatter();
        if (this.isFormatter(f)) {
            return (DateTimeFormatter)f;
        }
        throw new UnsupportedOperationException("Both printing and parsing not supported");
    }

    public boolean canBuildPrinter() {
        return this.isPrinter(this.getFormatter());
    }

    public boolean canBuildParser() {
        return this.isParser(this.getFormatter());
    }

    public boolean canBuildFormatter() {
        return this.isFormatter(this.getFormatter());
    }

    public void clear() {
        this.iFormatter = null;
        this.iElementPairs.clear();
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter formatter) {
        if (formatter == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        if (!(formatter instanceof BaseDateTimeFormatter)) {
            throw new IllegalArgumentException("Formatter must extend BaseDateTimeFormatter");
        }
        return this.append0(formatter);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter printer) {
        this.checkPrinter(printer);
        return this.append0(printer, null);
    }

    public DateTimeFormatterBuilder append(DateTimeParser parser) {
        this.checkParser(parser);
        return this.append0(null, parser);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter printer, DateTimeParser parser) {
        this.checkPrinter(printer);
        this.checkParser(parser);
        return this.append0(printer, parser);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter printer, DateTimeParser[] parsers) {
        if (printer != null) {
            this.checkPrinter(printer);
        }
        if (parsers == null) {
            throw new IllegalArgumentException("No parsers supplied");
        }
        int length = parsers.length;
        BaseDateTimeFormatter[] copyOfParsers = new BaseDateTimeFormatter[length];
        int i = 0;
        while (i < length) {
            DateTimeParser parser = parsers[i];
            if (i != length - 1 || parser != null) {
                if (parser == null) {
                    throw new IllegalArgumentException("Incomplete parser array");
                }
                if (!(parser instanceof BaseDateTimeFormatter)) {
                    throw new IllegalArgumentException("Parser must extend BaseDateTimeFormatter");
                }
                copyOfParsers[i] = (BaseDateTimeFormatter)((Object)parser);
            }
            ++i;
        }
        return this.append0(printer, new MatchingParser(copyOfParsers));
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeParser parser) {
        this.checkParser(parser);
        BaseDateTimeFormatter[] parsers = new BaseDateTimeFormatter[]{(BaseDateTimeFormatter)((Object)parser), null};
        return this.append0(null, new MatchingParser(parsers));
    }

    private void checkParser(DateTimeParser parser) {
        if (parser == null) {
            throw new IllegalArgumentException("No parser supplied");
        }
        if (!(parser instanceof BaseDateTimeFormatter)) {
            throw new IllegalArgumentException("Parser must extend BaseDateTimeFormatter");
        }
    }

    private void checkPrinter(DateTimePrinter printer) {
        if (printer == null) {
            throw new IllegalArgumentException("No printer supplied");
        }
        if (!(printer instanceof BaseDateTimeFormatter)) {
            throw new IllegalArgumentException("Printer must extend BaseDateTimeFormatter");
        }
    }

    private DateTimeFormatterBuilder append0(Object element) {
        this.iFormatter = null;
        this.iElementPairs.add(element);
        this.iElementPairs.add(element);
        return this;
    }

    private DateTimeFormatterBuilder append0(DateTimePrinter printer, DateTimeParser parser) {
        this.iFormatter = null;
        this.iElementPairs.add(printer);
        this.iElementPairs.add(parser);
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char c) {
        return this.append0(new CharacterLiteral(c));
    }

    public DateTimeFormatterBuilder appendLiteral(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        switch (text.length()) {
            case 0: {
                return this;
            }
            case 1: {
                return this.append0(new CharacterLiteral(text.charAt(0)));
            }
        }
        return this.append0(new StringLiteral(text));
    }

    public DateTimeFormatterBuilder appendDecimal(DateTimeFieldType fieldType, int minDigits, int maxDigits) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (maxDigits < minDigits) {
            maxDigits = minDigits;
        }
        if (minDigits < 0 || maxDigits <= 0) {
            throw new IllegalArgumentException();
        }
        if (minDigits <= 1) {
            return this.append0(new UnpaddedNumber(fieldType, maxDigits, false));
        }
        return this.append0(new PaddedNumber(fieldType, maxDigits, false, minDigits));
    }

    public DateTimeFormatterBuilder appendSignedDecimal(DateTimeFieldType fieldType, int minDigits, int maxDigits) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (maxDigits < minDigits) {
            maxDigits = minDigits;
        }
        if (minDigits < 0 || maxDigits <= 0) {
            throw new IllegalArgumentException();
        }
        if (minDigits <= 1) {
            return this.append0(new UnpaddedNumber(fieldType, maxDigits, true));
        }
        return this.append0(new PaddedNumber(fieldType, maxDigits, true, minDigits));
    }

    public DateTimeFormatterBuilder appendText(DateTimeFieldType fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(fieldType, this.iLocale, false));
    }

    public DateTimeFormatterBuilder appendShortText(DateTimeFieldType fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(fieldType, this.iLocale, true));
    }

    public DateTimeFormatterBuilder appendFraction(DateTimeFieldType fieldType, int minDigits, int maxDigits) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (maxDigits < minDigits) {
            maxDigits = minDigits;
        }
        if (minDigits < 0 || maxDigits <= 0) {
            throw new IllegalArgumentException();
        }
        return this.append0(new Fraction(fieldType, minDigits, maxDigits));
    }

    public DateTimeFormatterBuilder appendFractionOfSecond(int minDigits, int maxDigits) {
        return this.appendFraction(DateTimeFieldType.secondOfDay(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendFractionOfMinute(int minDigits, int maxDigits) {
        return this.appendFraction(DateTimeFieldType.minuteOfDay(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendFractionOfHour(int minDigits, int maxDigits) {
        return this.appendFraction(DateTimeFieldType.hourOfDay(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendFractionOfDay(int minDigits, int maxDigits) {
        return this.appendFraction(DateTimeFieldType.dayOfYear(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendMillisOfSecond(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.millisOfSecond(), minDigits, 3);
    }

    public DateTimeFormatterBuilder appendMillisOfDay(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.millisOfDay(), minDigits, 8);
    }

    public DateTimeFormatterBuilder appendSecondOfMinute(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.secondOfMinute(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendSecondOfDay(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.secondOfDay(), minDigits, 5);
    }

    public DateTimeFormatterBuilder appendMinuteOfHour(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.minuteOfHour(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendMinuteOfDay(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.minuteOfDay(), minDigits, 4);
    }

    public DateTimeFormatterBuilder appendHourOfDay(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.hourOfDay(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendClockhourOfDay(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfDay(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendHourOfHalfday(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.hourOfHalfday(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendClockhourOfHalfday(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfHalfday(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendDayOfWeek(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.dayOfWeek(), minDigits, 1);
    }

    public DateTimeFormatterBuilder appendDayOfMonth(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.dayOfMonth(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendDayOfYear(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.dayOfYear(), minDigits, 3);
    }

    public DateTimeFormatterBuilder appendWeekOfWeekyear(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.weekOfWeekyear(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendWeekyear(int minDigits, int maxDigits) {
        return this.appendSignedDecimal(DateTimeFieldType.weekyear(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendMonthOfYear(int minDigits) {
        return this.appendDecimal(DateTimeFieldType.monthOfYear(), minDigits, 2);
    }

    public DateTimeFormatterBuilder appendYear(int minDigits, int maxDigits) {
        return this.appendSignedDecimal(DateTimeFieldType.year(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int pivot) {
        return this.append0(new TwoDigitYear(pivot));
    }

    public DateTimeFormatterBuilder appendYearOfEra(int minDigits, int maxDigits) {
        return this.appendDecimal(DateTimeFieldType.yearOfEra(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendYearOfCentury(int minDigits, int maxDigits) {
        return this.appendDecimal(DateTimeFieldType.yearOfCentury(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendCenturyOfEra(int minDigits, int maxDigits) {
        return this.appendSignedDecimal(DateTimeFieldType.centuryOfEra(), minDigits, maxDigits);
    }

    public DateTimeFormatterBuilder appendHalfdayOfDayText() {
        return this.appendText(DateTimeFieldType.halfdayOfDay());
    }

    public DateTimeFormatterBuilder appendDayOfWeekText() {
        return this.appendText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendDayOfWeekShortText() {
        return this.appendShortText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendMonthOfYearText() {
        return this.appendText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendMonthOfYearShortText() {
        return this.appendShortText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendEraText() {
        return this.appendText(DateTimeFieldType.era());
    }

    public DateTimeFormatterBuilder appendTimeZoneName() {
        return this.append0(new TimeZonePrinter(this.iLocale, false), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneShortName() {
        return this.append0(new TimeZonePrinter(this.iLocale, true), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneOffset(String zeroOffsetText, boolean showSeparators, int minFields, int maxFields) {
        return this.append0(new TimeZoneOffsetFormatter(zeroOffsetText, showSeparators, minFields, maxFields));
    }

    public DateTimeFormatterBuilder appendPattern(String pattern) {
        DateTimeFormat.appendPatternTo(this, pattern);
        return this;
    }

    private Object getFormatter() {
        Object f = this.iFormatter;
        if (f == null) {
            if (this.iElementPairs.size() == 2) {
                Object printer = this.iElementPairs.get(0);
                Object parser = this.iElementPairs.get(1);
                if (printer != null) {
                    if (printer == parser || parser == null) {
                        f = printer;
                    }
                } else {
                    f = parser;
                }
            }
            if (f == null) {
                f = new Composite(this.iElementPairs);
            }
            this.iFormatter = f;
        }
        return f;
    }

    private boolean isPrinter(Object f) {
        if (f instanceof DateTimePrinter) {
            if (f instanceof Composite) {
                return ((Composite)f).isPrinter();
            }
            return true;
        }
        return false;
    }

    private boolean isParser(Object f) {
        if (f instanceof DateTimeParser) {
            if (f instanceof Composite) {
                return ((Composite)f).isParser();
            }
            return true;
        }
        return false;
    }

    private boolean isFormatter(Object f) {
        if (f instanceof DateTimeFormatter) {
            if (f instanceof Composite) {
                return ((Composite)f).isPrinter() && ((Composite)f).isParser();
            }
            return true;
        }
        return false;
    }

    static void appendUnknownString(StringBuffer buf, int len) {
        int i = len;
        while (--i >= 0) {
            buf.append('\ufffd');
        }
    }

    static void printUnknownString(Writer out, int len) throws IOException {
        int i = len;
        while (--i >= 0) {
            out.write(65533);
        }
    }

    static class MatchingParser
    extends BaseDateTimeFormatter
    implements DateTimeParser {
        private final BaseDateTimeFormatter[] iParsers;
        private final int iParsedLengthEstimate;

        MatchingParser(BaseDateTimeFormatter[] parsers) {
            this.iParsers = parsers;
            int est = 0;
            int i = parsers.length;
            while (--i >= 0) {
                int len;
                BaseDateTimeFormatter parser = parsers[i];
                if (parser == null || (len = parser.estimateParsedLength()) <= est) continue;
                len = est;
            }
            this.iParsedLengthEstimate = est;
        }

        protected int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        protected int parseInto(BaseDateTimeFormatter.ParseBucket bucket, String text, int position) {
            BaseDateTimeFormatter[] parsers = this.iParsers;
            int length = parsers.length;
            Object originalState = bucket.saveState();
            boolean isOptional = false;
            int bestValidPos = position;
            Object bestValidState = null;
            int bestInvalidPos = position;
            int i = 0;
            while (i < length) {
                BaseDateTimeFormatter parser = parsers[i];
                if (parser == null) {
                    if (bestValidPos <= position) {
                        return position;
                    }
                    isOptional = true;
                    break;
                }
                int parsePos = parser.parseInto(bucket, text, position);
                if (parsePos >= position) {
                    if (parsePos > bestValidPos) {
                        if (parsePos >= text.length() || i + 1 >= length || parsers[i + 1] == null) {
                            return parsePos;
                        }
                        bestValidPos = parsePos;
                        bestValidState = bucket.saveState();
                    }
                } else if (parsePos < 0 && (parsePos ^= 0xFFFFFFFF) > bestInvalidPos) {
                    bestInvalidPos = parsePos;
                }
                bucket.restoreState(originalState);
                ++i;
            }
            if (bestValidPos > position || bestValidPos == position && isOptional) {
                if (bestValidState != null) {
                    bucket.restoreState(bestValidState);
                }
                return bestValidPos;
            }
            return ~bestInvalidPos;
        }
    }

    static class Composite
    extends BaseDateTimeFormatter
    implements DateTimeFormatter {
        private final BaseDateTimeFormatter[] iPrinters;
        private final BaseDateTimeFormatter[] iParsers;
        private final int iPrintedLengthEstimate;
        private final int iParsedLengthEstimate;

        Composite(List elementPairs) {
            int i;
            int size;
            ArrayList printerList = new ArrayList();
            ArrayList parserList = new ArrayList();
            this.decompose(elementPairs, printerList, parserList);
            if (printerList.size() <= 0) {
                this.iPrinters = null;
                this.iPrintedLengthEstimate = 0;
            } else {
                size = printerList.size();
                this.iPrinters = new BaseDateTimeFormatter[size];
                int printEst = 0;
                i = 0;
                while (i < size) {
                    BaseDateTimeFormatter printer = (BaseDateTimeFormatter)printerList.get(i);
                    printEst += printer.estimatePrintedLength();
                    this.iPrinters[i] = printer;
                    ++i;
                }
                this.iPrintedLengthEstimate = printEst;
            }
            if (parserList.size() <= 0) {
                this.iParsers = null;
                this.iParsedLengthEstimate = 0;
            } else {
                size = parserList.size();
                this.iParsers = new BaseDateTimeFormatter[size];
                int parseEst = 0;
                i = 0;
                while (i < size) {
                    BaseDateTimeFormatter parser = (BaseDateTimeFormatter)parserList.get(i);
                    parseEst += parser.estimateParsedLength();
                    this.iParsers[i] = parser;
                    ++i;
                }
                this.iParsedLengthEstimate = parseEst;
            }
        }

        private Composite(Composite base, BaseDateTimeFormatter[] printers) {
            this.iPrinters = printers;
            this.iParsers = base.iParsers;
            this.iPrintedLengthEstimate = base.iPrintedLengthEstimate;
            this.iParsedLengthEstimate = base.iParsedLengthEstimate;
        }

        protected int estimatePrintedLength() {
            return this.iPrintedLengthEstimate;
        }

        protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            BaseDateTimeFormatter[] elements = this.iPrinters;
            if (elements == null) {
                throw new UnsupportedOperationException();
            }
            int len = elements.length;
            int i = 0;
            while (i < len) {
                elements[i].printTo(buf, instantLocal, chronoLocal, instant, chrono);
                ++i;
            }
        }

        protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
            BaseDateTimeFormatter[] elements = this.iPrinters;
            if (elements == null) {
                throw new UnsupportedOperationException();
            }
            int len = elements.length;
            int i = 0;
            while (i < len) {
                elements[i].printTo(out, instantLocal, chronoLocal, instant, chrono);
                ++i;
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial) {
            BaseDateTimeFormatter[] elements = this.iPrinters;
            if (elements == null) {
                throw new UnsupportedOperationException();
            }
            int len = elements.length;
            int i = 0;
            while (i < len) {
                elements[i].printTo(buf, partial);
                ++i;
            }
        }

        public void printTo(Writer out, ReadablePartial partial) throws IOException {
            BaseDateTimeFormatter[] elements = this.iPrinters;
            if (elements == null) {
                throw new UnsupportedOperationException();
            }
            int len = elements.length;
            int i = 0;
            while (i < len) {
                elements[i].printTo(out, partial);
                ++i;
            }
        }

        protected int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        protected int parseInto(BaseDateTimeFormatter.ParseBucket bucket, String text, int position) {
            BaseDateTimeFormatter[] elements = this.iParsers;
            if (elements == null) {
                throw new UnsupportedOperationException();
            }
            int len = elements.length;
            int i = 0;
            while (i < len && position >= 0) {
                position = elements[i].parseInto(bucket, text, position);
                ++i;
            }
            return position;
        }

        boolean isPrinter() {
            return this.iPrinters != null;
        }

        boolean isParser() {
            return this.iParsers != null;
        }

        private void decompose(List elementPairs, List printerList, List parserList) {
            int size = elementPairs.size();
            int i = 0;
            while (i < size) {
                Object element = elementPairs.get(i);
                if (element != null && element instanceof DateTimePrinter) {
                    if (element instanceof Composite) {
                        this.addArrayToList(printerList, ((Composite)element).iPrinters);
                    } else {
                        printerList.add(element);
                    }
                }
                if ((element = elementPairs.get(i + 1)) != null && element instanceof DateTimeParser) {
                    if (element instanceof Composite) {
                        this.addArrayToList(parserList, ((Composite)element).iParsers);
                    } else {
                        parserList.add(element);
                    }
                }
                i += 2;
            }
        }

        private void addArrayToList(List list, Object[] array) {
            if (array != null) {
                int i = 0;
                while (i < array.length) {
                    list.add(array[i]);
                    ++i;
                }
            }
        }
    }

    static class TimeZonePrinter
    extends BaseDateTimeFormatter
    implements DateTimePrinter {
        private final Locale iLocale;
        private final boolean iShortFormat;

        TimeZonePrinter(Locale locale, boolean shortFormat) {
            this.iLocale = locale;
            this.iShortFormat = shortFormat;
        }

        protected int estimatePrintedLength() {
            return this.iShortFormat ? 4 : 20;
        }

        protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            buf.append(this.print(instantLocal, chronoLocal, instant, chrono));
        }

        protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
            out.write(this.print(instantLocal, chronoLocal, instant, chrono));
        }

        protected String print(long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            DateTimeZone zone = chrono.getZone();
            if (this.iShortFormat) {
                return zone.getShortName(instant, this.iLocale);
            }
            return zone.getName(instant, this.iLocale);
        }

        public void printTo(StringBuffer buf, ReadablePartial partial) {
        }

        public void printTo(Writer out, ReadablePartial partial) throws IOException {
        }
    }

    static class TimeZoneOffsetFormatter
    extends BaseDateTimeFormatter
    implements DateTimeFormatter {
        private final String iZeroOffsetText;
        private final boolean iShowSeparators;
        private final int iMinFields;
        private final int iMaxFields;

        TimeZoneOffsetFormatter(String zeroOffsetText, boolean showSeparators, int minFields, int maxFields) {
            this.iZeroOffsetText = zeroOffsetText;
            this.iShowSeparators = showSeparators;
            if (minFields <= 0 || maxFields < minFields) {
                throw new IllegalArgumentException();
            }
            if (minFields > 4) {
                minFields = 4;
                maxFields = 4;
            }
            this.iMinFields = minFields;
            this.iMaxFields = maxFields;
        }

        protected int estimatePrintedLength() {
            int est = 1 + this.iMinFields << 1;
            if (this.iShowSeparators) {
                est += this.iMinFields - 1;
            }
            if (this.iZeroOffsetText != null && this.iZeroOffsetText.length() > est) {
                est = this.iZeroOffsetText.length();
            }
            return est;
        }

        protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            int offset = (int)(instantLocal - instant);
            if (offset == 0 && this.iZeroOffsetText != null) {
                buf.append(this.iZeroOffsetText);
                return;
            }
            if (offset >= 0) {
                buf.append('+');
            } else {
                buf.append('-');
                offset = -offset;
            }
            int hours = offset / 3600000;
            FormatUtils.appendPaddedInteger(buf, hours, 2);
            if (this.iMaxFields == 1) {
                return;
            }
            if ((offset -= hours * 3600000) == 0 && this.iMinFields <= 1) {
                return;
            }
            int minutes = offset / 60000;
            if (this.iShowSeparators) {
                buf.append(':');
            }
            FormatUtils.appendPaddedInteger(buf, minutes, 2);
            if (this.iMaxFields == 2) {
                return;
            }
            if ((offset -= minutes * 60000) == 0 && this.iMinFields <= 2) {
                return;
            }
            int seconds = offset / 1000;
            if (this.iShowSeparators) {
                buf.append(':');
            }
            FormatUtils.appendPaddedInteger(buf, seconds, 2);
            if (this.iMaxFields == 3) {
                return;
            }
            if ((offset -= seconds * 1000) == 0 && this.iMinFields <= 3) {
                return;
            }
            if (this.iShowSeparators) {
                buf.append('.');
            }
            FormatUtils.appendPaddedInteger(buf, offset, 3);
        }

        protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
            int offset = (int)(instantLocal - instant);
            if (offset == 0 && this.iZeroOffsetText != null) {
                out.write(this.iZeroOffsetText);
                return;
            }
            if (offset >= 0) {
                out.write(43);
            } else {
                out.write(45);
                offset = -offset;
            }
            int hours = offset / 3600000;
            FormatUtils.writePaddedInteger(out, hours, 2);
            if (this.iMaxFields == 1) {
                return;
            }
            if ((offset -= hours * 3600000) == 0 && this.iMinFields == 1) {
                return;
            }
            int minutes = offset / 60000;
            if (this.iShowSeparators) {
                out.write(58);
            }
            FormatUtils.writePaddedInteger(out, minutes, 2);
            if (this.iMaxFields == 2) {
                return;
            }
            if ((offset -= minutes * 60000) == 0 && this.iMinFields == 2) {
                return;
            }
            int seconds = offset / 1000;
            if (this.iShowSeparators) {
                out.write(58);
            }
            FormatUtils.writePaddedInteger(out, seconds, 2);
            if (this.iMaxFields == 3) {
                return;
            }
            if ((offset -= seconds * 1000) == 0 && this.iMinFields == 3) {
                return;
            }
            if (this.iShowSeparators) {
                out.write(46);
            }
            FormatUtils.writePaddedInteger(out, offset, 3);
        }

        public void printTo(StringBuffer buf, ReadablePartial partial) {
        }

        public void printTo(Writer out, ReadablePartial partial) throws IOException {
        }

        protected int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        protected int parseInto(BaseDateTimeFormatter.ParseBucket bucket, String text, int position) {
            int offset;
            boolean negative;
            block24: {
                int count;
                boolean expectSeparators;
                block28: {
                    int limit;
                    block27: {
                        block26: {
                            char c;
                            block25: {
                                limit = text.length() - position;
                                if (this.iZeroOffsetText != null) {
                                    if (this.iZeroOffsetText.length() == 0) {
                                        char c2;
                                        if (limit <= 0 || (c2 = text.charAt(position)) != '-' && c2 != '+') {
                                            bucket.setOffset(0);
                                            return position;
                                        }
                                    } else if (text.regionMatches(true, position, this.iZeroOffsetText, 0, this.iZeroOffsetText.length())) {
                                        bucket.setOffset(0);
                                        return position + this.iZeroOffsetText.length();
                                    }
                                }
                                if (limit <= 1) {
                                    return ~position;
                                }
                                c = text.charAt(position);
                                if (c == '-') {
                                    negative = true;
                                } else if (c == '+') {
                                    negative = false;
                                } else {
                                    return ~position;
                                }
                                --limit;
                                if (this.digitCount(text, ++position, 2) < 2) {
                                    return ~position;
                                }
                                int hours = FormatUtils.parseTwoDigits(text, position);
                                if (hours > 23) {
                                    return ~position;
                                }
                                offset = hours * 3600000;
                                position += 2;
                                if ((limit -= 2) <= 0) break block24;
                                c = text.charAt(position);
                                if (c != ':') break block25;
                                expectSeparators = true;
                                --limit;
                                ++position;
                                break block26;
                            }
                            if (c < '0' || c > '9') break block24;
                            expectSeparators = false;
                        }
                        count = this.digitCount(text, position, 2);
                        if (count == 0 && !expectSeparators) break block24;
                        if (count < 2) {
                            return ~position;
                        }
                        int minutes = FormatUtils.parseTwoDigits(text, position);
                        if (minutes > 59) {
                            return ~position;
                        }
                        offset += minutes * 60000;
                        position += 2;
                        if ((limit -= 2) <= 0) break block24;
                        if (!expectSeparators) break block27;
                        if (text.charAt(position) != ':') break block24;
                        --limit;
                        ++position;
                    }
                    if ((count = this.digitCount(text, position, 2)) == 0 && !expectSeparators) break block24;
                    if (count < 2) {
                        return ~position;
                    }
                    int seconds = FormatUtils.parseTwoDigits(text, position);
                    if (seconds > 59) {
                        return ~position;
                    }
                    offset += seconds * 1000;
                    position += 2;
                    if ((limit -= 2) <= 0) break block24;
                    if (!expectSeparators) break block28;
                    if (text.charAt(position) != '.' && text.charAt(position) != ',') break block24;
                    --limit;
                    ++position;
                }
                if ((count = this.digitCount(text, position, 3)) != 0 || expectSeparators) {
                    if (count < 1) {
                        return ~position;
                    }
                    offset += (text.charAt(position++) - 48) * 100;
                    if (count > 1) {
                        offset += (text.charAt(position++) - 48) * 10;
                        if (count > 2) {
                            offset += text.charAt(position++) - 48;
                        }
                    }
                }
            }
            bucket.setOffset(negative ? -offset : offset);
            return position;
        }

        private int digitCount(String text, int position, int amount) {
            int limit = Math.min(text.length() - position, amount);
            amount = 0;
            while (limit > 0) {
                char c = text.charAt(position + amount);
                if (c < '0' || c > '9') break;
                ++amount;
                --limit;
            }
            return amount;
        }
    }

    static class Fraction
    extends BaseDateTimeFormatter
    implements DateTimeFormatter {
        private final DateTimeFieldType iFieldType;
        protected int iMinDigits;
        protected int iMaxDigits;

        protected Fraction(DateTimeFieldType fieldType, int minDigits, int maxDigits) {
            this.iFieldType = fieldType;
            if (maxDigits > 18) {
                maxDigits = 18;
            }
            this.iMinDigits = minDigits;
            this.iMaxDigits = maxDigits;
        }

        protected int estimatePrintedLength() {
            return this.iMaxDigits;
        }

        protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            try {
                this.printTo(buf, null, instantLocal, chronoLocal);
            }
            catch (IOException e) {
                // empty catch block
            }
        }

        protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
            this.printTo(null, out, instantLocal, chronoLocal);
        }

        public void printTo(StringBuffer buf, ReadablePartial partial) {
            if (partial.isSupported(this.iFieldType)) {
                long millis = partial.getChronology().set(partial, 0L);
                try {
                    this.printTo(buf, null, millis, partial.getChronology());
                }
                catch (IOException e) {}
            } else {
                buf.append('\ufffd');
            }
        }

        public void printTo(Writer out, ReadablePartial partial) throws IOException {
            if (partial.isSupported(this.iFieldType)) {
                long millis = partial.getChronology().set(partial, 0L);
                this.printTo(null, out, millis, partial.getChronology());
            } else {
                out.write(65533);
            }
        }

        /*
         * Unable to fully structure code
         */
        protected void printTo(StringBuffer buf, Writer out, long instantLocal, Chronology chronoLocal) throws IOException {
            block18: {
                block19: {
                    field = this.iFieldType.getField(chronoLocal);
                    minDigits = this.iMinDigits;
                    try {
                        fraction = field.remainder(instantLocal);
                    }
                    catch (RuntimeException e) {
                        if (buf != null) {
                            DateTimeFormatterBuilder.appendUnknownString(buf, minDigits);
                        } else {
                            DateTimeFormatterBuilder.printUnknownString(out, minDigits);
                        }
                        return;
                    }
                    if (fraction != 0L) break block18;
                    if (buf == null) ** GOTO lbl20
                    while (--minDigits >= 0) {
                        buf.append('0');
                    }
                    break block19;
lbl-1000:
                    // 1 sources

                    {
                        out.write(48);
lbl20:
                        // 2 sources

                        ** while (--minDigits >= 0)
                    }
                }
                return;
            }
            fractionData = this.getFractionData(fraction, field);
            scaled = fractionData[0];
            maxDigits = (int)fractionData[1];
            str = (scaled & 0x7FFFFFFFL) == scaled ? Integer.toString((int)scaled) : Long.toString(scaled);
            length = str.length();
            digits = maxDigits;
            while (length < digits) {
                if (buf != null) {
                    buf.append('0');
                } else {
                    out.write(48);
                }
                --minDigits;
                --digits;
            }
            if (minDigits < digits) {
                while (minDigits < digits) {
                    if (length <= 1 || str.charAt(length - 1) != '0') break;
                    --digits;
                    --length;
                }
                if (length < str.length()) {
                    if (buf != null) {
                        i = 0;
                        while (i < length) {
                            buf.append(str.charAt(i));
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < length) {
                            out.write(str.charAt(i));
                            ++i;
                        }
                    }
                    return;
                }
            }
            if (buf != null) {
                buf.append(str);
            } else {
                out.write(str);
            }
        }

        private long[] getFractionData(long fraction, DateTimeField field) {
            long scalar;
            long rangeMillis = field.getDurationField().getUnitMillis();
            int maxDigits = this.iMaxDigits;
            while (true) {
                switch (maxDigits) {
                    default: {
                        scalar = 1L;
                        break;
                    }
                    case 1: {
                        scalar = 10L;
                        break;
                    }
                    case 2: {
                        scalar = 100L;
                        break;
                    }
                    case 3: {
                        scalar = 1000L;
                        break;
                    }
                    case 4: {
                        scalar = 10000L;
                        break;
                    }
                    case 5: {
                        scalar = 100000L;
                        break;
                    }
                    case 6: {
                        scalar = 1000000L;
                        break;
                    }
                    case 7: {
                        scalar = 10000000L;
                        break;
                    }
                    case 8: {
                        scalar = 100000000L;
                        break;
                    }
                    case 9: {
                        scalar = 1000000000L;
                        break;
                    }
                    case 10: {
                        scalar = 10000000000L;
                        break;
                    }
                    case 11: {
                        scalar = 100000000000L;
                        break;
                    }
                    case 12: {
                        scalar = 1000000000000L;
                        break;
                    }
                    case 13: {
                        scalar = 10000000000000L;
                        break;
                    }
                    case 14: {
                        scalar = 100000000000000L;
                        break;
                    }
                    case 15: {
                        scalar = 1000000000000000L;
                        break;
                    }
                    case 16: {
                        scalar = 10000000000000000L;
                        break;
                    }
                    case 17: {
                        scalar = 100000000000000000L;
                        break;
                    }
                    case 18: {
                        scalar = 1000000000000000000L;
                    }
                }
                if (rangeMillis * scalar / scalar == rangeMillis) break;
                --maxDigits;
            }
            return new long[]{fraction * scalar / rangeMillis, maxDigits};
        }

        protected int estimateParsedLength() {
            return this.iMaxDigits;
        }

        protected int parseInto(BaseDateTimeFormatter.ParseBucket bucket, String text, int position) {
            DateTimeField field = this.iFieldType.getField(bucket.getChronology());
            int limit = Math.min(this.iMaxDigits, text.length() - position);
            long value = 0L;
            long n = field.getDurationField().getUnitMillis() * 10L;
            int length = 0;
            while (length < limit) {
                char c = text.charAt(position + length);
                if (c < '0' || c > '9') break;
                ++length;
                long nn = n / 10L;
                value += (long)(c - 48) * nn;
                n = nn;
            }
            value /= 10L;
            if (length == 0) {
                return ~position;
            }
            if (value > Integer.MAX_VALUE) {
                return ~position;
            }
            PreciseDateTimeField parseField = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), MillisDurationField.INSTANCE, field.getDurationField());
            bucket.saveField(parseField, (int)value);
            return position + length;
        }
    }

    static class TextField
    extends BaseDateTimeFormatter
    implements DateTimeFormatter {
        private final DateTimeFieldType iFieldType;
        private final Locale iLocale;
        private final boolean iShort;

        TextField(DateTimeFieldType fieldType, Locale locale, boolean isShort) {
            this.iFieldType = fieldType;
            this.iLocale = locale;
            this.iShort = isShort;
        }

        protected int estimatePrintedLength() {
            return this.iShort ? 6 : 20;
        }

        protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            try {
                buf.append(this.print(instantLocal, chronoLocal, instant, chrono));
            }
            catch (RuntimeException e) {
                buf.append('\ufffd');
            }
        }

        protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
            try {
                out.write(this.print(instantLocal, chronoLocal, instant, chrono));
            }
            catch (RuntimeException e) {
                out.write(65533);
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial) {
            try {
                buf.append(this.print(partial));
            }
            catch (RuntimeException e) {
                buf.append('\ufffd');
            }
        }

        public void printTo(Writer out, ReadablePartial partial) throws IOException {
            try {
                out.write(this.print(partial));
            }
            catch (RuntimeException e) {
                out.write(65533);
            }
        }

        protected String print(long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            DateTimeField field = this.iFieldType.getField(chrono);
            if (this.iShort) {
                return field.getAsShortText(instantLocal, this.iLocale);
            }
            return field.getAsText(instantLocal, this.iLocale);
        }

        public String print(ReadablePartial partial) {
            if (partial.isSupported(this.iFieldType)) {
                DateTimeField field = this.iFieldType.getField(partial.getChronology());
                if (this.iShort) {
                    return field.getAsShortText(partial, this.iLocale);
                }
                return field.getAsText(partial, this.iLocale);
            }
            return "\ufffd";
        }

        protected int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        protected int parseInto(BaseDateTimeFormatter.ParseBucket bucket, String text, int position) {
            int limit = text.length();
            int i = position;
            while (i < limit) {
                char c = text.charAt(i);
                if (c < 'A' || !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && !Character.isLetter(c)) break;
                ++i;
            }
            if (i == position) {
                return ~position;
            }
            bucket.saveField(this.iFieldType, text.substring(position, i), this.iLocale);
            return i;
        }
    }

    static class TwoDigitYear
    extends BaseDateTimeFormatter
    implements DateTimeFormatter {
        private final int iPivot;

        TwoDigitYear(int pivot) {
            this.iPivot = pivot;
        }

        protected int estimateParsedLength() {
            return 2;
        }

        protected int parseInto(BaseDateTimeFormatter.ParseBucket bucket, String text, int position) {
            int limit = Math.min(2, text.length() - position);
            if (limit < 2) {
                return ~position;
            }
            char c = text.charAt(position);
            if (c < '0' || c > '9') {
                return ~position;
            }
            int year = c - 48;
            c = text.charAt(position + 1);
            if (c < '0' || c > '9') {
                return ~position;
            }
            year = (year << 3) + (year << 1) + c - 48;
            int low = this.iPivot - 50;
            int t = low >= 0 ? low % 100 : 99 + (low + 1) % 100;
            bucket.saveField(DateTimeFieldType.year(), year += low + (year < t ? 100 : 0) - t);
            return position + 2;
        }

        protected int estimatePrintedLength() {
            return 2;
        }

        protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            int year = this.getTwoDigitYear(instantLocal, chronoLocal);
            if (year < 0) {
                buf.append('\ufffd');
                buf.append('\ufffd');
            } else {
                FormatUtils.appendPaddedInteger(buf, year, 2);
            }
        }

        protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
            int year = this.getTwoDigitYear(instantLocal, chronoLocal);
            if (year < 0) {
                out.write(65533);
                out.write(65533);
            } else {
                FormatUtils.writePaddedInteger(out, year, 2);
            }
        }

        private int getTwoDigitYear(long instantLocal, Chronology chronoLocal) {
            try {
                int year = chronoLocal.year().get(instantLocal);
                if (year < 0) {
                    year = -year;
                }
                return year % 100;
            }
            catch (RuntimeException e) {
                return -1;
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial) {
            int year = this.getTwoDigitYear(partial);
            if (year < 0) {
                buf.append('\ufffd');
                buf.append('\ufffd');
            } else {
                FormatUtils.appendPaddedInteger(buf, year, 2);
            }
        }

        public void printTo(Writer out, ReadablePartial partial) throws IOException {
            int year = this.getTwoDigitYear(partial);
            if (year < 0) {
                out.write(65533);
                out.write(65533);
            } else {
                FormatUtils.writePaddedInteger(out, year, 2);
            }
        }

        private int getTwoDigitYear(ReadablePartial partial) {
            if (partial.isSupported(DateTimeFieldType.year())) {
                try {
                    int year = partial.get(DateTimeFieldType.year());
                    if (year < 0) {
                        year = -year;
                    }
                    return year % 100;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    static class PaddedNumber
    extends NumberFormatter {
        protected final int iMinPrintedDigits;

        protected PaddedNumber(DateTimeFieldType fieldType, int maxParsedDigits, boolean signed, int minPrintedDigits) {
            super(fieldType, maxParsedDigits, signed);
            this.iMinPrintedDigits = minPrintedDigits;
        }

        protected int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            try {
                DateTimeField field = this.iFieldType.getField(chronoLocal);
                FormatUtils.appendPaddedInteger(buf, field.get(instantLocal), this.iMinPrintedDigits);
            }
            catch (RuntimeException e) {
                DateTimeFormatterBuilder.appendUnknownString(buf, this.iMinPrintedDigits);
            }
        }

        protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
            try {
                DateTimeField field = this.iFieldType.getField(chronoLocal);
                FormatUtils.writePaddedInteger(out, field.get(instantLocal), this.iMinPrintedDigits);
            }
            catch (RuntimeException e) {
                DateTimeFormatterBuilder.printUnknownString(out, this.iMinPrintedDigits);
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial) {
            if (partial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendPaddedInteger(buf, partial.get(this.iFieldType), this.iMinPrintedDigits);
                }
                catch (RuntimeException e) {
                    DateTimeFormatterBuilder.appendUnknownString(buf, this.iMinPrintedDigits);
                }
            } else {
                DateTimeFormatterBuilder.appendUnknownString(buf, this.iMinPrintedDigits);
            }
        }

        public void printTo(Writer out, ReadablePartial partial) throws IOException {
            if (partial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.writePaddedInteger(out, partial.get(this.iFieldType), this.iMinPrintedDigits);
                }
                catch (RuntimeException e) {
                    DateTimeFormatterBuilder.printUnknownString(out, this.iMinPrintedDigits);
                }
            } else {
                DateTimeFormatterBuilder.printUnknownString(out, this.iMinPrintedDigits);
            }
        }
    }

    static class UnpaddedNumber
    extends NumberFormatter {
        protected UnpaddedNumber(DateTimeFieldType fieldType, int maxParsedDigits, boolean signed) {
            super(fieldType, maxParsedDigits, signed);
        }

        protected int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            try {
                DateTimeField field = this.iFieldType.getField(chronoLocal);
                FormatUtils.appendUnpaddedInteger(buf, field.get(instantLocal));
            }
            catch (RuntimeException e) {
                buf.append('\ufffd');
            }
        }

        protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
            try {
                DateTimeField field = this.iFieldType.getField(chronoLocal);
                FormatUtils.writeUnpaddedInteger(out, field.get(instantLocal));
            }
            catch (RuntimeException e) {
                out.write(65533);
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial) {
            if (partial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendUnpaddedInteger(buf, partial.get(this.iFieldType));
                }
                catch (RuntimeException e) {
                    buf.append('\ufffd');
                }
            } else {
                buf.append('\ufffd');
            }
        }

        public void printTo(Writer out, ReadablePartial partial) throws IOException {
            if (partial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.writeUnpaddedInteger(out, partial.get(this.iFieldType));
                }
                catch (RuntimeException e) {
                    out.write(65533);
                }
            } else {
                out.write(65533);
            }
        }
    }

    static abstract class NumberFormatter
    extends BaseDateTimeFormatter
    implements DateTimeFormatter {
        protected final DateTimeFieldType iFieldType;
        protected final int iMaxParsedDigits;
        protected final boolean iSigned;

        NumberFormatter(DateTimeFieldType fieldType, int maxParsedDigits, boolean signed) {
            this.iFieldType = fieldType;
            this.iMaxParsedDigits = maxParsedDigits;
            this.iSigned = signed;
        }

        protected int estimateParsedLength() {
            return this.iMaxParsedDigits;
        }

        protected int parseInto(BaseDateTimeFormatter.ParseBucket bucket, String text, int position) {
            int value;
            int limit = Math.min(this.iMaxParsedDigits, text.length() - position);
            boolean negative = false;
            int length = 0;
            while (length < limit) {
                char c = text.charAt(position + length);
                if (length == 0 && (c == '-' || c == '+') && this.iSigned) {
                    boolean bl = negative = c == '-';
                    if (negative) {
                        ++length;
                    } else {
                        ++position;
                    }
                    limit = Math.min(limit + 1, text.length() - position);
                    continue;
                }
                if (c < '0' || c > '9') break;
                ++length;
            }
            if (length == 0) {
                return ~position;
            }
            if (length >= 9) {
                value = Integer.parseInt(text.substring(position, position += length));
            } else {
                int i = position;
                if (negative) {
                    // empty if block
                }
                int n = ++i;
                ++i;
                value = text.charAt(n) - 48;
                position += length;
                while (i < position) {
                    value = (value << 3) + (value << 1) + text.charAt(i++) - 48;
                }
                if (negative) {
                    value = -value;
                }
            }
            bucket.saveField(this.iFieldType, value);
            return position;
        }
    }

    static class StringLiteral
    extends BaseDateTimeFormatter
    implements DateTimeFormatter {
        private final String iValue;

        StringLiteral(String value) {
            this.iValue = value;
        }

        public int estimatePrintedLength() {
            return this.iValue.length();
        }

        protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            buf.append(this.iValue);
        }

        protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
            out.write(this.iValue);
        }

        public void printTo(StringBuffer buf, ReadablePartial partial) {
            buf.append(this.iValue);
        }

        public void printTo(Writer out, ReadablePartial partial) throws IOException {
            out.write(this.iValue);
        }

        protected String print(long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            return this.iValue;
        }

        public String print(ReadablePartial partial) {
            return this.iValue;
        }

        public int estimateParsedLength() {
            return this.iValue.length();
        }

        public int parseInto(BaseDateTimeFormatter.ParseBucket bucket, String text, int position) {
            if (text.regionMatches(true, position, this.iValue, 0, this.iValue.length())) {
                return position + this.iValue.length();
            }
            return ~position;
        }
    }

    static class CharacterLiteral
    extends BaseDateTimeFormatter
    implements DateTimeFormatter {
        private final char iValue;

        CharacterLiteral(char value) {
            this.iValue = value;
        }

        public int estimatePrintedLength() {
            return 1;
        }

        protected void printTo(StringBuffer buf, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            buf.append(this.iValue);
        }

        protected void printTo(Writer out, long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) throws IOException {
            out.write(this.iValue);
        }

        public void printTo(StringBuffer buf, ReadablePartial partial) {
            buf.append(this.iValue);
        }

        public void printTo(Writer out, ReadablePartial partial) throws IOException {
            out.write(this.iValue);
        }

        protected String print(long instantLocal, Chronology chronoLocal, long instant, Chronology chrono) {
            return String.valueOf(this.iValue);
        }

        public String print(ReadablePartial partial) {
            return String.valueOf(this.iValue);
        }

        protected int estimateParsedLength() {
            return 1;
        }

        protected int parseInto(BaseDateTimeFormatter.ParseBucket bucket, String text, int position) {
            char b;
            if (position >= text.length()) {
                return ~position;
            }
            char a = text.charAt(position);
            if (a != (b = this.iValue) && (a = Character.toUpperCase(a)) != (b = Character.toUpperCase(b)) && (a = Character.toLowerCase(a)) != (b = Character.toLowerCase(b))) {
                return ~position;
            }
            return position + 1;
        }
    }
}

