/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.field;

import java.util.Locale;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.field.FieldUtils;

public abstract class BaseDateTimeField
extends DateTimeField {
    private final DateTimeFieldType iType;

    protected BaseDateTimeField(DateTimeFieldType type) {
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        this.iType = type;
    }

    public final DateTimeFieldType getType() {
        return this.iType;
    }

    public final String getName() {
        return this.iType.getName();
    }

    public final boolean isSupported() {
        return true;
    }

    public abstract int get(long var1);

    public String getAsText(long instant, Locale locale) {
        return this.getAsText(this.get(instant), locale);
    }

    public final String getAsText(long instant) {
        return this.getAsText(instant, null);
    }

    public String getAsText(ReadablePartial partial, int fieldValue, Locale locale) {
        return this.getAsText(fieldValue, locale);
    }

    public final String getAsText(ReadablePartial partial, Locale locale) {
        return this.getAsText(partial, partial.get(this.getType()), locale);
    }

    protected String getAsText(int fieldValue, Locale locale) {
        return Integer.toString(fieldValue);
    }

    public String getAsShortText(long instant, Locale locale) {
        return this.getAsShortText(this.get(instant), locale);
    }

    public final String getAsShortText(long instant) {
        return this.getAsShortText(instant, null);
    }

    public String getAsShortText(ReadablePartial partial, int fieldValue, Locale locale) {
        return this.getAsShortText(fieldValue, locale);
    }

    public final String getAsShortText(ReadablePartial partial, Locale locale) {
        return this.getAsShortText(partial, partial.get(this.getType()), locale);
    }

    protected String getAsShortText(int fieldValue, Locale locale) {
        return this.getAsText(fieldValue, locale);
    }

    public long add(long instant, int value) {
        return this.getDurationField().add(instant, value);
    }

    public long add(long instant, long value) {
        return this.getDurationField().add(instant, value);
    }

    public int[] add(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        long proposed;
        if (valueToAdd == 0) {
            return values;
        }
        DateTimeField nextField = null;
        while (valueToAdd > 0) {
            proposed = values[fieldIndex] + valueToAdd;
            int max = this.getMaximumValue(instant, values);
            if (proposed <= (long)max) {
                values[fieldIndex] = (int)proposed;
                break;
            }
            if (nextField == null) {
                if (fieldIndex == 0) {
                    throw new IllegalArgumentException("Maximum value exceeded for add");
                }
                nextField = instant.getField(fieldIndex - 1);
                if (this.getRangeDurationField() != nextField.getDurationField()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            valueToAdd -= max + 1 - values[fieldIndex];
            values = nextField.add(instant, fieldIndex - 1, values, 1);
            values[fieldIndex] = this.getMinimumValue(instant, values);
        }
        while (valueToAdd < 0) {
            proposed = values[fieldIndex] + valueToAdd;
            int min = this.getMinimumValue(instant, values);
            if (proposed >= (long)min) {
                values[fieldIndex] = (int)proposed;
                break;
            }
            if (nextField == null) {
                if (fieldIndex == 0) {
                    throw new IllegalArgumentException("Maximum value exceeded for add");
                }
                nextField = instant.getField(fieldIndex - 1);
                if (this.getRangeDurationField() != nextField.getDurationField()) {
                    throw new IllegalArgumentException("Fields invalid for add");
                }
            }
            valueToAdd -= min - 1 - values[fieldIndex];
            values = nextField.add(instant, fieldIndex - 1, values, -1);
            values[fieldIndex] = this.getMaximumValue(instant, values);
        }
        return this.set(instant, fieldIndex, values, values[fieldIndex]);
    }

    public long addWrapField(long instant, int value) {
        int current = this.get(instant);
        int wrapped = FieldUtils.getWrappedValue(current, value, this.getMinimumValue(instant), this.getMaximumValue(instant));
        return this.set(instant, wrapped);
    }

    public int[] addWrapField(ReadablePartial instant, int fieldIndex, int[] values, int valueToAdd) {
        int current = values[fieldIndex];
        int wrapped = FieldUtils.getWrappedValue(current, valueToAdd, this.getMinimumValue(instant), this.getMaximumValue(instant));
        return this.set(instant, fieldIndex, values, wrapped);
    }

    public int getDifference(long minuendInstant, long subtrahendInstant) {
        return this.getDurationField().getDifference(minuendInstant, subtrahendInstant);
    }

    public long getDifferenceAsLong(long minuendInstant, long subtrahendInstant) {
        return this.getDurationField().getDifferenceAsLong(minuendInstant, subtrahendInstant);
    }

    public abstract long set(long var1, int var3);

    public int[] set(ReadablePartial partial, int fieldIndex, int[] values, int newValue) {
        FieldUtils.verifyValueBounds(this, newValue, this.getMinimumValue(partial, values), this.getMaximumValue(partial, values));
        values[fieldIndex] = newValue;
        int i = fieldIndex + 1;
        while (i < partial.size()) {
            DateTimeField field = partial.getField(i);
            if (values[i] > field.getMaximumValue(partial, values)) {
                values[i] = field.getMaximumValue(partial, values);
            }
            if (values[i] < field.getMinimumValue(partial, values)) {
                values[i] = field.getMinimumValue(partial, values);
            }
            ++i;
        }
        return values;
    }

    public long set(long instant, String text, Locale locale) {
        int value = this.convertText(text, locale);
        return this.set(instant, value);
    }

    public final long set(long instant, String text) {
        return this.set(instant, text, null);
    }

    public int[] set(ReadablePartial instant, int fieldIndex, int[] values, String text, Locale locale) {
        int value = this.convertText(text, locale);
        return this.set(instant, fieldIndex, values, value);
    }

    protected int convertText(String text, Locale locale) {
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid " + this.getName() + " text: " + text);
        }
    }

    public abstract DurationField getDurationField();

    public abstract DurationField getRangeDurationField();

    public boolean isLeap(long instant) {
        return false;
    }

    public int getLeapAmount(long instant) {
        return 0;
    }

    public DurationField getLeapDurationField() {
        return null;
    }

    public abstract int getMinimumValue();

    public int getMinimumValue(long instant) {
        return this.getMinimumValue();
    }

    public int getMinimumValue(ReadablePartial instant) {
        return this.getMinimumValue();
    }

    public int getMinimumValue(ReadablePartial instant, int[] values) {
        return this.getMinimumValue(instant);
    }

    public abstract int getMaximumValue();

    public int getMaximumValue(long instant) {
        return this.getMaximumValue();
    }

    public int getMaximumValue(ReadablePartial instant) {
        return this.getMaximumValue();
    }

    public int getMaximumValue(ReadablePartial instant, int[] values) {
        return this.getMaximumValue(instant);
    }

    public int getMaximumTextLength(Locale locale) {
        int max = this.getMaximumValue();
        if (max >= 0) {
            if (max < 10) {
                return 1;
            }
            if (max < 100) {
                return 2;
            }
            if (max < 1000) {
                return 3;
            }
        }
        return Integer.toString(max).length();
    }

    public int getMaximumShortTextLength(Locale locale) {
        return this.getMaximumTextLength(locale);
    }

    public abstract long roundFloor(long var1);

    public long roundCeiling(long instant) {
        long newInstant = this.roundFloor(instant);
        if (newInstant != instant) {
            instant = this.add(newInstant, 1);
        }
        return instant;
    }

    public long roundHalfFloor(long instant) {
        long ceiling;
        long diffToCeiling;
        long floor = this.roundFloor(instant);
        long diffFromFloor = instant - floor;
        if (diffFromFloor <= (diffToCeiling = (ceiling = this.roundCeiling(instant)) - instant)) {
            return floor;
        }
        return ceiling;
    }

    public long roundHalfCeiling(long instant) {
        long diffFromFloor;
        long floor = this.roundFloor(instant);
        long ceiling = this.roundCeiling(instant);
        long diffToCeiling = ceiling - instant;
        if (diffToCeiling <= (diffFromFloor = instant - floor)) {
            return ceiling;
        }
        return floor;
    }

    public long roundHalfEven(long instant) {
        long ceiling;
        long diffToCeiling;
        long floor = this.roundFloor(instant);
        long diffFromFloor = instant - floor;
        if (diffFromFloor < (diffToCeiling = (ceiling = this.roundCeiling(instant)) - instant)) {
            return floor;
        }
        if (diffToCeiling < diffFromFloor) {
            return ceiling;
        }
        if ((this.get(ceiling) & 1) == 0) {
            return ceiling;
        }
        return floor;
    }

    public long remainder(long instant) {
        return instant - this.roundFloor(instant);
    }

    public String toString() {
        return "DateTimeField[" + this.getName() + ']';
    }
}

