/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.convert;

import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadWritableInterval;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.convert.AbstractConverter;
import org.joda.time.convert.DurationConverter;
import org.joda.time.convert.InstantConverter;
import org.joda.time.convert.IntervalConverter;
import org.joda.time.convert.PartialConverter;
import org.joda.time.convert.PeriodConverter;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

class StringConverter
extends AbstractConverter
implements InstantConverter,
PartialConverter,
DurationConverter,
PeriodConverter,
IntervalConverter {
    static final StringConverter INSTANCE = new StringConverter();
    static /* synthetic */ Class class$java$lang$String;

    protected StringConverter() {
    }

    public long getInstantMillis(Object object, Chronology chrono) {
        String str = (String)object;
        DateTimeParser p = ISODateTimeFormat.getInstance().dateTimeParser();
        return p.parseMillis(str, chrono);
    }

    public long getDurationMillis(Object object) {
        String original = (String)object;
        String str = original;
        int len = str.length();
        if (len < 4 || str.charAt(0) != 'P' && str.charAt(0) != 'p' || str.charAt(1) != 'T' && str.charAt(1) != 't' || str.charAt(len - 1) != 'S' && str.charAt(len - 1) != 's') {
            throw new IllegalArgumentException("Invalid format: \"" + original + '\"');
        }
        str = str.substring(2, len - 1);
        int dot = -1;
        int i = 0;
        while (i < str.length()) {
            if (!(str.charAt(i) >= '0' && str.charAt(i) <= '9' || i == 0 && str.charAt(0) == '-')) {
                if (i > 0 && str.charAt(i) == '.' && dot == -1) {
                    dot = i;
                } else {
                    throw new IllegalArgumentException("Invalid format: \"" + original + '\"');
                }
            }
            ++i;
        }
        long millis = 0L;
        long seconds = 0L;
        if (dot > 0) {
            seconds = Long.parseLong(str.substring(0, dot));
            if ((str = str.substring(dot + 1)).length() != 3) {
                str = (str + "000").substring(0, 3);
            }
            millis = Integer.parseInt(str);
        } else {
            seconds = Long.parseLong(str);
        }
        if (seconds < 0L) {
            return FieldUtils.safeAdd(FieldUtils.safeMultiply(seconds, 1000L), -millis);
        }
        return FieldUtils.safeAdd(FieldUtils.safeMultiply(seconds, 1000L), millis);
    }

    public void setInto(ReadWritablePeriod period, Object object, Chronology chrono) {
        String str = (String)object;
        PeriodFormatter parser = ISOPeriodFormat.getInstance().standard();
        period.clear();
        int pos = parser.parseInto(period, str, 0);
        if (pos < str.length()) {
            if (pos < 0) {
                parser.parseMutablePeriod(period.getPeriodType(), str);
            }
            throw new IllegalArgumentException("Invalid format: \"" + str + '\"');
        }
    }

    public void setInto(ReadWritableInterval writableInterval, Object object, Chronology chrono) {
        String str = (String)object;
        int separator = str.indexOf(47);
        if (separator < 0) {
            throw new IllegalArgumentException("Format requires a '/' separator: " + str);
        }
        String leftStr = str.substring(0, separator);
        if (leftStr.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + str);
        }
        String rightStr = str.substring(separator + 1);
        if (rightStr.length() <= 0) {
            throw new IllegalArgumentException("Format invalid: " + str);
        }
        DateTimeParser dateTimeParser = ISODateTimeFormat.getInstance().dateTimeParser();
        PeriodFormatter periodParser = ISOPeriodFormat.getInstance().standard();
        long startInstant = 0L;
        long endInstant = 0L;
        Period period = null;
        Chronology parsedChrono = null;
        char c = leftStr.charAt(0);
        if (c == 'P' || c == 'p') {
            period = periodParser.parsePeriod(this.getPeriodType(leftStr), leftStr);
        } else {
            DateTime start = dateTimeParser.parseDateTime(leftStr, chrono);
            startInstant = start.getMillis();
            parsedChrono = start.getChronology();
        }
        c = rightStr.charAt(0);
        if (c == 'P' || c == 'p') {
            if (period != null) {
                throw new IllegalArgumentException("Interval composed of two durations: " + str);
            }
            period = periodParser.parsePeriod(this.getPeriodType(rightStr), rightStr);
            chrono = chrono != null ? chrono : parsedChrono;
            endInstant = chrono.add(period, startInstant, 1);
        } else {
            DateTime end = dateTimeParser.parseDateTime(rightStr, chrono);
            endInstant = end.getMillis();
            parsedChrono = parsedChrono != null ? parsedChrono : end.getChronology();
            Chronology chronology = chrono = chrono != null ? chrono : parsedChrono;
            if (period != null) {
                startInstant = chrono.add(period, endInstant, -1);
            }
        }
        writableInterval.setInterval(startInstant, endInstant);
        writableInterval.setChronology(chrono);
    }

    public Class getSupportedType() {
        return class$java$lang$String == null ? (class$java$lang$String = StringConverter.class$("java.lang.String")) : class$java$lang$String;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

