/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BaseGJChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class GJWeekOfWeekyearDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -1587436826395135328L;
    private final BaseGJChronology iChronology;

    GJWeekOfWeekyearDateTimeField(BaseGJChronology chronology, DurationField weeks) {
        super(DateTimeFieldType.weekOfWeekyear(), weeks);
        this.iChronology = chronology;
    }

    public int get(long instant) {
        return this.iChronology.getWeekOfWeekyear(instant);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.weekyears();
    }

    public long roundFloor(long instant) {
        return super.roundFloor(instant + 259200000L) - 259200000L;
    }

    public long roundCeiling(long instant) {
        return super.roundCeiling(instant + 259200000L) - 259200000L;
    }

    public long remainder(long instant) {
        return super.remainder(instant + 259200000L);
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return 53;
    }

    public int getMaximumValue(long instant) {
        int weekyear = this.iChronology.getWeekyear(instant);
        return this.iChronology.getWeeksInYear(weekyear);
    }

    public int getMaximumValue(ReadablePartial partial) {
        if (partial.isSupported(DateTimeFieldType.weekyear())) {
            int weekyear = partial.get(DateTimeFieldType.weekyear());
            return this.iChronology.getWeeksInYear(weekyear);
        }
        return 53;
    }

    public int getMaximumValue(ReadablePartial partial, int[] values) {
        int size = partial.size();
        int i = 0;
        while (i < size) {
            if (partial.getFieldType(i) == DateTimeFieldType.weekyear()) {
                int weekyear = values[i];
                return this.iChronology.getWeeksInYear(weekyear);
            }
            ++i;
        }
        return 53;
    }

    protected int getMaximumValueForSet(long instant, int value) {
        return value > 52 ? this.getMaximumValue(instant) : 52;
    }

    private Object readResolve() {
        return this.iChronology.weekOfWeekyear();
    }
}

