/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import org.joda.time.DateTimeFieldType;
import org.joda.time.DurationField;
import org.joda.time.ReadablePartial;
import org.joda.time.chrono.BaseGJChronology;
import org.joda.time.field.PreciseDurationDateTimeField;

final class GJDayOfMonthDateTimeField
extends PreciseDurationDateTimeField {
    private static final long serialVersionUID = -4677223814028011723L;
    private final BaseGJChronology iChronology;

    GJDayOfMonthDateTimeField(BaseGJChronology chronology, DurationField days) {
        super(DateTimeFieldType.dayOfMonth(), days);
        this.iChronology = chronology;
    }

    public int get(long instant) {
        return this.iChronology.getDayOfMonth(instant);
    }

    public DurationField getRangeDurationField() {
        return this.iChronology.months();
    }

    public int getMinimumValue() {
        return 1;
    }

    public int getMaximumValue() {
        return 31;
    }

    public int getMaximumValue(long instant) {
        int thisYear = this.iChronology.getYear(instant);
        int thisMonth = this.iChronology.getMonthOfYear(instant, thisYear);
        return this.iChronology.getDaysInYearMonth(thisYear, thisMonth);
    }

    public int getMaximumValue(ReadablePartial partial) {
        if (partial.isSupported(DateTimeFieldType.monthOfYear())) {
            int month = partial.get(DateTimeFieldType.monthOfYear());
            if (partial.isSupported(DateTimeFieldType.year())) {
                int year = partial.get(DateTimeFieldType.year());
                return this.iChronology.getDaysInYearMonth(year, month);
            }
            return this.iChronology.getDaysInMonthMax(month);
        }
        return 31;
    }

    public int getMaximumValue(ReadablePartial partial, int[] values) {
        int size = partial.size();
        int i = 0;
        while (i < size) {
            if (partial.getFieldType(i) == DateTimeFieldType.monthOfYear()) {
                int month = values[i];
                int j = 0;
                while (j < size) {
                    if (partial.getFieldType(j) == DateTimeFieldType.year()) {
                        int year = values[j];
                        return this.iChronology.getDaysInYearMonth(year, month);
                    }
                    ++j;
                }
                return this.iChronology.getDaysInMonthMax(month);
            }
            ++i;
        }
        return 31;
    }

    protected int getMaximumValueForSet(long instant, int value) {
        return value > 28 ? this.getMaximumValue(instant) : 28;
    }

    private Object readResolve() {
        return this.iChronology.dayOfMonth();
    }
}

