/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.chrono;

import java.util.HashMap;
import java.util.Map;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.AssembledChronology;
import org.joda.time.chrono.BuddhistEraDateTimeField;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.LimitChronology;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.RemainderDateTimeField;

public final class BuddhistChronology
extends AssembledChronology {
    private static final long serialVersionUID = -3474595157769370126L;
    public static final int BE = 1;
    private static final int BUDDHIST_OFFSET = 543;
    private static final Map cCache = new HashMap();
    private static final BuddhistChronology INSTANCE_UTC = BuddhistChronology.getInstance(DateTimeZone.UTC);

    public static BuddhistChronology getInstanceUTC() {
        return INSTANCE_UTC;
    }

    public static BuddhistChronology getInstance() {
        return BuddhistChronology.getInstance(DateTimeZone.getDefault());
    }

    public static synchronized BuddhistChronology getInstance(DateTimeZone zone) {
        BuddhistChronology chrono;
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if ((chrono = (BuddhistChronology)cCache.get(zone)) == null) {
            chrono = new BuddhistChronology(GJChronology.getInstance(zone, null), null);
            DateTime lowerLimit = new DateTime(1, 1, 1, 0, 0, 0, 0, chrono);
            chrono = new BuddhistChronology(LimitChronology.getInstance(chrono, lowerLimit, null), "");
            cCache.put(zone, chrono);
        }
        return chrono;
    }

    private BuddhistChronology(Chronology base, Object param) {
        super(base, param);
    }

    private Object readResolve() {
        Chronology base = this.getBase();
        return base == null ? BuddhistChronology.getInstanceUTC() : BuddhistChronology.getInstance(base.getZone());
    }

    public Chronology withUTC() {
        return INSTANCE_UTC;
    }

    public Chronology withZone(DateTimeZone zone) {
        if (zone == null) {
            zone = DateTimeZone.getDefault();
        }
        if (zone == this.getZone()) {
            return this;
        }
        return BuddhistChronology.getInstance(zone);
    }

    public String toString() {
        String str = "BuddhistChronology";
        DateTimeZone zone = this.getZone();
        if (zone != null) {
            str = str + '[' + zone.getID() + ']';
        }
        return str;
    }

    protected void assemble(AssembledChronology.Fields fields) {
        if (this.getParam() == null) {
            DateTimeField field = fields.year;
            fields.year = new OffsetDateTimeField(field, 543);
            field = fields.yearOfEra;
            fields.yearOfEra = new OffsetDateTimeField(fields.year, DateTimeFieldType.yearOfEra(), 543);
            field = fields.weekyear;
            fields.weekyear = new OffsetDateTimeField(field, 543);
            field = new OffsetDateTimeField(fields.yearOfEra, 99);
            fields.centuryOfEra = new DividedDateTimeField(field, DateTimeFieldType.centuryOfEra(), 100);
            field = new RemainderDateTimeField((DividedDateTimeField)fields.centuryOfEra);
            fields.yearOfCentury = new OffsetDateTimeField(field, DateTimeFieldType.yearOfCentury(), 1);
            field = new RemainderDateTimeField(fields.weekyear, DateTimeFieldType.weekyearOfCentury(), 100);
            fields.weekyearOfCentury = new OffsetDateTimeField(field, DateTimeFieldType.weekyearOfCentury(), 1);
            fields.era = BuddhistEraDateTimeField.INSTANCE;
        }
    }
}

