/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.Serializable;
import java.util.Arrays;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadablePeriod;
import org.joda.time.field.FieldUtils;

public class PeriodType
implements Serializable {
    private static final long serialVersionUID = 2274324892792009998L;
    static int YEAR_INDEX = 0;
    static int MONTH_INDEX = 1;
    static int WEEK_INDEX = 2;
    static int DAY_INDEX = 3;
    static int HOUR_INDEX = 4;
    static int MINUTE_INDEX = 5;
    static int SECOND_INDEX = 6;
    static int MILLI_INDEX = 7;
    private static PeriodType cStandard;
    private static PeriodType cYMDTime;
    private static PeriodType cYWDTime;
    private static PeriodType cYDTime;
    private static PeriodType cDTime;
    private static PeriodType cTime;
    private static PeriodType cYears;
    private static PeriodType cMonths;
    private static PeriodType cWeeks;
    private static PeriodType cDays;
    private static PeriodType cHours;
    private static PeriodType cMinutes;
    private static PeriodType cSeconds;
    private static PeriodType cMillis;
    private final String iName;
    private final DurationFieldType[] iTypes;
    private final int[] iIndices;

    public static PeriodType standard() {
        PeriodType type = cStandard;
        if (type == null) {
            cStandard = type = new PeriodType("Standard", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, 1, 2, 3, 4, 5, 6, 7});
        }
        return type;
    }

    public static PeriodType yearMonthDayTime() {
        PeriodType type = cYMDTime;
        if (type == null) {
            cYMDTime = type = new PeriodType("YearMonthDayTime", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.months(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, 1, -1, 2, 3, 4, 5, 6});
        }
        return type;
    }

    public static PeriodType yearWeekDayTime() {
        PeriodType type = cYWDTime;
        if (type == null) {
            cYWDTime = type = new PeriodType("YearWeekDayTime", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.weeks(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, -1, 1, 2, 3, 4, 5, 6});
        }
        return type;
    }

    public static PeriodType yearDayTime() {
        PeriodType type = cYDTime;
        if (type == null) {
            cYDTime = type = new PeriodType("YearDayTime", new DurationFieldType[]{DurationFieldType.years(), DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{0, -1, -1, 1, 2, 3, 4, 5});
        }
        return type;
    }

    public static PeriodType dayTime() {
        PeriodType type = cDTime;
        if (type == null) {
            cDTime = type = new PeriodType("DayTime", new DurationFieldType[]{DurationFieldType.days(), DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{-1, -1, -1, 0, 1, 2, 3, 4});
        }
        return type;
    }

    public static PeriodType time() {
        PeriodType type = cTime;
        if (type == null) {
            cTime = type = new PeriodType("Time", new DurationFieldType[]{DurationFieldType.hours(), DurationFieldType.minutes(), DurationFieldType.seconds(), DurationFieldType.millis()}, new int[]{-1, -1, -1, -1, 0, 1, 2, 3});
        }
        return type;
    }

    public static PeriodType years() {
        PeriodType type = cYears;
        if (type == null) {
            cYears = type = new PeriodType("Years", new DurationFieldType[]{DurationFieldType.years()}, new int[]{0, -1, -1, -1, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType months() {
        PeriodType type = cMonths;
        if (type == null) {
            cMonths = type = new PeriodType("Months", new DurationFieldType[]{DurationFieldType.months()}, new int[]{-1, 0, -1, -1, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType weeks() {
        PeriodType type = cWeeks;
        if (type == null) {
            cWeeks = type = new PeriodType("Weeks", new DurationFieldType[]{DurationFieldType.weeks()}, new int[]{-1, -1, 0, -1, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType days() {
        PeriodType type = cDays;
        if (type == null) {
            cDays = type = new PeriodType("Days", new DurationFieldType[]{DurationFieldType.days()}, new int[]{-1, -1, -1, 0, -1, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType hours() {
        PeriodType type = cHours;
        if (type == null) {
            cHours = type = new PeriodType("Hours", new DurationFieldType[]{DurationFieldType.hours()}, new int[]{-1, -1, -1, -1, 0, -1, -1, -1});
        }
        return type;
    }

    public static PeriodType minutes() {
        PeriodType type = cMinutes;
        if (type == null) {
            cMinutes = type = new PeriodType("Minutes", new DurationFieldType[]{DurationFieldType.minutes()}, new int[]{-1, -1, -1, -1, -1, 0, -1, -1});
        }
        return type;
    }

    public static PeriodType seconds() {
        PeriodType type = cSeconds;
        if (type == null) {
            cSeconds = type = new PeriodType("Seconds", new DurationFieldType[]{DurationFieldType.seconds()}, new int[]{-1, -1, -1, -1, -1, -1, 0, -1});
        }
        return type;
    }

    public static PeriodType millis() {
        PeriodType type = cMillis;
        if (type == null) {
            cMillis = type = new PeriodType("Millis", new DurationFieldType[]{DurationFieldType.millis()}, new int[]{-1, -1, -1, -1, -1, -1, -1, 0});
        }
        return type;
    }

    protected PeriodType(String name, DurationFieldType[] types, int[] indices) {
        this.iName = name;
        this.iTypes = types;
        this.iIndices = indices;
    }

    public String getName() {
        return this.iName;
    }

    public int size() {
        return this.iTypes.length;
    }

    public DurationFieldType getFieldType(int index) {
        return this.iTypes[index];
    }

    public boolean isSupported(DurationFieldType type) {
        return this.indexOf(type) >= 0;
    }

    public int indexOf(DurationFieldType type) {
        int i = 0;
        int isize = this.size();
        while (i < isize) {
            if (this.iTypes[i] == type) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toString() {
        String name = this.getName();
        return "PeriodType[" + this.getName() + "]";
    }

    int getIndexedField(ReadablePeriod period, int index) {
        int realIndex = this.iIndices[index];
        return realIndex == -1 ? 0 : period.getValue(realIndex);
    }

    boolean setIndexedField(ReadablePeriod period, int index, int[] values, int newValue) {
        int realIndex = this.iIndices[index];
        if (realIndex == -1) {
            throw new IllegalArgumentException("Field is not supported");
        }
        values[realIndex] = newValue;
        return true;
    }

    boolean addIndexedField(ReadablePeriod period, int index, int[] values, int valueToAdd) {
        int realIndex = this.iIndices[index];
        if (realIndex == -1) {
            throw new IllegalArgumentException("Field is not supported");
        }
        values[realIndex] = FieldUtils.safeAdd(values[realIndex], valueToAdd);
        return true;
    }

    public PeriodType withYearsRemoved() {
        return this.withFieldRemoved(0, "NoYears");
    }

    public PeriodType withMonthsRemoved() {
        return this.withFieldRemoved(1, "NoMonths");
    }

    public PeriodType withWeeksRemoved() {
        return this.withFieldRemoved(2, "NoWeeks");
    }

    public PeriodType withDaysRemoved() {
        return this.withFieldRemoved(3, "NoDays");
    }

    public PeriodType withHoursRemoved() {
        return this.withFieldRemoved(4, "NoHours");
    }

    public PeriodType withMinutesRemoved() {
        return this.withFieldRemoved(5, "NoMinutes");
    }

    public PeriodType withSecondsRemoved() {
        return this.withFieldRemoved(6, "NoSeconds");
    }

    public PeriodType withMillisRemoved() {
        return this.withFieldRemoved(7, "NoMillis");
    }

    private PeriodType withFieldRemoved(int indicesIndex, String name) {
        int fieldIndex = this.iIndices[indicesIndex];
        if (fieldIndex == -1) {
            return this;
        }
        DurationFieldType[] types = new DurationFieldType[this.size() - 1];
        int i = 0;
        while (i < this.iTypes.length) {
            if (i < fieldIndex) {
                types[i] = this.iTypes[i];
            } else if (i > fieldIndex) {
                types[i - 1] = this.iTypes[i];
            }
            ++i;
        }
        int[] indices = new int[8];
        int i2 = 0;
        while (i2 < indices.length) {
            indices[i2] = i2 < indicesIndex ? this.iIndices[i2] : (i2 > indicesIndex ? (this.iIndices[i2] == -1 ? -1 : this.iIndices[i2] - 1) : -1);
            ++i2;
        }
        return new PeriodType(this.getName() + name, types, indices);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PeriodType)) {
            return false;
        }
        PeriodType other = (PeriodType)obj;
        return Arrays.equals(this.iTypes, other.iTypes);
    }

    public int hashCode() {
        int hash = 0;
        int i = 0;
        while (i < this.iTypes.length) {
            hash += this.iTypes[i].hashCode();
            ++i;
        }
        return hash;
    }
}

