/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork.config.providers;

import com.opensymphony.util.ClassLoaderUtil;
import com.opensymphony.util.FileManager;
import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.config.Configuration;
import com.opensymphony.xwork.config.ConfigurationException;
import com.opensymphony.xwork.config.ConfigurationProvider;
import com.opensymphony.xwork.config.ConfigurationUtil;
import com.opensymphony.xwork.config.ExternalReferenceResolver;
import com.opensymphony.xwork.config.entities.ActionConfig;
import com.opensymphony.xwork.config.entities.ExternalReference;
import com.opensymphony.xwork.config.entities.InterceptorConfig;
import com.opensymphony.xwork.config.entities.InterceptorStackConfig;
import com.opensymphony.xwork.config.entities.PackageConfig;
import com.opensymphony.xwork.config.entities.ResultConfig;
import com.opensymphony.xwork.config.entities.ResultTypeConfig;
import com.opensymphony.xwork.config.providers.InterceptorBuilder;
import com.opensymphony.xwork.config.providers.XmlHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlConfigurationProvider
implements ConfigurationProvider {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider == null ? (class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider = XmlConfigurationProvider.class$("com.opensymphony.xwork.config.providers.XmlConfigurationProvider")) : class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider));
    private Configuration configuration;
    private Set includedFileNames = new HashSet();
    private String configFileName = "xwork.xml";
    static /* synthetic */ Class class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider;
    static /* synthetic */ Class class$com$opensymphony$xwork$config$ExternalReferenceResolver;

    public XmlConfigurationProvider() {
    }

    public XmlConfigurationProvider(String filename) {
        this.configFileName = filename;
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof XmlConfigurationProvider)) {
            return false;
        }
        XmlConfigurationProvider xmlConfigurationProvider = (XmlConfigurationProvider)o;
        return !(this.configFileName != null ? !this.configFileName.equals(xmlConfigurationProvider.configFileName) : xmlConfigurationProvider.configFileName != null);
    }

    public int hashCode() {
        return this.configFileName != null ? this.configFileName.hashCode() : 0;
    }

    public void init(Configuration configuration) {
        this.configuration = configuration;
        this.includedFileNames.clear();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(true);
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if ("-//OpenSymphony Group//XWork 1.0//EN".equals(publicId)) {
                        return new InputSource(ClassLoaderUtil.getResourceAsStream((String)"xwork-1.0.dtd", (Class)(class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider == null ? (class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider = XmlConfigurationProvider.class$("com.opensymphony.xwork.config.providers.XmlConfigurationProvider")) : class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider)));
                    }
                    return null;
                }
            });
            db.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                }

                public void error(SAXParseException exception) throws SAXException {
                    LOG.error((Object)(exception.getMessage() + " at (" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")"));
                    throw exception;
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    LOG.fatal((Object)(exception.getMessage() + " at (" + exception.getLineNumber() + ":" + exception.getColumnNumber() + ")"));
                    throw exception;
                }
            });
            this.loadConfigurationFile(this.configFileName, db);
        }
        catch (Exception e) {
            LOG.fatal((Object)"Could not load XWork configuration file, failing", (Throwable)e);
            throw new ConfigurationException("Error loading configuration file " + this.configFileName, e);
        }
    }

    public boolean needsReload() {
        boolean needsReload = FileManager.fileNeedsReloading((String)this.configFileName);
        Iterator fileNameIterator = this.includedFileNames.iterator();
        while (!needsReload && fileNameIterator.hasNext()) {
            String fileName = (String)fileNameIterator.next();
            needsReload = FileManager.fileNeedsReloading((String)fileName);
        }
        return needsReload;
    }

    protected InputStream getInputStream(String fileName) {
        InputStream is = FileManager.loadFile((String)fileName, this.getClass());
        return is;
    }

    protected void addAction(Element actionElement, PackageConfig packageContext) throws ConfigurationException {
        Map results;
        String name = actionElement.getAttribute("name");
        String className = actionElement.getAttribute("class");
        String methodName = actionElement.getAttribute("method");
        methodName = methodName.trim().length() > 0 ? methodName.trim() : null;
        try {
            ActionConfig actionConfig = new ActionConfig(null, className, null, null, null);
            Action action = ObjectFactory.getObjectFactory().buildAction(actionConfig);
        }
        catch (Exception e) {
            LOG.error((Object)("Action class [" + className + "] not found, skipping action [" + name + "]"), (Throwable)e);
            return;
        }
        HashMap actionParams = XmlHelper.getParams(actionElement);
        try {
            results = this.buildResults(actionElement, packageContext);
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("Error building results for action " + name + " in namespace " + packageContext.getNamespace(), e);
        }
        List interceptorList = this.buildInterceptorList(actionElement, packageContext);
        List externalrefs = this.buildExternalRefs(actionElement, packageContext);
        ActionConfig actionConfig = new ActionConfig(methodName, className, actionParams, results, interceptorList, externalrefs, packageContext.getName());
        packageContext.addActionConfig(name, actionConfig);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded " + (TextUtils.stringSet((String)packageContext.getNamespace()) ? packageContext.getNamespace() + "/" : "") + name + " in '" + packageContext.getName() + "' package:" + actionConfig));
        }
    }

    protected void addPackage(Element packageElement) throws ConfigurationException {
        PackageConfig newPackage = this.buildPackageContext(packageElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded " + newPackage));
        }
        this.addResultTypes(newPackage, packageElement);
        this.loadInterceptors(newPackage, packageElement);
        this.loadDefaultInterceptorRef(newPackage, packageElement);
        this.loadGlobalResults(newPackage, packageElement);
        NodeList actionList = packageElement.getElementsByTagName("action");
        for (int i = 0; i < actionList.getLength(); ++i) {
            Element actionElement = (Element)actionList.item(i);
            this.addAction(actionElement, newPackage);
        }
        this.configuration.addPackageConfig(newPackage.getName(), newPackage);
    }

    protected void addResultTypes(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("result-type");
        for (int i = 0; i < resultTypeList.getLength(); ++i) {
            Element resultTypeElement = (Element)resultTypeList.item(i);
            String name = resultTypeElement.getAttribute("name");
            String className = resultTypeElement.getAttribute("class");
            String def = resultTypeElement.getAttribute("default");
            try {
                Class clazz = ClassLoaderUtil.loadClass((String)className, (Class)(class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider == null ? XmlConfigurationProvider.class$("com.opensymphony.xwork.config.providers.XmlConfigurationProvider") : class$com$opensymphony$xwork$config$providers$XmlConfigurationProvider));
                ResultTypeConfig resultType = new ResultTypeConfig(name, clazz);
                packageContext.addResultTypeConfig(resultType);
                if (!"true".equals(def)) continue;
                packageContext.setDefaultResultType(name);
                continue;
            }
            catch (ClassNotFoundException e) {
                LOG.error((Object)("Result class [" + className + "] doesn't exist, ignoring"));
            }
        }
    }

    protected List buildExternalRefs(Element element, PackageConfig context) throws ConfigurationException {
        ArrayList<ExternalReference> refs = new ArrayList<ExternalReference>();
        NodeList externalRefList = element.getElementsByTagName("external-ref");
        String refName = null;
        String refValue = null;
        String requiredTemp = null;
        for (int i = 0; i < externalRefList.getLength(); ++i) {
            Element refElement = (Element)externalRefList.item(i);
            if (!refElement.getParentNode().equals(element)) continue;
            refName = refElement.getAttribute("name");
            if (refElement.getChildNodes().getLength() > 0) {
                refValue = refElement.getChildNodes().item(0).getNodeValue();
            }
            boolean required = (requiredTemp = refElement.getAttribute("required")) == null || "".equals(requiredTemp) ? true : Boolean.valueOf(requiredTemp);
            refs.add(new ExternalReference(refName, refValue, required));
        }
        return refs;
    }

    protected List buildInterceptorList(Element element, PackageConfig context) throws ConfigurationException {
        ArrayList interceptorList = new ArrayList();
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int i = 0; i < interceptorRefList.getLength(); ++i) {
            Element interceptorRefElement = (Element)interceptorRefList.item(i);
            if (!interceptorRefElement.getParentNode().equals(element)) continue;
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            interceptorList.addAll(interceptors);
        }
        return interceptorList;
    }

    protected PackageConfig buildPackageContext(Element packageElement) {
        String parent = packageElement.getAttribute("extends");
        String abstractVal = packageElement.getAttribute("abstract");
        boolean isAbstract = Boolean.valueOf(abstractVal);
        String name = TextUtils.noNull((String)packageElement.getAttribute("name"));
        String namespace = TextUtils.noNull((String)packageElement.getAttribute("namespace"));
        ExternalReferenceResolver erResolver = null;
        String externalReferenceResolver = TextUtils.noNull((String)packageElement.getAttribute("externalReferenceResolver"));
        if (!"".equals(externalReferenceResolver)) {
            try {
                Class erResolverClazz = ClassLoaderUtil.loadClass((String)externalReferenceResolver, (Class)(class$com$opensymphony$xwork$config$ExternalReferenceResolver == null ? (class$com$opensymphony$xwork$config$ExternalReferenceResolver = XmlConfigurationProvider.class$("com.opensymphony.xwork.config.ExternalReferenceResolver")) : class$com$opensymphony$xwork$config$ExternalReferenceResolver));
                erResolver = (ExternalReferenceResolver)erResolverClazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                String msg = "Could not find External Reference Resolver: " + externalReferenceResolver + ". " + e.getMessage();
                LOG.error((Object)msg);
                throw new ConfigurationException(msg, e);
            }
            catch (Exception e) {
                String msg = "Could not create External Reference Resolver: " + externalReferenceResolver + ". " + e.getMessage();
                LOG.error((Object)msg);
                throw new ConfigurationException(msg, e);
            }
        }
        if (!TextUtils.stringSet((String)TextUtils.noNull((String)parent))) {
            return new PackageConfig(name, namespace, isAbstract, erResolver);
        }
        List parents = ConfigurationUtil.buildParentsFromString(this.configuration, parent);
        if (parents.size() <= 0) {
            LOG.error((Object)("Unable to find parent packages " + parent));
            return new PackageConfig(name, namespace, isAbstract, erResolver);
        }
        return new PackageConfig(name, namespace, isAbstract, erResolver, parents);
    }

    protected Map buildResults(Element element, PackageConfig packageContext) {
        NodeList resultEls = element.getElementsByTagName("result");
        HashMap<String, ResultConfig> results = new HashMap<String, ResultConfig>();
        for (int i = 0; i < resultEls.getLength(); ++i) {
            HashMap<String, String> params;
            ResultTypeConfig config;
            Element resultElement = (Element)resultEls.item(i);
            if (!resultElement.getParentNode().equals(element)) continue;
            String resultName = resultElement.getAttribute("name");
            String resultType = resultElement.getAttribute("type");
            if (!TextUtils.stringSet((String)resultType)) {
                resultType = packageContext.getFullDefaultResultType();
            }
            if ((config = (ResultTypeConfig)packageContext.getAllResultTypeConfigs().get(resultType)) == null) {
                throw new ConfigurationException("There is no result type defined for type '" + resultType + "' mapped with name '" + resultName + "'");
            }
            Class resultClass = config.getClazz();
            if (resultClass == null) {
                LOG.error((Object)("Result type '" + resultType + "' is invalid. Modify your xwork.xml file."));
            }
            if ((params = XmlHelper.getParams(resultElement)).size() == 0 && resultElement.getChildNodes().getLength() == 1 && resultElement.getChildNodes().item(0).getNodeType() == 3) {
                params = new HashMap<String, String>();
                try {
                    String paramName = (String)resultClass.getField("DEFAULT_PARAM").get(null);
                    params.put(paramName, resultElement.getChildNodes().item(0).getNodeValue());
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            ResultConfig resultConfig = new ResultConfig(resultName, resultClass, (Map)params);
            results.put(resultConfig.getName(), resultConfig);
        }
        return results;
    }

    protected void loadDefaultInterceptorRef(PackageConfig packageContext, Element element) {
        NodeList resultTypeList = element.getElementsByTagName("default-interceptor-ref");
        if (resultTypeList.getLength() > 0) {
            Element defaultRefElement = (Element)resultTypeList.item(0);
            packageContext.setDefaultInterceptorRef(defaultRefElement.getAttribute("name"));
        }
    }

    protected void loadGlobalResults(PackageConfig packageContext, Element packageElement) {
        NodeList globalResultList = packageElement.getElementsByTagName("global-results");
        if (globalResultList.getLength() > 0) {
            Element globalResultElement = (Element)globalResultList.item(0);
            Map results = this.buildResults(globalResultElement, packageContext);
            packageContext.addGlobalResultConfigs(results);
        }
    }

    protected InterceptorStackConfig loadInterceptorStack(Element element, PackageConfig context) throws ConfigurationException {
        String name = element.getAttribute("name");
        InterceptorStackConfig config = new InterceptorStackConfig(name);
        NodeList interceptorRefList = element.getElementsByTagName("interceptor-ref");
        for (int j = 0; j < interceptorRefList.getLength(); ++j) {
            Element interceptorRefElement = (Element)interceptorRefList.item(j);
            List interceptors = this.lookupInterceptorReference(context, interceptorRefElement);
            config.addInterceptors(interceptors);
        }
        return config;
    }

    protected void loadInterceptorStacks(Element element, PackageConfig context) throws ConfigurationException {
        NodeList interceptorStackList = element.getElementsByTagName("interceptor-stack");
        for (int i = 0; i < interceptorStackList.getLength(); ++i) {
            Element interceptorStackElement = (Element)interceptorStackList.item(i);
            InterceptorStackConfig config = this.loadInterceptorStack(interceptorStackElement, context);
            context.addInterceptorStackConfig(config);
        }
    }

    protected void loadInterceptors(PackageConfig context, Element element) throws ConfigurationException {
        NodeList interceptorList = element.getElementsByTagName("interceptor");
        for (int i = 0; i < interceptorList.getLength(); ++i) {
            Element interceptorElement = (Element)interceptorList.item(i);
            String name = interceptorElement.getAttribute("name");
            String className = interceptorElement.getAttribute("class");
            HashMap params = XmlHelper.getParams(interceptorElement);
            InterceptorConfig config = null;
            try {
                config = new InterceptorConfig(name, className, (Map)params);
                ObjectFactory.getObjectFactory().buildInterceptor(config, new HashMap());
                context.addInterceptorConfig(config);
            }
            catch (ConfigurationException e) {
                String s = "Unable to load class " + className + " for interceptor name " + name + ". This interceptor will not be available.";
                LOG.error((Object)s);
                throw e;
            }
            context.addInterceptorConfig(config);
        }
        this.loadInterceptorStacks(element, context);
    }

    /*
     * Unable to fully structure code
     */
    private void loadConfigurationFile(String fileName, DocumentBuilder db) {
        if (!this.includedFileNames.contains(fileName)) {
            block15: {
                if (XmlConfigurationProvider.LOG.isDebugEnabled()) {
                    XmlConfigurationProvider.LOG.debug((Object)("Loading xwork configuration from: " + fileName));
                }
                this.includedFileNames.add(fileName);
                doc = null;
                is = null;
                try {
                    is = this.getInputStream(fileName);
                    if (is == null) {
                        throw new Exception("Could not open file " + fileName);
                    }
                    doc = db.parse(is);
                    var8_5 = null;
                    ** if (is == null) goto lbl-1000
                }
                catch (Throwable var7_14) {
                    var8_6 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            XmlConfigurationProvider.LOG.error((Object)"Unable to close input stream", (Throwable)e);
                        }
                    }
                    throw var7_14;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        XmlConfigurationProvider.LOG.error((Object)"Unable to close input stream", (Throwable)e);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block15;
                    catch (Exception e) {
                        s = "Caught exception while loading file " + fileName;
                        XmlConfigurationProvider.LOG.error((Object)s, (Throwable)e);
                        throw new ConfigurationException(s, e);
                    }
                }
            }
            rootElement = doc.getDocumentElement();
            children = rootElement.getChildNodes();
            childSize = children.getLength();
            for (i = 0; i < childSize; ++i) {
                childNode = children.item(i);
                if (!(childNode instanceof Element)) continue;
                child = (Element)childNode;
                nodeName = child.getNodeName();
                if (nodeName.equals("package")) {
                    this.addPackage(child);
                    continue;
                }
                if (!nodeName.equals("include")) continue;
                includeFileName = child.getAttribute("file");
                this.loadConfigurationFile(includeFileName, db);
            }
            if (XmlConfigurationProvider.LOG.isDebugEnabled()) {
                XmlConfigurationProvider.LOG.debug((Object)("Loaded xwork configuration from: " + fileName));
            }
        }
    }

    private List lookupInterceptorReference(PackageConfig context, Element interceptorRefElement) throws ConfigurationException {
        String refName = interceptorRefElement.getAttribute("name");
        HashMap refParams = XmlHelper.getParams(interceptorRefElement);
        return InterceptorBuilder.constructInterceptorReference(context, refName, refParams);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

