/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.license.util;

import com.atlassian.license.License;
import com.atlassian.license.LicenseException;
import com.atlassian.license.LicensePair;
import com.atlassian.license.LicenseType;
import com.atlassian.license.applications.confluence.ConfluenceLicenseTypeStore;
import com.atlassian.license.applications.jira.JiraLicenseTypeStore;
import com.atlassian.license.decoder.LicenseDecoder;
import com.atlassian.license.encoder.LicenseEncoder;
import java.util.Date;

public class UtilsForTestLicense {
    public static final String VALID_BAMBOO_LICENSE = "poOnrCsXIUMGiPmsTpJBumFNfMnsUOjiiUlUJuKhahEGbfh\nmj2L0Iew<bW6q42TVd602QLM42KrhMnGxxfGutv80mzG15Y\npmNUTmQpMrRmMMmRrPsXqRQqqnprmNrqrVXSvxwxsuuxwwq\nonUUnnqpsmvppmrsoUUnnqpsmvppmrsoUU1qiXppfXkUU";
    public static final String VALID_BAMBOO__EVAL = "QQppndDsLNCGiuvxSHCliGjSMowMHKvQWfgsbDRTURcDDU\nmi2KNm9UJF3USiMYtQ6e3bLW2Kj0umOS7v>QsR>HAwOLpy\nmoNTUPPoQmQqQQqoqnsxPMmrnmrMnrMnQtWusSstWsVxTs\nqmnUUnnqpsnmnnmvmsUUnnqpsnmnnmvmsUU1qiXppfXkUU";
    public static final String INVALID_BAMBOO__EVAL = "QQppndDsLNCGiuvxSHCliGjSMowMHKvQWfgsbDRTURcDDU\nmi2KNm9UJF3USiMYtQ6e3bLW2Kj0umOS7v>QsR>HAwOLpy\nmoNTUPPoQmQqQQqoqnsxPMmrnmrMnrMnQtWusSstWsVxTs\nboohiss";
    public static final String VALID_STANDARD_LICENSE_KEY = "pMOmXAfgWFQgVrKXApkvjJGBOmocPhsXCxDIMMTfetvfCqh\nmj2KIZZO2VOwkBYBoPXQQGc42L0GNi5tECBWO2yx8qP3DGc\nnpmVXqoRnPROqmnOmPwwoRRrMPpOMpOorwUXXXtsutUWoWX\nTTmUXuUUntvUUnnoqstsvvmrtrUUnnoqstsvvmrtrUU1qiX\nppfXkWLkfqWKbpqp";
    public static final String VALID_PROFESSIONAL_LICENSE_KEY = "pOOpsVmvqBMopWSnchcHIoGWpNwnfbkwGiLUQTMtVrcOHh\nmi2KYm>B5DXXE6PSJ6R<2QwY2KPkPYkC<cl<6VJyrbUg2V\nPRVxorrMRPorOOqRpssMmOOQNOmPmqmpWTsstwWswsSPWX\nWsPSSUuuutUUnnoqsttmpmttvUUnnoqsttmpmttvUU1qiX\nppfXkWLkfqWKbpqp";
    public static final String VALID_ENTERPRISE_LICENSE_KEY = "NPqompwVFQDjpROdchwtSPdxNmXjFikOgAURExabrEACVP\nmi2K2VwVwLiJRptWImyl1m1n2KKlzC5a0ekPad5imQEBiT\nRQnsVNQmqopoMMMnnRSUnNrOnMpMpOnQRStvVwvXUvVXRS\nvVWPxTtwUostUUnnoqsttnpmmvqUUnnoqsttnpmmvqUU1q\niXppfXkWLkfqWKbpqp";
    public static String CONF_PERSONAL = "RMQnMHfHgOdcXtsbxgthWlhGMqPjjohWooQRblRhqULcDL\nmi2KbYrVLoNc8Q4PxHiJGIwJ2KjUdOKqhKE6gyoELiAnlD\nqqusoMononqmpnNNnuTnRroOpRPmQrPMVVsSXxsuuUVwUU\nnRVwmvsUUnnmtsvqummmmmUUnnmtsvqummmmmUUdelpqYr\npqbopWoUUo";
    public static String CONF_NON_PROFIT = "qQrQTnlWmvSolLqWNdeDPFxgmpocmkOIGKiSxwWufPDdMh\nmi2K00bBkbWzPDJHD62qn97T2Kt3aFShIU<Qhv0Nh<NnFV\nopstQMRoRoqqRQrQRVXoRRpOOQPoQprRXtVwVSVTtRvtOT\nSWsROxWqrrtuUUnnmtsvqummmmmUUnnmtsvqummmmmUUgr\npqfcvWjvWcrkhWoUUomm";
    public static String CONF_EVAL = "NMPOtsNAIUsWSkswgAOBgCsxPrNuHSqAWCvsrUvLBbnQSk\nmi2KkafGXiuTYuQ1FuluW1K32KdD8wcEpYzaR9c1mT>MJN\nnOUTNNNQOnqqOPNMMVVPmOONqmonQRQRxxuXXwwXWvUNtu\nTWSMmQpMurUUnmtpummummmmmUUnmtpummummmmmUU1qiX\nppfXkW4bsUUnmmmm";
    public static final String JIRA_APPLICATION_NAME = "JIRA";
    public static final String CONF_APPLICATION_NAME = "CONFLUENCE";
    public static final String TEST_LICENSE_REG_LOCATION = "com.atlassian.license.MemoryLicenseRegistry";

    public static License setupExpiredLicense(Date dateCreated) throws LicenseException {
        String atlassian_pair_string = LicenseEncoder.getLicensePairString((String)"Atlassian", (LicenseType)JiraLicenseTypeStore.JIRA_STANDARD_ACADEMIC, (Date)dateCreated, (int)-1, (String)JIRA_APPLICATION_NAME, null);
        LicensePair atlassian_pair = new LicensePair(atlassian_pair_string);
        return LicenseDecoder.getLicense(atlassian_pair, JIRA_APPLICATION_NAME);
    }

    public static License setupExpiredLicenseForConfluence(Date dateCreated) throws LicenseException {
        String atlassian_pair_string = LicenseEncoder.getLicensePairString((String)"Atlassian", (LicenseType)ConfluenceLicenseTypeStore.NON_PROFIT, (Date)dateCreated, (int)-1, (String)CONF_APPLICATION_NAME, null);
        LicensePair atlassian_pair = new LicensePair(atlassian_pair_string);
        return LicenseDecoder.getLicense(atlassian_pair, CONF_APPLICATION_NAME);
    }
}

