/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.license.decoder;

import com.atlassian.core.util.StringUtils;
import com.atlassian.license.DefaultLicense;
import com.atlassian.license.License;
import com.atlassian.license.LicenseException;
import com.atlassian.license.LicenseManager;
import com.atlassian.license.LicensePair;
import com.atlassian.license.LicenseType;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.log4j.Category;

public class LicenseDecoder {
    private static Category log = Category.getInstance((Class)(class$com$atlassian$license$decoder$LicenseDecoder == null ? (class$com$atlassian$license$decoder$LicenseDecoder = LicenseDecoder.class$("com.atlassian.license.decoder.LicenseDecoder")) : class$com$atlassian$license$decoder$LicenseDecoder));
    static /* synthetic */ Class class$com$atlassian$license$decoder$LicenseDecoder;

    public static License getLicense(LicensePair pair, String applicationName) {
        try {
            return LicenseDecoder.loadLicense(pair, LicenseDecoder.getPublicKey(applicationName), applicationName);
        }
        catch (LicenseException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static boolean isValid(LicensePair pair, String applicationName) {
        return LicenseDecoder.getLicense(pair, applicationName) != null;
    }

    private static PublicKey getPublicKey(String applicationName) throws LicenseException {
        String publicKeyFileName = LicenseDecoder.getPublicKeyFilename(applicationName);
        if (publicKeyFileName == null || "".equals(publicKeyFileName)) {
            throw new LicenseException("The filename for the public key is null. This must be set before a public key can be located.");
        }
        try {
            InputStream keyfis = Thread.currentThread().getContextClassLoader().getResourceAsStream(publicKeyFileName);
            byte[] encKey = new byte[keyfis.available()];
            keyfis.read(encKey);
            keyfis.close();
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(encKey);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return keyFactory.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            log.error((Object)("Exception looking up public key: " + e.getMessage()), (Throwable)e);
            throw new LicenseException("Exception getting verification from file - possible classloader problem, or corrupt JIRA installation ");
        }
    }

    private static License loadLicense(LicensePair pair, PublicKey publicKey, String applicationName) {
        try {
            Signature signature = Signature.getInstance("SHA1withDSA");
            signature.initVerify(publicKey);
            signature.update(pair.getLicense());
            if (signature.verify(pair.getHash())) {
                String messageString = LicenseDecoder.getDecodedMessage(pair.getLicense());
                StringTokenizer tokenizer = new StringTokenizer(messageString, "^");
                if (tokenizer.hasMoreTokens()) {
                    int licenseTypeCode = Integer.parseInt(tokenizer.nextToken());
                    LicenseType licenseType = LicenseManager.getInstance().getLicenseType(applicationName, licenseTypeCode);
                    Date dateCreated = new Date(Long.parseLong(tokenizer.nextToken()));
                    Date datePurchased = new Date(Long.parseLong(tokenizer.nextToken()));
                    String organisation = tokenizer.nextToken();
                    String licenseId = LicenseDecoder.getLicenseIdFromLicenseString(pair.getOriginalLicenseString());
                    int users = -1;
                    if (licenseType.requiresUserLimit()) {
                        users = Integer.parseInt(tokenizer.nextToken());
                    }
                    String partnerName = null;
                    if (tokenizer.hasMoreTokens()) {
                        partnerName = tokenizer.nextToken();
                    }
                    return new DefaultLicense(dateCreated, datePurchased, organisation, licenseType, users, partnerName, licenseId);
                }
            } else {
                log.warn((Object)"Signature did not verify properly.");
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        return null;
    }

    private static String getLicenseIdFromLicenseString(String originalLicenseString) {
        if (originalLicenseString != null && originalLicenseString.length() > 70) {
            return StringUtils.replaceAll((String)StringUtils.replaceAll((String)StringUtils.replaceAll((String)originalLicenseString, (String)"\n", (String)""), (String)"\r", (String)""), (String)"\t", (String)"").substring(59, 69).toUpperCase();
        }
        return "";
    }

    private static String getDecodedMessage(byte[] message) {
        return new String(message);
    }

    public static boolean isValid(LicensePair pair, PublicKey publicKey, String applicationName) {
        return LicenseDecoder.loadLicense(pair, publicKey, applicationName) != null;
    }

    public static String getPublicKeyFilename(String applicationName) {
        return LicenseManager.getInstance().getLicenseTypeStore(applicationName).getPublicKeyFileName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

