/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.license;

import com.atlassian.license.License;
import com.atlassian.license.LicenseType;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class DefaultLicense
implements License {
    public static long EVALUATION_PERIOD = 2678400000L;
    protected Date dateCreated;
    protected Date datePurchased;
    protected String organisation;
    protected LicenseType licenseType;
    private int users;
    private String partnerName;
    private String licenseId;

    public DefaultLicense(Date dateCreated, Date datePurchased, String organisation, LicenseType licenseType, int users, String partnerName) {
        this.dateCreated = dateCreated;
        this.datePurchased = datePurchased;
        this.organisation = organisation;
        this.licenseType = licenseType;
        this.users = users;
        this.partnerName = partnerName;
        this.licenseId = "";
    }

    public DefaultLicense(Date dateCreated, Date datePurchased, String organisation, LicenseType licenseType, int users, String partnerName, String licenseId) {
        this.dateCreated = dateCreated;
        this.datePurchased = datePurchased;
        this.organisation = organisation;
        this.licenseType = licenseType;
        this.users = users;
        this.partnerName = partnerName;
        this.licenseId = licenseId;
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getDatePurchased() {
        return this.datePurchased;
    }

    public String getOrganisation() {
        return this.organisation;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public String toString() {
        return this.licenseType.getNiceName() + " licensed to " + this.organisation;
    }

    public boolean isExpired() {
        if (this.licenseType.isEvaluationLicenseType()) {
            return System.currentTimeMillis() - this.datePurchased.getTime() > EVALUATION_PERIOD;
        }
        return false;
    }

    public Date getExpiryDate() {
        if (this.licenseType.isEvaluationLicenseType()) {
            return new Date(this.datePurchased.getTime() + EVALUATION_PERIOD);
        }
        return null;
    }

    public String getPartnerName() {
        return this.partnerName;
    }

    public boolean isLicenseLevel(Collection levels) {
        Iterator iterator = levels.iterator();
        while (iterator.hasNext()) {
            String level = (String)iterator.next();
            if (this.getLicenseType().getDescription().toLowerCase().indexOf(level.toLowerCase()) == -1) continue;
            return true;
        }
        return false;
    }

    public int getUsers() {
        if (this.licenseType.requiresUserLimit()) {
            return this.users;
        }
        return -1;
    }

    public String getLicenseId() {
        return this.licenseId;
    }
}

