/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.license;

import com.atlassian.license.LicenseException;
import com.atlassian.license.LicenseRegistry;
import com.atlassian.license.LicenseType;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractLicenseRegistry
implements LicenseRegistry {
    protected abstract Collection getAllLicenseTypes();

    public LicenseType getLicenseType(String type) throws LicenseException {
        Iterator iterator = this.getAllLicenseTypes().iterator();
        while (iterator.hasNext()) {
            LicenseType licenseType = (LicenseType)iterator.next();
            String licenseTypeDesc = licenseType.getDescription().toLowerCase();
            if (licenseTypeDesc.indexOf(type.toLowerCase()) == -1) continue;
            return licenseType;
        }
        throw new LicenseException("The license type (" + type + ") specified is invalid.");
    }

    public LicenseType getLicenseType(int type) throws LicenseException {
        Iterator iterator = this.getAllLicenseTypes().iterator();
        while (iterator.hasNext()) {
            LicenseType licenseType = (LicenseType)iterator.next();
            if (licenseType.getType() != type) continue;
            return licenseType;
        }
        throw new LicenseException("The license type (" + type + ") specified is invalid.");
    }
}

