/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.xslt;

import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.config.Configuration;
import com.opensymphony.webwork.views.xslt.DOMAdapter;
import com.opensymphony.webwork.views.xslt.ServletURIResolver;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.Result;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.opensymphony.xwork.util.TextParseUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XSLTResult
implements Result {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$webwork$views$xslt$XSLTResult == null ? (class$com$opensymphony$webwork$views$xslt$XSLTResult = XSLTResult.class$("com.opensymphony.webwork.views.xslt.XSLTResult")) : class$com$opensymphony$webwork$views$xslt$XSLTResult));
    public static final String DEFAULT_PARAM = "location";
    protected boolean noCache = false;
    private Map templatesCache = new HashMap();
    private String location;
    private boolean parse;
    static /* synthetic */ Class class$com$opensymphony$webwork$views$xslt$XSLTResult;

    public XSLTResult() {
        this.noCache = Configuration.getString("webwork.xslt.nocache").trim().equalsIgnoreCase("true");
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        long startTime = System.currentTimeMillis();
        if (this.parse) {
            OgnlValueStack stack = ActionContext.getContext().getValueStack();
            this.location = TextParseUtil.translateVariables((String)this.location, (OgnlValueStack)stack);
        }
        try {
            HttpServletResponse response = ServletActionContext.getResponse();
            PrintWriter writer = response.getWriter();
            Templates templates = this.getTemplates(this.location);
            Transformer transformer = templates.newTransformer();
            String mimeType = templates.getOutputProperties().getProperty("media-type");
            if (mimeType == null) {
                mimeType = "text/html";
            }
            response.setContentType(mimeType);
            Source xmlSource = this.getTraxSourceForStack(invocation.getAction());
            PrintWriter out = response.getWriter();
            transformer.transform(xmlSource, new StreamResult(out));
            out.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Time:" + (System.currentTimeMillis() - startTime) + "ms"));
            }
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            log.error((Object)("Unable to render XSLT Template, '" + this.location + "'"), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Templates getTemplates(String path) throws TransformerException, IOException {
        String pathFromRequest = ServletActionContext.getRequest().getParameter("xslt.location");
        if (pathFromRequest != null) {
            path = pathFromRequest;
        }
        if (path == null) {
            throw new TransformerException("Stylesheet path is null");
        }
        Templates templates = (Templates)this.templatesCache.get(path);
        if (this.noCache || templates == null) {
            Map map = this.templatesCache;
            synchronized (map) {
                URL resource = ServletActionContext.getServletContext().getResource(path);
                if (resource == null) {
                    throw new TransformerException("Stylesheet " + path + " not found in resources.");
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Preparing new XSLT stylesheet: " + path));
                }
                TransformerFactory factory = TransformerFactory.newInstance();
                log.trace((Object)("Uri-Resolver is: " + factory.getURIResolver()));
                factory.setURIResolver(new ServletURIResolver(ServletActionContext.getServletContext()));
                log.trace((Object)("Uri-Resolver is: " + factory.getURIResolver()));
                templates = factory.newTemplates(new StreamSource(resource.openStream()));
                this.templatesCache.put(path, templates);
            }
        }
        return templates;
    }

    private Source getTraxSourceForStack(Object action) throws IllegalAccessException, InstantiationException {
        return new DOMSource(new DOMAdapter().adapt(action));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

