/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.views.freemarker;

import com.opensymphony.util.FileManager;
import com.opensymphony.webwork.util.FreemarkerWebWorkUtil;
import com.opensymphony.webwork.views.freemarker.ScopesHashModel;
import com.opensymphony.webwork.views.jsp.ui.OgnlTool;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ObjectFactory;
import com.opensymphony.xwork.util.OgnlValueStack;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.cache.WebappTemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.jsp.TaglibFactory;
import freemarker.ext.servlet.HttpRequestHashModel;
import freemarker.ext.servlet.HttpSessionHashModel;
import freemarker.ext.servlet.ServletContextHashModel;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FreemarkerManager {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$webwork$views$freemarker$FreemarkerManager == null ? (class$com$opensymphony$webwork$views$freemarker$FreemarkerManager = FreemarkerManager.class$("com.opensymphony.webwork.views.freemarker.FreemarkerManager")) : class$com$opensymphony$webwork$views$freemarker$FreemarkerManager));
    public static final String CONFIG_SERVLET_CONTEXT_KEY = "freemarker.Configuration";
    public static final String KEY_REQUEST = "req";
    public static final String KEY_RESPONSE = "res";
    public static final String KEY_STACK = "stack";
    public static final String KEY_OGNL = "ognl";
    public static final String KEY_UTIL = "wwUtil";
    public static final String KEY_WEBWORK = "webwork";
    public static final String KEY_EXCEPTION = "exception";
    public static final String KEY_ACTION = "action";
    private static final String ATTR_APPLICATION_MODEL = ".freemarker.Application";
    private static final String ATTR_JSP_TAGLIBS_MODEL = ".freemarker.JspTaglibs";
    private static final String ATTR_SESSION_MODEL = ".freemarker.Session";
    private static final String ATTR_REQUEST_MODEL = ".freemarker.Request";
    public static final String KEY_APPLICATION = "Application";
    public static final String KEY_REQUEST_MODEL = "Request";
    public static final String KEY_SESSION_MODEL = "Session";
    public static final String KEY_JSP_TAGLIBS = "JspTaglibs";
    private static FreemarkerManager instance = null;
    static /* synthetic */ Class class$com$opensymphony$webwork$views$freemarker$FreemarkerManager;
    static /* synthetic */ Class class$com$opensymphony$webwork$views$freemarker$FreemarkerResult;

    public static final synchronized FreemarkerManager getInstance() {
        if (instance == null) {
            String classname = (class$com$opensymphony$webwork$views$freemarker$FreemarkerManager == null ? (class$com$opensymphony$webwork$views$freemarker$FreemarkerManager = FreemarkerManager.class$("com.opensymphony.webwork.views.freemarker.FreemarkerManager")) : class$com$opensymphony$webwork$views$freemarker$FreemarkerManager).getName();
            if (com.opensymphony.webwork.config.Configuration.isSet("webwork.freemarker.manager.classname")) {
                classname = com.opensymphony.webwork.config.Configuration.getString("webwork.freemarker.manager.classname").trim();
            }
            try {
                log.info((Object)("Instantiating Freemarker ConfigManager!, " + classname));
                instance = (FreemarkerManager)ObjectFactory.getObjectFactory().buildBean(Class.forName(classname));
            }
            catch (Exception e) {
                log.fatal((Object)("Fatal exception occurred while trying to instantiate a Freemarker ConfigManager instance, " + classname), (Throwable)e);
            }
        }
        if (instance == null) {
            instance = new FreemarkerManager();
        }
        return instance;
    }

    public final synchronized Configuration getConfigruation(ServletContext servletContext) throws TemplateException {
        Configuration config = (Configuration)servletContext.getAttribute(CONFIG_SERVLET_CONTEXT_KEY);
        if (config == null) {
            config = this.createConfiguration(servletContext);
            servletContext.setAttribute(CONFIG_SERVLET_CONTEXT_KEY, (Object)config);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScopesHashModel buildScopesHashModel(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, ObjectWrapper wrapper) {
        HttpRequestHashModel requestModel;
        ScopesHashModel model = new ScopesHashModel(wrapper, servletContext, request);
        ServletContext servletContext2 = servletContext;
        synchronized (servletContext2) {
            ServletContextHashModel servletContextModel = (ServletContextHashModel)servletContext.getAttribute(ATTR_APPLICATION_MODEL);
            if (servletContextModel == null && servletContext.getAttribute("webwork.servlet") != null) {
                servletContextModel = new ServletContextHashModel((GenericServlet)servletContext.getAttribute("webwork.servlet"), wrapper);
                servletContext.setAttribute(ATTR_APPLICATION_MODEL, (Object)servletContextModel);
                TaglibFactory taglibs = new TaglibFactory(servletContext);
                servletContext.setAttribute(ATTR_JSP_TAGLIBS_MODEL, (Object)taglibs);
            }
            model.put(KEY_APPLICATION, servletContextModel);
            model.put(KEY_JSP_TAGLIBS, (TemplateModel)servletContext.getAttribute(ATTR_JSP_TAGLIBS_MODEL));
        }
        if (request.getSession(false) != null) {
            HttpSessionHashModel sessionModel;
            HttpSession session;
            HttpSession httpSession = session = request.getSession();
            synchronized (httpSession) {
                sessionModel = (HttpSessionHashModel)session.getAttribute(ATTR_SESSION_MODEL);
                if (sessionModel == null) {
                    sessionModel = new HttpSessionHashModel(session, wrapper);
                    session.setAttribute(ATTR_SESSION_MODEL, (Object)sessionModel);
                }
            }
            model.put(KEY_SESSION_MODEL, sessionModel);
        }
        if ((requestModel = (HttpRequestHashModel)request.getAttribute(ATTR_REQUEST_MODEL)) == null || requestModel.getRequest() != request) {
            requestModel = new HttpRequestHashModel(request, response, wrapper);
            request.setAttribute(ATTR_REQUEST_MODEL, (Object)requestModel);
        }
        model.put(KEY_REQUEST_MODEL, requestModel);
        return model;
    }

    public void populateContext(ScopesHashModel model, OgnlValueStack stack, Action action, HttpServletRequest request, HttpServletResponse response) {
        model.put(KEY_REQUEST, request);
        model.put(KEY_RESPONSE, response);
        model.put(KEY_STACK, stack);
        model.put(KEY_OGNL, OgnlTool.getInstance());
        model.put(KEY_WEBWORK, new FreemarkerWebWorkUtil(stack, request, response));
        model.put(KEY_ACTION, action);
        Throwable exception = (Throwable)request.getAttribute("javax.servlet.error.exception");
        if (exception == null) {
            exception = (Throwable)request.getAttribute("javax.servlet.error.JspException");
        }
        if (exception != null) {
            model.put(KEY_EXCEPTION, exception);
        }
    }

    protected BeansWrapper getObjectWrapper() {
        BeansWrapper beansWrapper = new BeansWrapper();
        beansWrapper.setSimpleMapWrapper(true);
        return beansWrapper;
    }

    protected TemplateLoader getTemplateLoader(ServletContext servletContext) {
        MultiTemplateLoader multiLoader = new MultiTemplateLoader(new TemplateLoader[]{new WebappTemplateLoader(servletContext), new ClassTemplateLoader(class$com$opensymphony$webwork$views$freemarker$FreemarkerResult == null ? (class$com$opensymphony$webwork$views$freemarker$FreemarkerResult = FreemarkerManager.class$("com.opensymphony.webwork.views.freemarker.FreemarkerResult")) : class$com$opensymphony$webwork$views$freemarker$FreemarkerResult, "/")});
        return multiLoader;
    }

    protected Configuration createConfiguration(ServletContext servletContext) throws TemplateException {
        Configuration configuration = Configuration.getDefaultConfiguration();
        configuration.setTemplateLoader(this.getTemplateLoader(servletContext));
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.HTML_DEBUG_HANDLER);
        configuration.setObjectWrapper((ObjectWrapper)this.getObjectWrapper());
        this.loadSettings(servletContext, configuration);
        return configuration;
    }

    protected void loadSettings(ServletContext servletContext, Configuration configuration) {
        try {
            InputStream in = FileManager.loadFile((String)"freemarker.properties", (Class)(class$com$opensymphony$webwork$views$freemarker$FreemarkerManager == null ? (class$com$opensymphony$webwork$views$freemarker$FreemarkerManager = FreemarkerManager.class$("com.opensymphony.webwork.views.freemarker.FreemarkerManager")) : class$com$opensymphony$webwork$views$freemarker$FreemarkerManager));
            if (in != null) {
                Properties p = new Properties();
                p.load(in);
                configuration.setSettings(p);
            }
        }
        catch (IOException e) {
            log.error((Object)"Error while loading freemarker settings from /freemarker.properties", (Throwable)e);
        }
        catch (TemplateException e) {
            log.error((Object)"Error while loading freemarker settings from /freemarker.properties", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

