/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.webwork.lifecycle;

import com.opensymphony.xwork.interceptor.component.ComponentConfiguration;
import com.opensymphony.xwork.interceptor.component.ComponentManager;
import com.opensymphony.xwork.interceptor.component.DefaultComponentManager;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class ApplicationLifecycleListener
implements ServletContextListener {
    private static final Log log = LogFactory.getLog((Class)(class$com$opensymphony$webwork$lifecycle$ApplicationLifecycleListener == null ? (class$com$opensymphony$webwork$lifecycle$ApplicationLifecycleListener = ApplicationLifecycleListener.class$("com.opensymphony.webwork.lifecycle.ApplicationLifecycleListener")) : class$com$opensymphony$webwork$lifecycle$ApplicationLifecycleListener));
    static /* synthetic */ Class class$com$opensymphony$webwork$lifecycle$ApplicationLifecycleListener;

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext application = event.getServletContext();
        ComponentManager container = (ComponentManager)application.getAttribute("DefaultComponentManager");
        if (container != null) {
            container.dispose();
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext application = event.getServletContext();
        DefaultComponentManager container = this.createComponentManager();
        ComponentConfiguration config = this.loadConfiguration();
        config.configure((ComponentManager)container, "application");
        application.setAttribute("DefaultComponentManager", (Object)container);
        application.setAttribute("ComponentConfiguration", (Object)config);
    }

    protected DefaultComponentManager createComponentManager() {
        return new DefaultComponentManager();
    }

    private ComponentConfiguration loadConfiguration() {
        ComponentConfiguration config = new ComponentConfiguration();
        InputStream configXml = Thread.currentThread().getContextClassLoader().getResourceAsStream("components.xml");
        if (configXml == null) {
            String message = "Unable to find the file components.xml in the classpath.";
            log.error((Object)"Unable to find the file components.xml in the classpath.");
            throw new RuntimeException("Unable to find the file components.xml in the classpath.");
        }
        try {
            config.loadFromXml(configXml);
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
            throw new RuntimeException("Unable to load component configuration");
        }
        catch (SAXException sae) {
            log.error((Object)sae);
            throw new RuntimeException("Unable to load component configuration");
        }
        return config;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

