/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.attachments;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.AttachmentDateComparator;
import com.atlassian.confluence.util.AttachmentNameComparator;
import com.atlassian.confluence.util.AttachmentSizeComparator;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Category;

public class AttachmentsMacro
extends BaseMacro {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$confluence$extra$attachments$AttachmentsMacro == null ? (class$com$atlassian$confluence$extra$attachments$AttachmentsMacro = AttachmentsMacro.class$("com.atlassian.confluence.extra.attachments.AttachmentsMacro")) : class$com$atlassian$confluence$extra$attachments$AttachmentsMacro));
    private AttachmentManager attachmentManager;
    private PermissionManager permissionManager;
    static /* synthetic */ Class class$com$atlassian$confluence$extra$attachments$AttachmentsMacro;
    static /* synthetic */ Class class$com$atlassian$confluence$pages$Attachment;

    public boolean isInline() {
        return false;
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    public String execute(Map map, String string, RenderContext renderContext) throws MacroException {
        Object object;
        Object object2;
        Object object3;
        ContentEntityObject contentEntityObject = ((PageContext)renderContext).getEntity();
        Object object4 = (String)map.get("sortBy");
        HttpServletRequest httpServletRequest = ServletActionContext.getRequest();
        if (httpServletRequest != null && contentEntityObject != null && (object3 = httpServletRequest.getParameter("sortBy")) != null) {
            object4 = object3;
        }
        object3 = new ArrayList();
        if (contentEntityObject.getId() != 0L) {
            object2 = this.getLatestVersionsOfAttachments(contentEntityObject, (String)object4);
            object = (String)map.get("patterns");
            if (object != null) {
                String[] stringArray = ((String)object).split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    Pattern pattern = Pattern.compile(stringArray[i].trim());
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Attachment attachment = (Attachment)iterator.next();
                        if (!pattern.matcher(attachment.getFileName()).matches()) continue;
                        object3.add(attachment);
                    }
                }
            } else {
                object3 = object2;
            }
        }
        object2 = AuthenticatedUserThreadLocal.getUser();
        object = MacroUtils.defaultVelocityContext();
        object.put("latestVersionsOfAttachments", object3);
        object.put("hasAttachFilePermissions", this.permissionManager.hasCreatePermission((User)object2, (Object)contentEntityObject, class$com$atlassian$confluence$pages$Attachment == null ? (class$com$atlassian$confluence$pages$Attachment = AttachmentsMacro.class$("com.atlassian.confluence.pages.Attachment")) : class$com$atlassian$confluence$pages$Attachment));
        object.put("page", contentEntityObject);
        object.put("macro", this);
        object.put("old", this.getBooleanParameter(map, "old", false));
        object.put("upload", this.getBooleanParameter(map, "upload", false));
        object.put("max", new Integer(5));
        object.put("remoteUser", object2);
        try {
            return VelocityUtils.getRenderedTemplate((String)"templates/extra/attachments/attachmentsmacro.vm", (Map)object);
        }
        catch (Exception exception) {
            log.error((Object)"Error while trying to display Attachments!", (Throwable)exception);
            throw new MacroException(exception.getMessage());
        }
    }

    private Boolean getBooleanParameter(Map map, String string, boolean bl) {
        String string2 = (String)map.get(string);
        if (string2 == null) {
            return bl;
        }
        return Boolean.valueOf(string2);
    }

    public List getLatestVersionsOfAttachments(ContentEntityObject contentEntityObject, String string) {
        List list = this.attachmentManager.getLatestVersionsOfAttachments(contentEntityObject);
        if (TextUtils.stringSet((String)string)) {
            if ("date".equals(string)) {
                Collections.sort(list, new AttachmentDateComparator());
                Collections.reverse(list);
            } else if ("size".equals(string)) {
                Collections.sort(list, new AttachmentSizeComparator());
                Collections.reverse(list);
            } else if ("name".equals(string)) {
                Collections.sort(list, new AttachmentNameComparator());
            }
        }
        return list;
    }

    public String[] getAttachmentDetails(Attachment attachment) {
        return new String[]{GeneralUtil.escapeXml((String)attachment.getFileName()), String.valueOf(attachment.getVersion())};
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

