/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.object;

import com.atlassian.util.profiling.UtilTimerStack;
import com.atlassian.util.profiling.object.TimerInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class ObjectProfiler {
    public static Object getProfiledObject(Class interfaceClazz, Object o) {
        if (!UtilTimerStack.isActive()) {
            return o;
        }
        if (interfaceClazz.isInterface()) {
            TimerInvocationHandler timerHandler = new TimerInvocationHandler(o);
            Object proxy = Proxy.newProxyInstance(interfaceClazz.getClassLoader(), new Class[]{interfaceClazz}, (InvocationHandler)timerHandler);
            return proxy;
        }
        return o;
    }

    public static Object profiledInvoke(Method target, Object value, Object[] args) throws Throwable {
        if (!UtilTimerStack.isActive()) {
            try {
                return target.invoke(value, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw e.getTargetException();
                }
                throw e;
            }
        }
        String logLine = new String(ObjectProfiler.getTrimmedClassName(target) + "." + target.getName() + "()");
        UtilTimerStack.push(logLine);
        try {
            Object returnValue = target.invoke(value, args);
            if (returnValue != null && target.getReturnType().isInterface()) {
                Object objectProxy;
                TimerInvocationHandler timerHandler = new TimerInvocationHandler(returnValue);
                Object object = objectProxy = Proxy.newProxyInstance(returnValue.getClass().getClassLoader(), new Class[]{target.getReturnType()}, (InvocationHandler)timerHandler);
                return object;
            }
            Object object = returnValue;
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            UtilTimerStack.pop(logLine);
        }
    }

    public static String getTrimmedClassName(Method method) {
        String classname = method.getDeclaringClass().getName();
        return classname.substring(classname.lastIndexOf(46) + 1);
    }
}

