/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.filters;

import com.atlassian.util.profiling.UtilTimerStack;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class ProfilingFilter
implements Filter {
    private static final String ON_OFF_INIT_PARAM = "activate.param";
    private static final String START_STOP_PARAM = "autostart";
    private static final String DEFAULT_ON_OFF_PARAM = "profile.filter";
    private static String onOffParameter = "profile.filter";
    private FilterConfig filterConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String paramValue = request.getParameter(onOffParameter);
        if (paramValue != null) {
            this.setFilterState(paramValue);
        }
        if (!this.isFilterOn()) {
            chain.doFilter(request, response);
            return;
        }
        String resource = this.getResourceName(request);
        UtilTimerStack.push(resource);
        try {
            chain.doFilter(request, response);
        }
        finally {
            UtilTimerStack.pop(resource);
        }
    }

    private void setFilterState(String paramValue) {
        if ("on".equals(paramValue) || "true".equals(paramValue)) {
            this.turnFilterOn();
        } else if ("off".equals(paramValue) || "false".equals(paramValue)) {
            this.turnFilterOff();
        } else if (paramValue.length() > 0 && Character.isDigit(paramValue.charAt(0))) {
            try {
                this.setFilterThreshhold(Long.parseLong(paramValue));
                this.turnFilterOn();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private String getResourceName(ServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            return (String)request.getAttribute("javax.servlet.include.request_uri");
        }
        return ((HttpServletRequest)request).getRequestURI();
    }

    public void setFilterConfig(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        if (filterConfig.getInitParameter(ON_OFF_INIT_PARAM) != null) {
            System.out.println("[Filter: " + filterConfig.getFilterName() + "] Using parameter [" + filterConfig.getInitParameter(ON_OFF_INIT_PARAM) + "]");
            onOffParameter = filterConfig.getInitParameter(ON_OFF_INIT_PARAM);
        }
        if ("true".equals(filterConfig.getInitParameter(START_STOP_PARAM))) {
            System.out.println("[Filter: " + filterConfig.getFilterName() + "] defaulting to on [" + START_STOP_PARAM + "=true]");
            this.turnFilterOn();
        } else if ("false".equals(filterConfig.getInitParameter(START_STOP_PARAM))) {
            System.out.println("[Filter: " + filterConfig.getFilterName() + "] defaulting to off [" + START_STOP_PARAM + "=false]");
            this.turnFilterOff();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig != null) {
            this.setFilterConfig(filterConfig);
        }
    }

    public void destroy() {
    }

    private boolean isFilterOn() {
        return UtilTimerStack.isActive();
    }

    private void turnFilterOn() {
        System.out.println("[Filter: " + this.filterConfig.getFilterName() + "] Turning filter on [" + onOffParameter + "=on]");
        UtilTimerStack.setActive(true);
    }

    private void setFilterThreshhold(long minTotalTime) {
        System.out.println("[Filter: " + this.filterConfig.getFilterName() + "] setting filter threshhold to " + minTotalTime + "ms");
        UtilTimerStack.setMinTotalTime(minTotalTime);
    }

    private void turnFilterOff() {
        System.out.println("[Filter: " + this.filterConfig.getFilterName() + "] Turning filter off [" + onOffParameter + "=off]");
        UtilTimerStack.setMinTotalTime(0L);
        UtilTimerStack.setActive(false);
    }
}

