/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import com.atlassian.util.profiling.ProfilingTimerBean;

public class UtilTimerStack {
    private static ThreadLocal current = new ThreadLocal();
    public static final String ACTIVATE_PROPERTY = "atlassian.profile.activate";
    public static final String MIN_TIME = "atlassian.profile.mintime";
    public static final String MIN_TOTAL_TIME = "atlassian.profile.mintotaltime";
    private static long configuredMinTime;
    private static long configuredMinTotalTime;

    public static void push(String name) {
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean newTimer = new ProfilingTimerBean(name);
        newTimer.setStartTime();
        ProfilingTimerBean currentTimer = (ProfilingTimerBean)current.get();
        if (currentTimer != null) {
            currentTimer.addChild(newTimer);
        }
        current.set(newTimer);
    }

    public static void pop(String name) {
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean currentTimer = (ProfilingTimerBean)current.get();
        if (currentTimer != null && name != null && name.equals(currentTimer.getResource())) {
            currentTimer.setEndTime();
            ProfilingTimerBean parent = currentTimer.getParent();
            if (parent == null) {
                if (currentTimer.getTotalTime() > UtilTimerStack.getMinTotalTime()) {
                    UtilTimerStack.printTimes(currentTimer);
                }
                current.set(null);
            } else {
                current.set(parent);
            }
        } else if (currentTimer != null) {
            UtilTimerStack.printTimes(currentTimer);
            current.set(null);
            System.out.println("Unmatched Timer.  Was expecting " + currentTimer.getResource() + ", instead got " + name);
        }
    }

    private static void printTimes(ProfilingTimerBean currentTimer) {
        System.out.println(currentTimer.getPrintable(UtilTimerStack.getMinTime()));
    }

    private static long getMinTime() {
        return configuredMinTime > 0L ? configuredMinTime : Long.getLong(MIN_TIME, 0L);
    }

    private static long getMinTotalTime() {
        return configuredMinTotalTime > 0L ? configuredMinTotalTime : Long.getLong(MIN_TOTAL_TIME, 0L);
    }

    public static boolean isActive() {
        return "true".equalsIgnoreCase(System.getProperty(ACTIVATE_PROPERTY));
    }

    public static void setMinTime(long minTime) {
        configuredMinTime = minTime;
    }

    public static void setMinTotalTime(long minTotalTime) {
        configuredMinTotalTime = minTotalTime;
    }

    public static void setActive(boolean active) {
        if (active) {
            System.setProperty(ACTIVATE_PROPERTY, "true");
        } else {
            System.setProperty(ACTIVATE_PROPERTY, "false");
        }
    }
}

