/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProfilingTimerBean
implements Serializable {
    List children = new ArrayList();
    ProfilingTimerBean parent = null;
    String resource;
    long startTime;
    long totalTime;

    public ProfilingTimerBean(String resource) {
        this.resource = resource;
    }

    protected void addParent(ProfilingTimerBean parent) {
        this.parent = parent;
    }

    public ProfilingTimerBean getParent() {
        return this.parent;
    }

    public void addChild(ProfilingTimerBean child) {
        this.children.add(child);
        child.addParent(this);
    }

    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public void setEndTime() {
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    public String getResource() {
        return this.resource;
    }

    public String getPrintable(long minTime) {
        return this.getPrintable("", minTime);
    }

    protected String getPrintable(String indent, long minTime) {
        if (this.totalTime >= minTime) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(indent);
            buffer.append("[").append(this.totalTime).append("ms] - ").append(this.resource);
            buffer.append("\n");
            Iterator childrenIt = this.children.iterator();
            while (childrenIt.hasNext()) {
                buffer.append(((ProfilingTimerBean)childrenIt.next()).getPrintable(indent + "  ", minTime));
            }
            return buffer.toString();
        }
        return "";
    }

    public long getTotalTime() {
        return this.totalTime;
    }
}

