/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.leftnavigation;

import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.leftnavigation.LeftNavSettings;
import com.atlassian.confluence.extra.leftnavigation.SettingsManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.WikiStyleRenderer;
import com.opensymphony.util.TextUtils;

public class LeftNavVelocityHelper {
    public static final String DEFAULT_NAVIGATION_PAGE_NAME = "Navigation";
    private PageManager pageManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private BandanaManager bandanaManager;
    private ThemeManager themeManager;

    public boolean hasNavigation(String string) {
        return this.getNavigationPage(string) != null;
    }

    public String renderNavigation(String string, String string2) {
        Page page = this.getNavigationPage(string);
        if (page == null) {
            return "";
        }
        if (TextUtils.stringSet((String)string2)) {
            Page page2 = this.pageManager.getPage(new Long(string2).longValue());
            return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext((ContentEntityObject)page2), page.getContent());
        }
        return this.wikiStyleRenderer.convertWikiToXHtml((RenderContext)new PageContext(string), page.getContent());
    }

    private Page getNavigationPage(String string) {
        LeftNavSettings leftNavSettings;
        SettingsManager settingsManager = new SettingsManager(this.bandanaManager);
        if (string != null && (leftNavSettings = this.getSpaceLevelSettings(string, settingsManager)) != null) {
            return this.pageManager.getPage(string, leftNavSettings.getPage());
        }
        leftNavSettings = settingsManager.getGlobalThemeSettings();
        if (leftNavSettings != null) {
            String string2 = !TextUtils.stringSet((String)leftNavSettings.getSpace()) ? string : leftNavSettings.getSpace();
            return this.pageManager.getPage(string2, leftNavSettings.getPage());
        }
        return this.pageManager.getPage(string, DEFAULT_NAVIGATION_PAGE_NAME);
    }

    public LeftNavSettings getSpaceLevelSettings(String string, SettingsManager settingsManager) {
        if (this.themeManager.getSpaceThemeKey(string) != null && this.themeManager.getSpaceThemeKey(string).equalsIgnoreCase(settingsManager.THEMEKEY)) {
            LeftNavSettings leftNavSettings = settingsManager.getSpaceThemeSettings(string);
            return leftNavSettings;
        }
        return null;
    }

    public void setPageManager(PageManager pageManager) {
        this.pageManager = pageManager;
    }

    public void setWikiStyleRenderer(WikiStyleRenderer wikiStyleRenderer) {
        this.wikiStyleRenderer = wikiStyleRenderer;
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }
}

