/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server.managers;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.mail.server.managers.AbstractMailServerManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ExtendedBaseRules;
import org.apache.commons.digester.Rules;
import org.apache.log4j.Category;

public class XMLMailServerManager
extends AbstractMailServerManager {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$mail$server$managers$XMLMailServerManager == null ? (class$com$atlassian$mail$server$managers$XMLMailServerManager = XMLMailServerManager.class$("com.atlassian.mail.server.managers.XMLMailServerManager")) : class$com$atlassian$mail$server$managers$XMLMailServerManager));
    Map serverIds;
    private static String DEFAULT_CONFIG_FILE = "mail-servers.xml";
    String configFile;
    static /* synthetic */ Class class$com$atlassian$mail$server$managers$XMLMailServerManager;
    static /* synthetic */ Class class$com$atlassian$mail$server$impl$PopMailServerImpl;
    static /* synthetic */ Class class$com$atlassian$mail$server$impl$SMTPMailServerImpl;
    static /* synthetic */ Class class$com$atlassian$mail$config$ConfigLoader;

    public void init(Map params) {
        this.configFile = DEFAULT_CONFIG_FILE;
        this.serverIds = new HashMap();
        if (params.containsKey("config-file")) {
            this.configFile = (String)params.get("config-file");
        }
        this.configure();
    }

    private void configure() {
        try {
            Digester digester = new Digester();
            digester.push((Object)this);
            digester.setRules((Rules)new ExtendedBaseRules());
            digester.addObjectCreate("mail-servers/pop-server", class$com$atlassian$mail$server$impl$PopMailServerImpl == null ? (class$com$atlassian$mail$server$impl$PopMailServerImpl = XMLMailServerManager.class$("com.atlassian.mail.server.impl.PopMailServerImpl")) : class$com$atlassian$mail$server$impl$PopMailServerImpl);
            digester.addSetProperties("mail-servers/pop-server");
            digester.addBeanPropertySetter("mail-servers/pop-server/?");
            digester.addSetRoot("mail-servers/pop-server", "create");
            digester.addObjectCreate("mail-servers/smtp-server", class$com$atlassian$mail$server$impl$SMTPMailServerImpl == null ? (class$com$atlassian$mail$server$impl$SMTPMailServerImpl = XMLMailServerManager.class$("com.atlassian.mail.server.impl.SMTPMailServerImpl")) : class$com$atlassian$mail$server$impl$SMTPMailServerImpl);
            digester.addSetProperties("mail-servers/smtp-server");
            digester.addBeanPropertySetter("mail-servers/smtp-server/?");
            digester.addBeanPropertySetter("mail-servers/smtp-server/jndi-location", "jndiLocation");
            digester.addSetRoot("mail-servers/smtp-server", "create");
            InputStream is = this.getConfigurationInputStream(this.configFile);
            digester.parse(is);
        }
        catch (Exception e) {
            log.fatal((Object)e, (Throwable)e);
            throw new RuntimeException("Error in mail config: " + e.getMessage());
        }
    }

    protected InputStream getConfigurationInputStream(String resource) {
        return ClassLoaderUtils.getResourceAsStream((String)resource, (Class)(class$com$atlassian$mail$config$ConfigLoader == null ? (class$com$atlassian$mail$config$ConfigLoader = XMLMailServerManager.class$("com.atlassian.mail.config.ConfigLoader")) : class$com$atlassian$mail$config$ConfigLoader));
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public MailServer getMailServer(Long id) {
        return (MailServer)this.serverIds.get(id);
    }

    public MailServer getMailServer(String name) throws MailException {
        if (name == null) {
            throw new MailException("name is null");
        }
        Iterator iterator = this.serverIds.values().iterator();
        while (iterator.hasNext()) {
            MailServer server = (MailServer)iterator.next();
            if (!name.equals(server.getName())) continue;
            return server;
        }
        return null;
    }

    public synchronized Long create(MailServer mailServer) throws MailException {
        Long id = new Long(this.serverIds.size() + 1);
        while (this.serverIds.containsKey(id)) {
            id = new Long(id + 1L);
        }
        mailServer.setId(id);
        this.serverIds.put(id, mailServer);
        return id;
    }

    public void update(MailServer mailServer) throws MailException {
        this.serverIds.put(mailServer.getId(), mailServer);
    }

    public void delete(Long mailServerId) throws MailException {
        if (mailServerId == null) {
            throw new MailException("mailServerId is null");
        }
        if (!this.serverIds.containsKey(mailServerId)) {
            throw new MailException("A mail server with the specified mailServerId does not exist");
        }
        this.serverIds.remove(mailServerId);
    }

    public List getServerNames() throws MailException {
        ArrayList<String> result = new ArrayList<String>();
        Iterator iterator = this.serverIds.values().iterator();
        while (iterator.hasNext()) {
            MailServer server = (MailServer)iterator.next();
            result.add(server.getName());
        }
        return result;
    }

    public List getSmtpMailServers() throws MailException {
        ArrayList<MailServer> result = new ArrayList<MailServer>();
        Iterator iterator = this.serverIds.values().iterator();
        while (iterator.hasNext()) {
            MailServer server = (MailServer)iterator.next();
            if (!(server instanceof SMTPMailServer)) continue;
            result.add(server);
        }
        return result;
    }

    public List getPopMailServers() throws MailException {
        ArrayList<MailServer> result = new ArrayList<MailServer>();
        Iterator iterator = this.serverIds.values().iterator();
        while (iterator.hasNext()) {
            MailServer server = (MailServer)iterator.next();
            if (!(server instanceof PopMailServer)) continue;
            result.add(server);
        }
        return result;
    }

    public SMTPMailServer getDefaultSMTPMailServer() throws MailException {
        List smtpServers = this.getSmtpMailServers();
        if (smtpServers.size() > 0) {
            return (SMTPMailServer)smtpServers.get(0);
        }
        return null;
    }

    public PopMailServer getDefaultPopMailServer() throws MailException {
        List popServers = this.getPopMailServers();
        if (popServers.size() > 0) {
            return (PopMailServer)popServers.get(0);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

