/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.server;

import com.atlassian.mail.server.MailServer;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Category;

public abstract class AbstractMailServer
implements MailServer {
    protected final Category LOG = Category.getInstance(this.getClass());
    private Long id;
    private String name;
    private String description;
    private String hostname;
    private String username = null;
    private String password = null;

    public AbstractMailServer() {
    }

    public AbstractMailServer(Long id, String name, String description, String hostName, String username, String password) {
        this.setId(id);
        this.setName(name);
        this.setDescription(description);
        this.setHostname(hostName);
        this.setUsername(username);
        this.setPassword(password);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
        this.propertyChanged();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.propertyChanged();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.propertyChanged();
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String serverName) {
        this.hostname = serverName;
        this.propertyChanged();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = TextUtils.stringSet((String)username) ? username : null;
        this.propertyChanged();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = TextUtils.stringSet((String)password) ? password : null;
        this.propertyChanged();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractMailServer)) {
            return false;
        }
        AbstractMailServer abstractMailServer = (AbstractMailServer)o;
        if (this.description != null ? !this.description.equals(abstractMailServer.description) : abstractMailServer.description != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(abstractMailServer.id) : abstractMailServer.id != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(abstractMailServer.name) : abstractMailServer.name != null) {
            return false;
        }
        if (this.password != null ? !this.password.equals(abstractMailServer.password) : abstractMailServer.password != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(abstractMailServer.hostname) : abstractMailServer.hostname != null) {
            return false;
        }
        return !(this.username != null ? !this.username.equals(abstractMailServer.username) : abstractMailServer.username != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 29 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 29 * result + (this.hostname != null ? this.hostname.hashCode() : 0);
        result = 29 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 29 * result + (this.password != null ? this.password.hashCode() : 0);
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("name", (Object)this.name).append("description", (Object)this.description).append("server name", (Object)this.hostname).append("username", (Object)this.username).append("password", (Object)this.password).toString();
    }

    protected void propertyChanged() {
    }
}

