/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.mail.config;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.mail.server.MailServerManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigLoader {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$mail$config$ConfigLoader == null ? (class$com$atlassian$mail$config$ConfigLoader = ConfigLoader.class$("com.atlassian.mail.config.ConfigLoader")) : class$com$atlassian$mail$config$ConfigLoader));
    private static final String DEFAULT_CONFIG_FILE = "mail-config.xml";
    private MailServerManager loadedManager;
    static /* synthetic */ Class class$com$atlassian$mail$config$ConfigLoader;

    public ConfigLoader(String file) {
        InputStream is = ClassLoaderUtils.getResourceAsStream((String)file, (Class)(class$com$atlassian$mail$config$ConfigLoader == null ? (class$com$atlassian$mail$config$ConfigLoader = ConfigLoader.class$("com.atlassian.mail.config.ConfigLoader")) : class$com$atlassian$mail$config$ConfigLoader));
        try {
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document xmlDoc = db.parse(is);
            Element root = xmlDoc.getDocumentElement();
            Element manager = (Element)root.getElementsByTagName("manager").item(0);
            Class aClass = ClassLoaderUtils.loadClass((String)manager.getAttribute("class"), this.getClass());
            MailServerManager msm = (MailServerManager)aClass.newInstance();
            HashMap<String, String> params = new HashMap<String, String>();
            NodeList properties = manager.getElementsByTagName("property");
            if (properties.getLength() > 0) {
                for (int i = 0; i < properties.getLength(); ++i) {
                    Element property = (Element)properties.item(i);
                    String name = XMLUtils.getContainedText((Node)property, (String)"name");
                    String value = XMLUtils.getContainedText((Node)property, (String)"value");
                    params.put(name, value);
                }
            }
            msm.init(params);
            this.setLoadedManager(msm);
        }
        catch (Exception e) {
            log.fatal((Object)e, (Throwable)e);
            throw new RuntimeException("Error in mail config: " + e.getMessage());
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e2) {
                log.error((Object)e2);
            }
        }
    }

    public static MailServerManager getServerManager() {
        return ConfigLoader.getServerManager(DEFAULT_CONFIG_FILE);
    }

    public static MailServerManager getServerManager(String file) {
        ConfigLoader configLoader = new ConfigLoader(file);
        return configLoader.getLoadedManager();
    }

    public MailServerManager getLoadedManager() {
        return this.loadedManager;
    }

    public void setLoadedManager(MailServerManager loadedManager) {
        this.loadedManager = loadedManager;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

