/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.livesearch;

import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.AbstractHtmlGeneratingMacro;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.VelocityUtils;
import com.atlassian.renderer.v2.RenderUtils;
import com.opensymphony.util.TextUtils;
import java.io.IOException;
import java.util.Map;
import org.radeox.macro.parameter.MacroParameter;

public class LiveSearchMacro
extends AbstractHtmlGeneratingMacro {
    private SpaceManager spaceManager;

    protected String getHtml(MacroParameter macroParameter) throws IllegalArgumentException, IOException {
        try {
            PageContext pageContext = (PageContext)macroParameter.getContext().getParameters().get("RENDER_CONTEXT");
            String string = macroParameter.get("spaceKey");
            if ("preview".equals(pageContext.getOutputType())) {
                return RenderUtils.error((String)"The livesearch macro cannot be rendered in 'preview' mode.");
            }
            Map map = MacroUtils.defaultVelocityContext();
            if (TextUtils.stringSet((String)string)) {
                map.put("spaceKey", string);
                map.put("space", this.spaceManager.getSpace(string));
            }
            return VelocityUtils.getRenderedTemplate((String)"templates/extra/livesearch/livesearchmacro.vm", (Map)map);
        }
        catch (Exception exception) {
            log.error((Object)"Error while trying to display TaskList!", (Throwable)exception);
            throw new IOException(exception.getMessage());
        }
    }

    public String getName() {
        return "livesearch";
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }
}

