/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.dynamictasklist.model;

import com.atlassian.confluence.extra.dynamictasklist.model.Task;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class TaskList {
    private String name;
    private List tasks;

    public TaskList() {
    }

    public TaskList(String string) {
        this.name = string;
        this.tasks = Collections.synchronizedList(new ArrayList());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List getTasks() {
        return this.tasks;
    }

    public void setTasks(List list) {
        this.tasks = list;
    }

    public int getTotalTasks() {
        return this.tasks.size();
    }

    public int getCompleteTasks() {
        int n = 0;
        Iterator iterator = this.getTasks().iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (!task.isCompleted()) continue;
            ++n;
        }
        return n;
    }

    public int getPercentComplete() {
        int n = this.getCompleteTasks();
        return (int)(100.0f * ((float)n / (float)this.tasks.size()));
    }

    public void addTask(String string) {
        this.tasks.add(new Task(string));
    }

    public Task getTask(String string) {
        Iterator iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (!task.getName().equals(string)) continue;
            return task;
        }
        return null;
    }

    public void removeTask(String string) {
        this.tasks.remove(this.getTask(string));
    }

    public void setTaskIndex(String string, int n) {
        Task task = this.getTask(string);
        if (task != null) {
            try {
                this.tasks.remove(task);
                this.tasks.add(n, task);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.tasks.remove(task);
                this.tasks.add(task);
            }
        }
    }

    public String getNiceName() {
        return this.name.replaceAll("_", " ");
    }
}

