/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.dynamictasklist;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.extra.dynamictasklist.model.TaskList;
import com.atlassian.renderer.v2.SubRenderer;
import com.thoughtworks.xstream.XStream;

public class TaskListManager {
    ContentPropertyManager contentPropertyManager;
    XStream xStream;
    SubRenderer subRenderer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskList getTaskList(ContentEntityObject contentEntityObject, String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String string2 = this.contentPropertyManager.getTextProperty(contentEntityObject, this.createKey(string));
            if (string2 == null) {
                TaskList taskList = new TaskList(string);
                return taskList;
            }
            TaskList taskList = (TaskList)this.xStream.fromXML(string2);
            return taskList;
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    private String createKey(String string) {
        return "atlassian.dynamictasklist:" + string.substring(0, Math.min(string.length() - 1, 100));
    }

    public void setxStream(XStream xStream) {
        this.xStream = xStream;
    }

    public void setContentPropertyManager(ContentPropertyManager contentPropertyManager) {
        this.contentPropertyManager = contentPropertyManager;
    }

    public void setSubRenderer(SubRenderer subRenderer) {
        this.subRenderer = subRenderer;
    }

    public void saveTaskList(ContentEntityObject contentEntityObject, TaskList taskList) {
        this.contentPropertyManager.setTextProperty(contentEntityObject, this.createKey(taskList.getName()), this.xStream.toXML((Object)taskList));
    }
}

