/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.dynamictasklist;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.extra.dynamictasklist.TaskListManager;
import com.atlassian.confluence.extra.dynamictasklist.model.Task;
import com.atlassian.confluence.extra.dynamictasklist.model.TaskList;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.user.User;
import com.opensymphony.util.TextUtils;
import java.util.StringTokenizer;

public class TaskListAction
extends ConfluenceActionSupport {
    private TaskListManager taskListManager;
    private ContentEntityObject entity;
    private String listName;
    private String taskNames;
    private String task;
    private long entityId;
    private ContentEntityManager contentEntityManager;

    public String reorderTasks() {
        if (this.taskNames != null) {
            TaskList taskList = this.getTaskList();
            StringTokenizer stringTokenizer = new StringTokenizer(this.taskNames, ",");
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string = stringTokenizer.nextToken();
                if (!TextUtils.stringSet((String)string)) continue;
                taskList.setTaskIndex(string, n);
                ++n;
            }
            this.taskListManager.saveTaskList(this.getEntity(), taskList);
        }
        return "success";
    }

    public void setTaskNames(String string) {
        this.taskNames = string;
    }

    public String addTask() {
        TaskList taskList = this.getTaskList();
        taskList.addTask(this.task);
        this.taskListManager.saveTaskList(this.getEntity(), taskList);
        return "success";
    }

    public String removeTask() {
        TaskList taskList = this.getTaskList();
        taskList.removeTask(this.task);
        this.taskListManager.saveTaskList(this.getEntity(), taskList);
        return "success";
    }

    public String completeTask() {
        TaskList taskList = this.getTaskList();
        Task task = taskList.getTask(this.task);
        if (task != null) {
            taskList.getTask(this.task).setCompleter(this.getRemoteUser() != null ? this.getRemoteUser().getName() : "");
            this.taskListManager.saveTaskList(this.getEntity(), taskList);
            return "success";
        }
        return "error";
    }

    public String uncompleteTask() {
        TaskList taskList = this.getTaskList();
        Task task = taskList.getTask(this.task);
        if (task != null) {
            taskList.getTask(this.task).setCompleter(null);
            this.taskListManager.saveTaskList(this.getEntity(), taskList);
            return "success";
        }
        return "error";
    }

    public String getRedirectUrl() {
        return this.getEntity().getUrlPath();
    }

    public String getTask() {
        return this.task;
    }

    public void setTask(String string) {
        this.task = string;
    }

    public void setListName(String string) {
        this.listName = string;
    }

    public String getListName() {
        return this.listName;
    }

    private TaskList getTaskList() {
        return this.taskListManager.getTaskList(this.getEntity(), this.listName);
    }

    public void setTaskListManager(TaskListManager taskListManager) {
        this.taskListManager = taskListManager;
    }

    public Task getTaskObject() {
        TaskList taskList = this.getTaskList();
        return taskList.getTask(this.task);
    }

    public void setEntityId(long l) {
        this.entityId = l;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public boolean isPermitted() {
        return GeneralUtil.isSuperUser((User)this.getRemoteUser()) || this.permissionManager.hasPermission(this.getRemoteUser(), Permission.VIEW, (Object)this.getEntity());
    }

    public ContentEntityObject getEntity() {
        if (this.entity == null) {
            this.entity = this.contentEntityManager.getById(this.entityId);
        }
        return this.entity;
    }

    public long getEntityId() {
        return this.entityId;
    }
}

