/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.filters;

import com.atlassian.core.filters.AbstractFilter;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.config.JohnsonConfig;
import com.atlassian.johnson.event.EventCheck;
import com.atlassian.johnson.event.RequestEventCheck;
import com.atlassian.johnson.setup.SetupConfig;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Category;

public class JohnsonFilter
extends AbstractFilter {
    public static final Category log = Category.getInstance((Class)(class$com$atlassian$johnson$filters$JohnsonFilter == null ? (class$com$atlassian$johnson$filters$JohnsonFilter = JohnsonFilter.class$("com.atlassian.johnson.filters.JohnsonFilter")) : class$com$atlassian$johnson$filters$JohnsonFilter));
    public static final String ALREADY_FILTERED = (class$com$atlassian$johnson$filters$JohnsonFilter == null ? (class$com$atlassian$johnson$filters$JohnsonFilter = JohnsonFilter.class$("com.atlassian.johnson.filters.JohnsonFilter")) : class$com$atlassian$johnson$filters$JohnsonFilter).getName() + "_already_filtered";
    public static final String URL_SETUP = "/secure/Setup!default.jspa";
    private FilterConfig filterConfig = null;
    private JohnsonConfig config;
    static /* synthetic */ Class class$com$atlassian$johnson$filters$JohnsonFilter;

    public void init(FilterConfig filterConfig) {
        this.filterConfig = filterConfig;
        this.config = JohnsonConfig.getInstance();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (servletRequest.getAttribute(ALREADY_FILTERED) != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        servletRequest.setAttribute(ALREADY_FILTERED, (Object)Boolean.TRUE);
        JohnsonEventContainer appEventContainer = JohnsonEventContainer.get(this.filterConfig.getServletContext());
        HttpServletRequest req = (HttpServletRequest)servletRequest;
        String servletPath = req.getServletPath();
        String contextPath = req.getContextPath();
        Iterator iterator = this.config.getEventChecks().iterator();
        while (iterator.hasNext()) {
            EventCheck check = (EventCheck)iterator.next();
            if (!(check instanceof RequestEventCheck)) continue;
            ((RequestEventCheck)check).check(appEventContainer, req);
        }
        SetupConfig setup = this.config.getSetupConfig();
        if (appEventContainer.hasEvents() && !this.ignoreURI(servletPath)) {
            log.info((Object)("The application is still starting up, or there are errors.  Redirecting request from '" + servletPath + "' to '" + this.config.getErrorPath() + "'"));
            ((HttpServletResponse)servletResponse).sendRedirect(contextPath + this.config.getErrorPath());
            return;
        }
        if (!(this.ignoreURI(servletPath) || setup.isSetup() || setup.isSetupPage(servletPath))) {
            log.info((Object)("The application is not yet setup.  Redirecting request from '" + servletPath + "' to '" + this.config.getSetupPath() + "'"));
            ((HttpServletResponse)servletResponse).sendRedirect(contextPath + this.config.getSetupPath());
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private boolean ignoreURI(String uri) {
        return uri.equalsIgnoreCase(this.config.getErrorPath()) || this.config.isIgnoredPath(uri);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

