/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.event;

import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Event {
    private EventType key;
    private String desc;
    private String exception;
    private EventLevel level;
    private String date;
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Event(EventType key, String desc) {
        this.key = key;
        this.desc = desc;
        this.date = this.dateFormat.format(new Date(System.currentTimeMillis()));
    }

    public Event(EventType key, String desc, String exception) {
        this.key = key;
        this.desc = desc;
        this.exception = exception;
        this.date = this.dateFormat.format(new Date(System.currentTimeMillis()));
    }

    public Event(EventType key, String desc, EventLevel level) {
        this.key = key;
        this.desc = desc;
        this.level = level;
        this.date = this.dateFormat.format(new Date(System.currentTimeMillis()));
    }

    public Event(EventType key, String desc, String exception, EventLevel level) {
        this.key = key;
        this.desc = desc;
        this.exception = exception;
        this.level = level;
        this.date = this.dateFormat.format(new Date(System.currentTimeMillis()));
    }

    public EventType getKey() {
        return this.key;
    }

    public void setKey(EventType name) {
        this.key = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getException() {
        return this.exception;
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public EventLevel getLevel() {
        return this.level;
    }

    public void setLevel(EventLevel level) {
        this.level = level;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event event = (Event)o;
        if (this.date != null ? !this.date.equals(event.date) : event.date != null) {
            return false;
        }
        if (this.desc != null ? !this.desc.equals(event.desc) : event.desc != null) {
            return false;
        }
        if (this.exception != null ? !this.exception.equals(event.exception) : event.exception != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(event.key) : event.key != null) {
            return false;
        }
        return !(this.level != null ? !this.level.equals(event.level) : event.level != null);
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 29 * result + (this.desc != null ? this.desc.hashCode() : 0);
        result = 29 * result + (this.exception != null ? this.exception.hashCode() : 0);
        result = 29 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 29 * result + (this.date != null ? this.date.hashCode() : 0);
        return result;
    }

    public String toString() {
        System.out.println("Level = " + (this.getLevel() == null ? "" : this.getLevel() + " ") + ", Key = " + (this.getKey() == null ? "" : this.getKey() + " ") + ", Desc = " + (this.getDesc() == null ? "" : this.getDesc() + " ") + ", Exception = " + (this.getException() == null ? "" : this.getException() + " "));
        return "Level = " + (this.getLevel() == null ? "" : this.getLevel() + " ") + ", Key = " + (this.getKey() == null ? "" : this.getKey() + " ") + ", Desc = " + (this.getDesc() == null ? "" : this.getDesc() + " ") + ", Exception = " + (this.getException() == null ? "" : this.getException() + " ");
    }
}

