/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.johnson.config;

import com.atlassian.core.Initable;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.johnson.config.ConfigurationException;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.johnson.setup.SetupConfig;
import com.atlassian.seraph.util.PathMapper;
import com.opensymphony.util.ClassLoaderUtil;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Category;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JohnsonConfig {
    private static final Category log = Category.getInstance((Class)(class$com$atlassian$johnson$config$JohnsonConfig == null ? (class$com$atlassian$johnson$config$JohnsonConfig = JohnsonConfig.class$("com.atlassian.johnson.config.JohnsonConfig")) : class$com$atlassian$johnson$config$JohnsonConfig));
    private static JohnsonConfig instance;
    private static final String DEFAULT_CONFIGURATION_FILE = "johnson-config.xml";
    private String configurationFile;
    private SetupConfig setupConfig;
    private List eventChecks;
    private Map params;
    private String setupPath;
    private String errorPath;
    private PathMapper ignoreMapper;
    private Map eventLevels;
    private Map eventTypes;
    private List ignorePaths;
    static /* synthetic */ Class class$com$atlassian$johnson$config$JohnsonConfig;

    public static JohnsonConfig getInstance() {
        if (instance == null) {
            try {
                if (instance == null) {
                    instance = new JohnsonConfig(DEFAULT_CONFIGURATION_FILE);
                }
            }
            catch (ConfigurationException e) {
                log.error((Object)("Could not configure JohnsonConfig instance: " + (Object)((Object)e)), (Throwable)((Object)e));
            }
        }
        return instance;
    }

    public JohnsonConfig(String configurationFile) throws ConfigurationException {
        this.configurationFile = configurationFile;
        this.init();
    }

    public List getEventChecks() {
        return this.eventChecks;
    }

    public Map getParams() {
        return this.params;
    }

    public SetupConfig getSetupConfig() {
        return this.setupConfig;
    }

    public String getSetupPath() {
        return this.setupPath;
    }

    public String getErrorPath() {
        return this.errorPath;
    }

    public List getIgnorePaths() {
        return this.ignorePaths;
    }

    public boolean isIgnoredPath(String uri) {
        return this.ignoreMapper.get(uri) != null;
    }

    public EventLevel getEventLevel(String level) {
        return (EventLevel)this.eventLevels.get(level);
    }

    public EventType getEventType(String type) {
        return (EventType)this.eventTypes.get(type);
    }

    private void init() throws ConfigurationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            URL fileUrl = ClassLoaderUtil.getResource((String)this.configurationFile, this.getClass());
            if (fileUrl == null) {
                throw new IllegalArgumentException("No such XML file:" + this.configurationFile);
            }
            Document doc = factory.newDocumentBuilder().parse(fileUrl.toString());
            Element rootEl = doc.getDocumentElement();
            this.setupConfig = (SetupConfig)this.configureClass(rootEl, "setupconfig");
            this.eventChecks = this.configureEventChecks(rootEl);
            this.eventLevels = this.configureEventConstants(rootEl, "eventlevels", "eventlevel");
            this.eventTypes = this.configureEventConstants(rootEl, "eventtypes", "eventtype");
            this.params = this.configureParameters(rootEl);
            this.setupPath = (String)this.configurePaths(rootEl, "setup").get(0);
            this.errorPath = (String)this.configurePaths(rootEl, "error").get(0);
            this.ignorePaths = this.configurePaths(rootEl, "ignore");
            this.ignoreMapper = new PathMapper();
            Iterator iterator = this.ignorePaths.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                this.ignoreMapper.put(path, path);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConfigurationException("Exception configuring: " + e);
        }
    }

    private Map configureEventConstants(Element rootEl, String tagname, String childname) {
        NodeList nl = rootEl.getElementsByTagName(tagname);
        if (nl != null && nl.getLength() > 0) {
            Element element = (Element)nl.item(0);
            NodeList children = element.getElementsByTagName(childname);
            HashMap<String, Object> result = new HashMap<String, Object>(children.getLength());
            for (int i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                String key = child.getAttribute("key");
                String description = XMLUtils.getContainedText((Node)child, (String)"description");
                if (childname.equals("eventlevel")) {
                    result.put(key, new EventLevel(key, description));
                    continue;
                }
                if (!childname.equals("eventtype")) continue;
                result.put(key, new EventType(key, description));
            }
            return result;
        }
        return Collections.EMPTY_MAP;
    }

    private List configurePaths(Element rootEl, String tagname) {
        NodeList nl = rootEl.getElementsByTagName(tagname);
        if (nl != null && nl.getLength() > 0) {
            Element element = (Element)nl.item(0);
            NodeList children = element.getElementsByTagName("path");
            ArrayList<String> result = new ArrayList<String>(children.getLength());
            for (int i = 0; i < children.getLength(); ++i) {
                Element child = (Element)children.item(i);
                result.add(((Text)child.getFirstChild()).getData().trim());
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private Map configureParameters(Element rootEl) {
        NodeList nl = rootEl.getElementsByTagName("parameters");
        if (nl.getLength() > 0) {
            Element parametersEl = (Element)nl.item(0);
            return this.getInitParameters(parametersEl);
        }
        return Collections.EMPTY_MAP;
    }

    private Initable configureClass(Element rootEl, String tagname) throws ConfigurationException {
        try {
            NodeList elementList = rootEl.getElementsByTagName(tagname);
            int i = 0;
            if (i < elementList.getLength()) {
                Element authEl = (Element)elementList.item(i);
                String clazz = authEl.getAttribute("class");
                Initable initable = (Initable)ClassLoaderUtil.loadClass((String)clazz, this.getClass()).newInstance();
                Map params = this.getInitParameters(authEl);
                initable.init(params);
                return initable;
            }
        }
        catch (Exception e) {
            throw new ConfigurationException("Could not create: " + tagname + ": ", e);
        }
        return null;
    }

    private List configureEventChecks(Element rootEl) throws ConfigurationException {
        NodeList nl = rootEl.getElementsByTagName("eventchecks");
        if (nl != null && nl.getLength() > 0) {
            Element eventChecksEl = (Element)nl.item(0);
            NodeList eventCheckList = eventChecksEl.getElementsByTagName("eventcheck");
            ArrayList<Initable> result = new ArrayList<Initable>(eventCheckList.getLength());
            for (int i = 0; i < eventCheckList.getLength(); ++i) {
                Element eventCheckEl = (Element)eventCheckList.item(i);
                String eventCheckClazz = eventCheckEl.getAttribute("class");
                if (eventCheckClazz == null || "".equals(eventCheckClazz)) {
                    throw new ConfigurationException("eventcheck element with bad class attribute");
                }
                try {
                    log.debug((Object)("Adding eventcheck of class: " + eventCheckClazz));
                    Initable initable = (Initable)ClassLoaderUtil.loadClass((String)eventCheckClazz, this.getClass()).newInstance();
                    Map params = this.getInitParameters(eventCheckEl);
                    initable.init(params);
                    result.add(initable);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ConfigurationException("Could not create eventcheck: " + eventCheckClazz + ". Exception: " + e);
                }
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    private Map getInitParameters(Element el) {
        HashMap<String, String> params = new HashMap<String, String>();
        NodeList nl = el.getElementsByTagName("init-param");
        for (int i = 0; i < nl.getLength(); ++i) {
            Node initParam = nl.item(i);
            String paramName = XMLUtils.getContainedText((Node)initParam, (String)"param-name");
            String paramValue = XMLUtils.getContainedText((Node)initParam, (String)"param-value");
            params.put(paramName, paramValue);
        }
        return params;
    }

    public static void setInstance(JohnsonConfig johnsonConfig) {
        instance = johnsonConfig;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

