/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform.impl;

import java.util.Map;
import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.transform.EmittingTransformer;
import org.objectweb.asm.Type;

public class AddPropertyTransformer
extends EmittingTransformer {
    private final String[] names;
    private final Type[] types;

    public AddPropertyTransformer(Map props) {
        int size = props.size();
        this.names = props.keySet().toArray(new String[size]);
        this.types = new Type[size];
        for (int i = 0; i < size; ++i) {
            this.types[i] = (Type)props.get(this.names[i]);
        }
    }

    public AddPropertyTransformer(String[] names, Type[] types) {
        this.names = names;
        this.types = types;
    }

    public void end_class() {
        if (!TypeUtils.isAbstract(this.getAccess())) {
            Type[] T = new Type[1];
            for (int i = 0; i < this.names.length; ++i) {
                String fieldName = "$cglib_prop_" + this.names[i];
                this.declare_field(2, fieldName, this.types[i], null, null);
                String property = TypeUtils.upperFirst(this.names[i]);
                CodeEmitter e = this.begin_method(1, new Signature("get" + property, this.types[i], Constants.TYPES_EMPTY), null, null);
                e.load_this();
                e.getfield(fieldName);
                e.return_value();
                e.end_method();
                T[0] = this.types[i];
                e = this.begin_method(1, new Signature("set" + property, Type.VOID_TYPE, T), null, null);
                e.load_this();
                e.load_arg(0);
                e.putfield(fieldName);
                e.return_value();
                e.end_method();
            }
        }
        super.end_class();
    }
}

