/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform.hook;

import net.sf.cglib.core.CodeEmitter;
import net.sf.cglib.core.Constants;
import net.sf.cglib.core.Signature;
import net.sf.cglib.core.TypeUtils;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.EmittingTransformer;
import net.sf.cglib.transform.hook.AbstractPreProcessor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Type;

public class ExamplePreProcessor
extends AbstractPreProcessor {
    private static final Type PRINT_STREAM = TypeUtils.parseType("java.io.PrintStream");
    private static final Signature PRINTLN = TypeUtils.parseSignature("void println(String)");

    protected ClassTransformer getClassTransformer(String name) {
        return new EmittingTransformer(){

            public CodeEmitter begin_method(int access, Signature sig, Type[] exceptions, Attribute attrs) {
                CodeEmitter e = super.begin_method(access, sig, exceptions, attrs);
                if (!TypeUtils.isAbstract(access)) {
                    e.getstatic(Constants.TYPE_SYSTEM, "err", PRINT_STREAM);
                    e.push("Running " + sig.getName() + sig.getDescriptor());
                    e.invoke_virtual(PRINT_STREAM, PRINTLN);
                }
                return e;
            }
        };
    }
}

