/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.AbstractProcessTask;
import net.sf.cglib.transform.ClassReaderGenerator;
import net.sf.cglib.transform.ClassTransformer;
import net.sf.cglib.transform.TransformingGenerator;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public abstract class AbstractTransformTask
extends AbstractProcessTask {
    private boolean verbose;
    private static final EarlyExitException EARLY_EXIT = new EarlyExitException();

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected abstract ClassTransformer getClassTransformer(String var1);

    protected void processFile(File file) throws Exception {
        DebuggingClassWriter w = new DebuggingClassWriter(true);
        String name = AbstractTransformTask.getClassName(file);
        ClassTransformer t = this.getClassTransformer(name);
        if (t != null) {
            new TransformingGenerator(new ClassReaderGenerator(AbstractTransformTask.getClassReader(file), true), t).generateClass(w);
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(((ClassWriter)w).toByteArray());
            fos.close();
            if (this.verbose) {
                System.out.println("Enhancing class " + name);
            }
        }
    }

    private static ClassReader getClassReader(File file) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        ClassReader r = new ClassReader(in);
        ((InputStream)in).close();
        return r;
    }

    private static String getClassName(File file) throws Exception {
        final String[] array = new String[1];
        try {
            AbstractTransformTask.getClassReader(file).accept(new ClassAdapter(null){

                public void visit(int access, String name, String superName, String[] interfaces, String sourceFile) {
                    array[0] = name.replace('/', '.');
                    throw EARLY_EXIT;
                }
            }, true);
        }
        catch (EarlyExitException earlyExitException) {
            // empty catch block
        }
        return array[0];
    }

    private static class EarlyExitException
    extends RuntimeException {
        private EarlyExitException() {
        }
    }
}

