/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.transform;

import java.io.IOException;
import java.io.InputStream;
import net.sf.cglib.core.ClassGenerator;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.transform.ClassFilter;
import net.sf.cglib.transform.ClassReaderGenerator;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;

public abstract class AbstractLoader
extends ClassLoader {
    private ClassFilter filter;
    private ClassLoader classPath;

    protected AbstractLoader(ClassLoader parent, ClassLoader classPath, ClassFilter filter) {
        super(parent);
        this.filter = filter;
        this.classPath = classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class loadClass(String name) throws ClassNotFoundException {
        ClassReader r;
        Class<?> loaded = this.findLoadedClass(name);
        if (loaded != null && loaded.getClassLoader() == this) {
            return loaded;
        }
        if (!this.filter.accept(name)) {
            return super.loadClass(name);
        }
        try {
            InputStream is = this.classPath.getResourceAsStream(name.replace('.', '/') + ".class");
            if (is == null) {
                throw new ClassNotFoundException(name);
            }
            try {
                r = new ClassReader(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name + ":" + e.getMessage());
        }
        try {
            DebuggingClassWriter w = new DebuggingClassWriter(true);
            this.getGenerator(r).generateClass(w);
            byte[] b = ((ClassWriter)w).toByteArray();
            return super.defineClass(name, b, 0, b.length);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    protected ClassGenerator getGenerator(ClassReader r) {
        return new ClassReaderGenerator(r, true);
    }
}

