/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.sf.cglib.core.ClassGenerator;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.DebuggingClassWriter;
import net.sf.cglib.core.DefaultNamingPolicy;
import net.sf.cglib.core.NamingPolicy;
import net.sf.cglib.core.ReflectUtils;
import net.sf.cglib.core.Transformer;

public abstract class AbstractClassGenerator
implements ClassGenerator {
    private static final Object NAME_KEY = new Object();
    private NamingPolicy namingPolicy;
    private Source source;
    private ClassLoader classLoader;
    private String namePrefix;
    private Object key;
    private Transformer transformer;

    protected AbstractClassGenerator(Source source) {
        this.source = source;
    }

    protected void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    protected final String getClassName() {
        return this.getClassName(this.getClassLoader());
    }

    private String getClassName(ClassLoader loader) {
        NamingPolicy np = this.namingPolicy != null ? this.namingPolicy : DefaultNamingPolicy.INSTANCE;
        return np.getClassName(this.namePrefix, this.source.name, this.key, this.getClassNameCache(loader));
    }

    private Set getClassNameCache(ClassLoader loader) {
        return (Set)((Map)this.source.cache.get(loader)).get(NAME_KEY);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setNamingPolicy(NamingPolicy namingPolicy) {
        this.namingPolicy = namingPolicy;
    }

    public void setTransformer(Transformer transformer) {
        this.transformer = transformer;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader t = this.classLoader;
        if (t == null) {
            t = this.getDefaultClassLoader();
        }
        if (t == null) {
            t = this.getClass().getClassLoader();
        }
        if (t == null) {
            throw new IllegalStateException("Cannot determine classloader");
        }
        return t;
    }

    protected abstract ClassLoader getDefaultClassLoader();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object create(Object key) {
        try {
            Object instance = null;
            Source source = this.source;
            synchronized (source) {
                ClassLoader loader = this.getClassLoader();
                HashMap<Object, Object> cache2 = (HashMap<Object, Object>)this.source.cache.get(loader);
                if (cache2 != null) {
                    instance = cache2.get(key);
                } else {
                    cache2 = new HashMap<Object, Object>();
                    cache2.put(NAME_KEY, new HashSet());
                    this.source.cache.put(loader, cache2);
                }
                if (instance == null) {
                    this.key = key;
                    String className = this.getClassName(loader);
                    Class gen = null;
                    try {
                        gen = loader.loadClass(className);
                        if (gen.getClassLoader() != loader) {
                            gen = null;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                    if (gen == null) {
                        DebuggingClassWriter w = new DebuggingClassWriter(true);
                        ClassGenerator cg = this;
                        if (this.transformer != null) {
                            cg = (ClassGenerator)this.transformer.transform(this);
                        }
                        cg.generateClass(w);
                        byte[] b = w.toByteArray();
                        if (!className.equals(w.getClassName())) {
                            throw new IllegalStateException("Class name " + className + " does not match generated name: " + w.getClassName());
                        }
                        this.getClassNameCache(loader).add(className);
                        gen = ReflectUtils.defineClass(className, b, loader);
                    }
                    instance = this.firstInstance(gen);
                    cache2.put(key, instance);
                    return instance;
                }
            }
            return this.nextInstance(instance);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodeGenerationException(e);
        }
    }

    protected abstract Object firstInstance(Class var1) throws Exception;

    protected abstract Object nextInstance(Object var1) throws Exception;

    protected static class Source {
        String name;
        Map cache = new WeakHashMap();

        public Source(String name) {
            this.name = name;
        }
    }
}

