/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.matching;

import electric.xml.Document;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.matching.Equal;
import electric.xml.matching.Greater;
import electric.xml.matching.GreaterOrEqual;
import electric.xml.matching.IConstraint;
import electric.xml.matching.Less;
import electric.xml.matching.LessOrEqual;
import electric.xml.matching.NotEqual;
import electric.xml.matching.Range;
import electric.xml.matching.StartsWith;
import java.util.Hashtable;

public class Compare {
    private static final Hashtable nameToConstraint = new Hashtable();

    private static void initConstraints() {
        Compare.addConstraint(new Equal());
        Compare.addConstraint(new NotEqual());
        Compare.addConstraint(new Greater());
        Compare.addConstraint(new Less());
        Compare.addConstraint(new GreaterOrEqual());
        Compare.addConstraint(new LessOrEqual());
        Compare.addConstraint(new Range());
        Compare.addConstraint(new StartsWith());
    }

    public static void addConstraint(IConstraint constraint) {
        nameToConstraint.put(constraint.getName(), constraint);
    }

    public static IConstraint getConstraint(String name) {
        return (IConstraint)nameToConstraint.get(name);
    }

    public static boolean matches(Document document, Document filter) {
        return Compare.matches(document.getRoot(), filter.getRoot());
    }

    public static boolean matches(Element element, Element filter) {
        if (filter.getPrefix() == null ? !element.getName().equals(filter.getName()) : !element.getQName().equals(filter.getQName())) {
            return false;
        }
        if (!Compare.matches(element.getString(), filter.getString(), filter.getAttributeValue("constraint"))) {
            return false;
        }
        Elements enum2 = filter.getElements();
        if (!enum2.hasMoreElements()) {
            return true;
        }
        Elements enum1 = element.getElements();
        if (!enum1.hasMoreElements()) {
            return false;
        }
        Element[] children1 = new Element[enum1.size()];
        int i = 0;
        while (i < children1.length) {
            children1[i] = enum1.next();
            ++i;
        }
        Element[] children2 = new Element[enum2.size()];
        int i2 = 0;
        while (i2 < children2.length) {
            children2[i2] = enum2.next();
            ++i2;
        }
        int i3 = 0;
        while (i3 < children2.length) {
            int match = -1;
            int j = 0;
            while (j < children1.length) {
                if (Compare.matches(children1[j], children2[i3])) {
                    match = j;
                    break;
                }
                ++j;
            }
            if (match == -1) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    public static boolean matches(String string, String filter, String name) {
        if (filter == null) {
            return true;
        }
        if (string == null) {
            return false;
        }
        if (name == null) {
            return string.equals(filter);
        }
        IConstraint constraint = Compare.getConstraint(name);
        if (constraint == null) {
            return false;
        }
        return constraint.isSatisfiedBy(string, filter);
    }

    public static boolean equals(Document document1, Document document2) {
        return Compare.equals(document1.getRoot(), document2.getRoot());
    }

    public static boolean equals(Element element1, Element element2) {
        if (!element1.getQName().equals(element2.getQName())) {
            return false;
        }
        if (!Compare.equals(element1.getString(), element2.getString())) {
            return false;
        }
        Elements enum1 = element1.getElements();
        Elements enum2 = element2.getElements();
        if (enum1.size() != enum2.size()) {
            return false;
        }
        Element[] children1 = new Element[enum1.size()];
        int i = 0;
        while (i < children1.length) {
            children1[i] = enum1.next();
            ++i;
        }
        Element[] children2 = new Element[enum2.size()];
        int i2 = 0;
        while (i2 < children2.length) {
            children2[i2] = enum2.next();
            ++i2;
        }
        int i3 = 0;
        while (i3 < children1.length) {
            int match = -1;
            int j = 0;
            while (j < children2.length) {
                if (children2[j] != null && Compare.equals(children1[i3], children2[j])) {
                    children2[j] = null;
                    match = j;
                    break;
                }
                ++j;
            }
            if (match == -1) {
                return false;
            }
            ++i3;
        }
        return true;
    }

    public static boolean equals(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1 == null || string2 == null) {
            return false;
        }
        return string1.equals(string2);
    }

    static {
        Compare.initConstraints();
    }
}

