/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.tools;

import electric.util.classloader.ClassLoaders;
import electric.util.command.Commands;
import electric.util.file.FileUtil;
import electric.util.jar.Jar;
import electric.util.product.Product;
import electric.util.string.Strings;
import electric.util.tool.ToolUtil;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.ParseException;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.mapping.ILoaderConstants;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Java2Map
implements ILoaderConstants,
ISchemaConstants {
    private Vector classNames = new Vector();
    private String outputPath = "";
    private boolean readMapFiles = false;
    private String encodingStyle = null;

    public static void main(String[] args) {
        if (args.length == 0) {
            Java2Map.printUsage();
            return;
        }
        try {
            Java2Map java2map = Java2Map.processArgs(args);
            java2map.java2map();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Java2Map.printUsage();
            System.exit(-1);
        }
    }

    private static void printUsage() {
        System.out.println("usage: java2map [-Dname=value]* [-h] classname+ [-i path] [-o dir/jar] [-e encodingStyle] [-x cmdfile]");
        System.out.println();
        System.out.println("where:");
        System.out.println("  -Dname=value = set java system property");
        System.out.println("  classname    = name of java class");
        System.out.println("  -h           = print help and exit");
        System.out.println("  -i path      = input path for map files, '.' by default");
        System.out.println("  -o dir/jar   = output path for map files, '.' by default");
        System.out.println("  -e encodingStyle = the encodingStyle to use for the schema");
        System.out.println("  -x cmdfile   = command file to execute");
        System.out.println();
        System.out.println("examples:");
        System.out.println();
        System.out.println("java2map examples.publish.Exchange");
        System.out.println("  creates map files for examples.publish.Exchange");
    }

    private static Java2Map processArgs(String[] args) throws Throwable {
        Mappings.clear();
        Java2Map java2map = new Java2Map();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                java2map.classNames.addElement(arg);
            } else {
                if (arg.length() == 1) {
                    throw new IllegalArgumentException("a plain - is not a valid argument");
                }
                switch (arg.charAt(1)) {
                    case 'D': {
                        ToolUtil.setProperty(arg);
                        break;
                    }
                    case 'e': {
                        java2map.encodingStyle = Strings.getString("e", args, ++i);
                        break;
                    }
                    case 'h': {
                        Java2Map.printUsage();
                        System.exit(-1);
                    }
                    case 'i': {
                        String mapPath = Strings.getString("i", args, ++i);
                        Mappings.readMappings(mapPath);
                        java2map.readMapFiles = true;
                        break;
                    }
                    case 'o': {
                        java2map.outputPath = Strings.getString("o", args, ++i);
                        break;
                    }
                    case 'x': {
                        String commandFile = Strings.getString("x", args, ++i);
                        Commands.execute(commandFile);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("illegal argument " + arg.charAt(1));
                    }
                }
            }
            ++i;
        }
        return java2map;
    }

    private void java2map() throws IOException, ClassNotFoundException, ParseException {
        if (!this.readMapFiles) {
            Mappings.readMappings();
        }
        if (this.classNames.isEmpty()) {
            throw new IllegalArgumentException("missing class names");
        }
        this.writeFiles();
    }

    private void writeFiles() throws IOException, ClassNotFoundException {
        Hashtable closure = this.getClosure();
        this.writeMappings(closure);
    }

    private Hashtable getClosure() throws ClassNotFoundException, SchemaException {
        Namespaces namespaces = new Namespaces(SchemaProperties.getDefaultSchema(), this.encodingStyle);
        Hashtable closure = new Hashtable();
        Enumeration enumeration = this.classNames.elements();
        while (enumeration.hasMoreElements()) {
            String javaName = (String)enumeration.nextElement();
            Class javaClass = ClassLoaders.loadClass(javaName);
            try {
                javaClass.getConstructor(new Class[0]);
            }
            catch (Exception exception) {
                System.out.println("default no-arg constructor is missing in " + javaName + ". make sure to create the map:factory element in the map file");
            }
            Type type = namespaces.getTypeWithJavaClass(javaClass);
            type.addAllDependencies(closure);
        }
        return closure;
    }

    private void writeMappings(Hashtable closure) throws IOException {
        Document mappings = Java2Map.getMappings(closure);
        this.writeMappings(mappings);
    }

    private static Document getMappings(Hashtable closure) throws SchemaException {
        Document mappings = new Document();
        mappings.addComment(Java2Map.getDescription());
        Element root = mappings.newRoot();
        root.setNamespace("map", SchemaProperties.getTmeMap());
        root.setName("map", "mappings");
        Enumeration enumeration = closure.elements();
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            if (type.isStandard() || type.isInhibit() || type.getName() == null) continue;
            type.appendSchema(root, true);
        }
        return mappings;
    }

    private void writeMappings(Document mappings) throws IOException {
        String firstName = (String)this.classNames.elementAt(0);
        String filename = Strings.getLocalJavaName(firstName);
        String content = mappings.toString();
        if (this.outputPath.endsWith(".jar")) {
            Jar.saveFile(this.outputPath, filename + ".map", content);
        } else {
            if (this.outputPath.length() > 0 && !this.outputPath.endsWith(ILoaderConstants.FILE_SEPARATOR)) {
                this.outputPath = this.outputPath + ILoaderConstants.FILE_SEPARATOR;
            }
            FileUtil.saveFile(this.outputPath, filename, content, ".map");
        }
    }

    private static String getDescription() {
        return "generated by " + Product.getShortDescription() + " (java2map) on " + new Date();
    }
}

