/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.complex;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.java.JavaSource;
import electric.util.string.Strings;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Mappings;
import electric.xml.io.Namespaces;
import electric.xml.io.Type;
import electric.xml.io.complex.ComplexContent;
import electric.xml.io.complex.IFactory;
import electric.xml.io.complex.SimpleContent;
import electric.xml.io.complex.any.AnyAttributeHandler;
import electric.xml.io.complex.factories.CustomFactory;
import electric.xml.io.complex.factories.DefaultFactory;
import electric.xml.io.model.All;
import electric.xml.io.model.Choice;
import electric.xml.io.model.Group;
import electric.xml.io.model.IModel;
import electric.xml.io.model.Sequence;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaAttribute;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaEntry;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class ComplexType
extends Type {
    private IModel model;
    private SchemaAttribute[] attributes = new SchemaAttribute[0];
    private boolean resolvedChildType;
    private boolean isAbstract;
    private IFactory factory;
    private AnyAttributeHandler anyAttributeHandler;
    static /* synthetic */ Class class$java$lang$Object;

    public ComplexType() {
        this.factory = new DefaultFactory(this);
    }

    public ComplexType(Schema schemaObject, String name, Element schemaElement) throws SchemaException {
        this.setSchema(schemaObject);
        if (name != null) {
            this.setJavaName(Mappings.getJavaName(this.getNamespace(), name));
        }
        this.readSchema(schemaElement);
        this.setName(name);
    }

    public ComplexType(Schema schemaObject, String name, Class javaClass) {
        this.setSchema(schemaObject);
        this.setName(name);
        this.setJavaClass(javaClass);
        this.isAbstract = Modifier.isAbstract(javaClass.getModifiers());
        this.factory = new DefaultFactory(this);
    }

    public ComplexType(Schema schemaObject) {
        super.setSchema(schemaObject);
        this.setAnonymous(true);
        this.factory = new DefaultFactory(this);
    }

    public String toString() {
        return "ComplexType( " + this.getQName() + " )";
    }

    public Type getRuntimeType(Object object, Namespaces namespaces) throws SchemaException {
        return this.getType(object.getClass());
    }

    public synchronized IModel getModel() throws SchemaException {
        if (this.resolvedChildType) {
            return this.model;
        }
        this.resolvedChildType = true;
        Class superclass = this.getJavaClass().getSuperclass();
        if (superclass != null && !(class$java$lang$Object == null ? (class$java$lang$Object = ComplexType.class$("java.lang.Object")) : class$java$lang$Object).equals(superclass)) {
            ComplexContent complexContent = new ComplexContent(this);
            complexContent.setBaseType(superclass);
            this.setModel(complexContent);
        } else {
            All sequence = new All(this);
            sequence.setElements(this.getJavaClass());
            this.setModel(sequence);
        }
        return this.model;
    }

    public void setModel(IModel model) throws SchemaException {
        if (this.model != null) {
            throw new SchemaException("complexType " + this.getQName() + " cannot contain multiple model groups.");
        }
        this.model = model;
        this.resolvedChildType = true;
    }

    public void replaceModel(IModel model) {
        this.model = model;
        this.resolvedChildType = true;
    }

    public void setSchema(Schema schema) {
        try {
            if (this.resolvedChildType && this.model != null) {
                this.getModel().setSchema(schema);
            }
        }
        catch (SchemaException exception) {
            exception.printStackTrace();
        }
        super.setSchema(schema);
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].setSchema(schema);
            ++i;
        }
    }

    public void addAttribute(SchemaAttribute attribute) {
        this.attributes = (SchemaAttribute[])ArrayUtil.addElement(this.attributes, attribute);
    }

    public SchemaAttribute[] getAttributes() {
        return this.attributes;
    }

    public SchemaEntry getSchemaEntry(String name) throws SchemaException {
        SchemaElement entry = this.getModel().getSchemaElement(name);
        if (entry != null) {
            return entry;
        }
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].getName().equals(name)) {
                return this.attributes[i];
            }
            ++i;
        }
        return this.getModel().getSchemaAttribute(name);
    }

    public void writeJava(JavaSource source) throws SchemaException {
        String localName = this.getJavaName();
        String packageName = Strings.getJavaPackage(localName);
        if (packageName != null) {
            source.setPackageName(packageName);
            localName = Strings.getLocalJavaName(localName);
        }
        source.setClass("public " + (this.isAbstract ? "abstract " : "") + "class " + localName);
        if (this.getModel() instanceof ComplexContent) {
            Type baseType = ((ComplexContent)this.getModel()).getBaseType();
            String baseTypeName = baseType.getJavaName();
            String basePackage = Strings.getJavaPackage(baseTypeName);
            if (basePackage != null && basePackage.equals(packageName)) {
                baseTypeName = Strings.getLocalJavaName(baseTypeName);
            }
            source.setSuperclass(baseTypeName);
        }
        source.addInterface("java.io.Serializable");
        if (this.getModel() != null) {
            this.getModel().writeJava(source);
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].writeJava(source);
            ++i;
        }
    }

    public void addDependencies(Vector dependencies) throws SchemaException {
        if (this.getModel() != null) {
            this.getModel().addDependencies(dependencies);
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].addDependencies(dependencies);
            ++i;
        }
    }

    public void readSchema(Element schemaElement) throws SchemaException {
        this.setName(schemaElement.getAttributeValue("name"));
        this.isAbstract = Strings.getBoolean(schemaElement.getAttributeValue("abstract"), false);
        String javaName = schemaElement.getAttributeValue(SchemaProperties.getTmeMap(), "class");
        if (javaName != null) {
            this.setJavaName(javaName);
        }
        Elements elements = schemaElement.getElements();
        while (elements.hasMoreElements()) {
            Element child = elements.next();
            if (child.getName().equals("all")) {
                this.setModel(new All(this, child));
                continue;
            }
            if (child.getName().equals("annotation")) continue;
            if (child.getName().equals("anyAttribute")) {
                this.anyAttributeHandler = new AnyAttributeHandler(child, this);
                continue;
            }
            if (child.getName().equals("attribute")) {
                this.addAttribute(new SchemaAttribute(this, child));
                continue;
            }
            if (child.getName().equals("attributeGroup")) continue;
            if (child.getName().equals("choice")) {
                this.setModel(new Choice(this, child));
                continue;
            }
            if (child.getName().equals("complexContent")) {
                this.setModel(new ComplexContent(this, child));
                continue;
            }
            if (child.getName().equals("group")) {
                this.setModel(new Group(this, child));
                continue;
            }
            if (child.getName().equals("sequence")) {
                this.setModel(new Sequence(this, child));
                continue;
            }
            if (child.getName().equals("simpleContent")) {
                this.setModel(new SimpleContent(this, child));
                continue;
            }
            throw new SchemaException("<complexType> " + this.getQName() + " must currently be followed by <all>, <annotation>, <anyAttribute>, <attribute>, <choice>, <complexContent>, <group>, <sequence> or <simpleContent>");
        }
        this.resolvedChildType = true;
        String factoryString = schemaElement.getAttributeValue(SchemaProperties.getTmeMap(), "factory");
        this.factory = factoryString != null ? new CustomFactory(this, schemaElement) : new DefaultFactory(this);
    }

    public void writeSchema(Element element) throws SchemaException {
        this.writeSchema(element, false);
    }

    public void writeSchema(Element element, boolean annotated) throws SchemaException {
        String xsdPrefix = Type.getXSDPrefix(element);
        Element complexType = element.addElement(xsdPrefix, "complexType");
        if (this.getName() != null && (!this.isAnonymous() || annotated)) {
            complexType.setAttribute("name", this.getName());
        }
        if (this.isAbstract) {
            complexType.setAttribute("abstract", "true");
        }
        if (annotated) {
            complexType.setAttribute("map:class", this.getJavaName());
        }
        if (this.getModel() != null) {
            this.getModel().writeSchema(complexType, annotated);
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].writeSchema(complexType, annotated);
            ++i;
        }
        if (this.anyAttributeHandler != null) {
            this.anyAttributeHandler.writeSchema(complexType, annotated);
        }
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        if (this.getModel() != null) {
            this.getModel().writeObject(writer, object);
        }
        int i = 0;
        while (i < this.attributes.length) {
            writer.writeObject(this.attributes[i], object);
            ++i;
        }
        if (this.anyAttributeHandler != null) {
            this.anyAttributeHandler.writeObject(writer, object);
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        if (value.getObject() == null) {
            value.setObject(this.factory.newInstance(reader));
        }
        if (this.getModel() != null) {
            this.getModel().readObject(reader, value);
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].readObject(reader, value);
            ++i;
        }
        if (this.anyAttributeHandler != null) {
            this.anyAttributeHandler.readObject(reader, value);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

