/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.complex;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.java.JavaSource;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.complex.ComplexType;
import electric.xml.io.complex.any.AnyAttributeHandler;
import electric.xml.io.model.All;
import electric.xml.io.model.Choice;
import electric.xml.io.model.Group;
import electric.xml.io.model.IModel;
import electric.xml.io.model.Sequence;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaAttribute;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaEntry;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaLocations;
import java.io.IOException;
import java.util.Vector;

public final class ComplexContent
extends Type
implements IModel {
    private ComplexType complexType;
    private IModel model;
    private SchemaAttribute[] attributes = new SchemaAttribute[0];
    private boolean resolvedChildType;
    private Type baseType;
    private String baseQName;
    private AnyAttributeHandler anyAttributeHandler;

    public ComplexContent(ComplexType complexType, Element schema) throws SchemaException {
        this(complexType);
        this.readSchema(schema);
    }

    public ComplexContent(ComplexType complexType) throws SchemaException {
        this.complexType = complexType;
        this.setSchema(complexType.getSchema());
    }

    public synchronized IModel getModel() throws SchemaException {
        if (this.resolvedChildType) {
            return this.model;
        }
        this.resolvedChildType = true;
        All sequence = new All(this.complexType);
        this.model = sequence;
        sequence.setElements(this.getJavaClass());
        return this.model;
    }

    public synchronized void setModel(IModel model) {
        this.model = model;
        this.resolvedChildType = true;
    }

    public void forceResolution() {
        try {
            this.getBaseType();
        }
        catch (SchemaException exception) {
            // empty catch block
        }
        try {
            this.getModel().forceResolution();
        }
        catch (SchemaException exception) {}
    }

    public void addAttribute(SchemaAttribute attribute) {
        this.attributes = (SchemaAttribute[])ArrayUtil.addElement(this.attributes, attribute);
    }

    public SchemaAttribute[] getAttributes() {
        return this.attributes;
    }

    public SchemaElement getSchemaElement(String name) throws SchemaException {
        SchemaEntry entry;
        SchemaElement element = this.getModel().getSchemaElement(name);
        if (element != null) {
            return element;
        }
        if (this.getBaseType() instanceof ComplexType && (entry = ((ComplexType)this.getBaseType()).getSchemaEntry(name)) instanceof SchemaElement) {
            return (SchemaElement)entry;
        }
        return element;
    }

    public SchemaAttribute getSchemaAttribute(String name) throws SchemaException {
        SchemaEntry entry;
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].getName().equals(name)) {
                return this.attributes[i];
            }
            ++i;
        }
        SchemaAttribute attribute = this.getModel().getSchemaAttribute(name);
        if (this.getBaseType() instanceof ComplexType && (entry = ((ComplexType)this.getBaseType()).getSchemaEntry(name)) instanceof SchemaAttribute) {
            return (SchemaAttribute)entry;
        }
        return attribute;
    }

    public synchronized Type getBaseType() throws SchemaException {
        if (this.baseType == null) {
            this.baseType = this.getNamespaces().getTypeWithQName(this.baseQName);
        }
        return this.baseType;
    }

    public void setBaseType(Class javaClass) throws SchemaException {
        this.baseType = this.complexType.getNamespaces().getTypeWithJavaClass(javaClass);
    }

    public void addDependencies(Vector dependencies) throws SchemaException {
        if (this.getModel() != null) {
            this.getModel().addDependencies(dependencies);
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].addDependencies(dependencies);
            ++i;
        }
        dependencies.addElement(this.getBaseType());
    }

    public void setSchema(Schema schema) {
        super.setSchema(schema);
        try {
            if (this.resolvedChildType && this.model != null) {
                this.getModel().setSchema(schema);
            }
        }
        catch (SchemaException exception) {
            // empty catch block
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].setSchema(schema);
            ++i;
        }
    }

    public void readSchema(Element schema) throws SchemaException {
        Element extension = schema.getElement("extension");
        if (extension == null) {
            throw new SchemaException("<complexContent> in type " + this.complexType.getQName() + " must currently be followed by <extension>");
        }
        this.baseQName = extension.getAttributeValue("base");
        if (this.baseQName == null) {
            throw new SchemaException("<extension> in type " + this.complexType.getQName() + " must include base attribute");
        }
        this.baseQName = extension.getQName(this.baseQName);
        Elements elements = extension.getElements();
        while (elements.hasMoreElements()) {
            Element child = elements.next();
            if (child.getName().equals("all")) {
                this.model = new All(this.complexType, child);
                continue;
            }
            if (child.getName().equals("annotation")) continue;
            if (child.getName().equals("anyAttribute")) {
                this.anyAttributeHandler = new AnyAttributeHandler(child, this);
                continue;
            }
            if (child.getName().equals("attribute")) {
                this.addAttribute(new SchemaAttribute(this.complexType, child));
                continue;
            }
            if (child.getName().equals("choice")) {
                this.model = new Choice(this.complexType, child);
                continue;
            }
            if (child.getName().equals("group")) {
                this.model = new Group(this.complexType, child);
                continue;
            }
            if (child.getName().equals("sequence")) {
                this.model = new Sequence(this.complexType, child);
                continue;
            }
            throw new SchemaException("<extension> in type " + this.complexType.getQName() + " must currently be followed by <all>, <annotation>, <anyAttribute>, <attribute>, <choice>, <group>, or <sequence>");
        }
        this.resolvedChildType = true;
    }

    public void writeSchema(Element element, boolean annotated) throws SchemaException {
        String xsdPrefix = Type.getXSDPrefix(element);
        if (!this.getBaseType().getNamespace().equals(this.getNamespace())) {
            SchemaLocations.appendImport(element.getParentElement(), this.getBaseType().getNamespace(), null);
        }
        Element complexContent = element.addElement(xsdPrefix, "complexContent");
        Element extension = complexContent.addElement(xsdPrefix, "extension");
        extension.setAttribute("base", this.getBaseType().getName(extension));
        if (this.getModel() != null) {
            this.getModel().writeSchema(extension, annotated);
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].writeSchema(extension, annotated);
            ++i;
        }
    }

    public Class getJavaClass() throws SchemaException {
        return this.complexType.getJavaClass();
    }

    public String getJavaName() throws SchemaException {
        return this.complexType.getJavaName();
    }

    public void writeJava(JavaSource source) throws SchemaException {
        if (this.getModel() != null) {
            this.getModel().writeJava(source);
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].writeJava(source);
            ++i;
        }
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        this.getBaseType().writeObject(writer, object);
        if (this.getModel() != null) {
            this.getModel().writeObject(writer, object);
        }
        int i = 0;
        while (i < this.attributes.length) {
            writer.writeObject(this.attributes[i], object);
            ++i;
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        this.getBaseType().readObject(reader, value);
        if (this.getModel() != null) {
            this.getModel().readObject(reader, value);
        }
        int i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].readObject(reader, value);
            ++i;
        }
    }
}

