/*
 * Decompiled with CFR 0.152.
 */
package electric.xml;

import electric.xml.Node;
import java.io.IOException;
import java.io.Writer;

public class NodeWriter {
    protected static int defaultStep = 2;
    protected static String defaultEOL = "\r\n";
    protected Writer writer;
    protected int indent;
    protected int step;
    protected boolean expandEmptyElements;
    protected String eol;

    public NodeWriter(Writer writer) {
        this(writer, 0, false, defaultStep, defaultEOL);
    }

    public NodeWriter(Writer writer, int indent, boolean expandEmptyElements) {
        this(writer, indent, expandEmptyElements, defaultStep, defaultEOL);
    }

    public NodeWriter(Writer writer, int indent, boolean expandEmptyElements, int step, String eol) {
        this.writer = writer;
        this.indent = indent;
        this.expandEmptyElements = expandEmptyElements;
        this.step = step;
        this.eol = eol;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public final boolean isIndenting() {
        return this.indent <= 0;
    }

    public final int getIndent() {
        return this.indent;
    }

    public final void setIndent(int indent) {
        this.indent = indent;
    }

    public final int getStep() {
        return this.step;
    }

    public final void setStep(int step) {
        this.step = step;
    }

    public final void increaseIndent() {
        this.indent += this.step;
    }

    public final void decreaseIndent() {
        this.indent -= this.step;
    }

    public static final void setDefaultStep(int step) {
        defaultStep = step;
    }

    public static final int getDefaultStep() {
        return defaultStep;
    }

    public final String getEOL() {
        return this.eol;
    }

    public final void setEOL(String eol) {
        this.eol = eol;
    }

    public static final void setDefaultEOL(String eol) {
        defaultEOL = eol;
    }

    public static final String getDefaultEOL() {
        return defaultEOL;
    }

    public final boolean getExpandEmptyElements() {
        return this.expandEmptyElements;
    }

    public final void setExpandEmptyElements(boolean flag) {
        this.expandEmptyElements = flag;
    }

    public void write(Node node) throws IOException {
        node.write(this);
    }

    public final void write(String string) throws IOException {
        this.writer.write(string);
    }

    public final void write(String string, int offset, int length) throws IOException {
        this.writer.write(string, offset, length);
    }

    public final void write(char ch) throws IOException {
        this.writer.write(ch);
    }

    public final void write(char[] chars, int offset, int length) throws IOException {
        this.writer.write(chars, offset, length);
    }

    public final void writeIndent() throws IOException {
        int i = 0;
        while (i < this.indent) {
            this.writer.write(32);
            ++i;
        }
    }

    public final void writeEOL() throws IOException {
        this.writer.write(this.eol);
    }

    public void flush() throws IOException {
        this.writer.flush();
    }
}

